### 概览

本文以中科时代 SV33 系列伺服驱动器与 SM32 系列伺服电机的连接拓扑图为示例，详细讲解两者的组网接线方法，适用于新人入门操作与进阶用户参考。操作前请务必阅读安全提示，严格按规范执行。

---

### 安全提示

- 断电操作：所有接线前必须断开系统总电源，避免触电或设备短路损坏。
- 防静电保护：操作时务必佩戴防静电手环，防止静电击穿驱动器或电机内部精密元件。
- 线缆匹配：必须使用中科时代推荐的标准线缆（如动力线、编码器线），禁止混用非标准线缆导致接触不良或过载。
- 接线检查：每步接线后需确认端子对应正确（如 U/V/W 相序、电源正负极），避免接反造成电机反转或驱动器报警。

---

### 教学指导视频

[![](https://resource.helplook.net/docker_production/3648ne/article/FflzXAHv/689e977442f83.jpg)](https://www.bilibili.com/video/BV1avbJzwEth?t=3.1)

操作演示教学视频

---

### 拓扑图

![](https://resource.helplook.net/docker_production/3648ne/article/FflzXAHv/traffic/689e9e7aa2644.png)

教学拓扑图

---

### 工具与设备准备

- 核心设备：中科时代 SV33 系列伺服驱动器、SM32 系列伺服电机、Sx21 工智机（主站）、个人 PC（调试用）。
- 辅助工具：防静电手环、标准线缆（含动力线、编码器线、Mini USB 线）、螺丝刀（锁紧电机连接器用）。

---

### 接线步骤（含线缆指示与操作细节）

#### **步骤 1：佩戴防静电手环**

操作前先佩戴好防静电手环并确保接地，避免静电损伤设备。

#### **步骤 2：电源端子接线（重点线缆指示）**

1. **取出电源端子**：按动驱动器上的电源端子按扣，取出端子模块。
2. **动力电源接入**： 
    - 端子标识 “L1/L2”：接 220V 单相交流电源（主动力输入），插入对应插头并锁紧。
    - 端子标识 “P/B”：接外接制动电阻（若需使用制动功能），确保插头与端子匹配。
    - 端子标识 “P/N”：共直流母线接线（多驱动器组网时使用，单驱动器可暂不接）。
3. **电机动力线连接**： 
    - 端子标识 “U/V/W/P1”：对应电机动力线的 U、V、W 相及 PE（地线），按 “上到下” 顺序依次插入插头（U 对应 U 相，V 对应 V 相，W 对应 W 相，PE 接地线），确保相序正确。
4. **固定电源端子**：接线完成后，按动按扣将电源端子插回驱动器，确认卡紧。

#### **步骤 3：电机编码器线连接**

SM32 电机的编码器线插头为专用接口，直接对准驱动器的编码器接口插入即可（注意插头方向，避免暴力插拔）。

#### **步骤 4：主站与驱动器组网连接（含拓展说明）**

1. **主站连接**：SX21 工智机（主站）的输出线接入 SV33 驱动器的 “CN1” 接口，实现主从通信。
2. **多驱动器拓展**：若需增加驱动器数量，将前一台驱动器的 “CN2” 接口通过线缆连接至下一台驱动器的 “CN1” 接口，依次级联。

#### **步骤 5：调试接口连接**

使用标准 Mini USB 线，一端连接 SV33 驱动器的调试接口，另一端连接个人 PC，用于后续参数配置与调试。

#### **步骤 6：电机连接器固定**

SM32 系列电机采用 “前后触线” 连接器设计，接线完成后需用螺丝刀依次锁紧连接器两侧的螺丝，确保线缆接触牢固，防止振动松脱。

 

操作完成后，建议再次检查所有接线是否牢固、相序是否正确，确认无误后再通电测试。