### 概览

本文以中科时代 SV35 系列伺服驱动器与 SM3 系列带抱闸伺服电机的连接拓扑图为示例，详细讲解两者的组网接线方法，重点强调带抱闸功能接线及STO（安全扭矩关闭）相关操作，适用于新人入门与进阶用户参考。操作前请务必阅读安全提示，严格按规范执行。

---

### 安全提示

- 断电操作：所有接线前必须断开系统总电源，避免触电或设备短路损坏。
- 防静电保护：操作时务必佩戴防静电手环，防止静电击穿驱动器或电机内部精密元件。
- 线缆匹配：必须使用中科时代推荐的标准线缆（如动力线、编码器线），禁止混用非标准线缆导致接触不良或过载。
- 接线检查：每步接线后需确认端子对应正确（如 U/V/W 相序、电源正负极），避免接反造成电机反转或驱动器报警。

---

### 教学指导视频

[![](https://resource.helplook.net/docker_production/3648ne/article/p3X8a7Ab/689ec79461c29.jpg)](https://www.bilibili.com/video/BV1azbHzTEe4?t=1.8)

操作演示教学视频

---

### 拓扑图

![](https://resource.helplook.net/docker_production/3648ne/article/p3X8a7Ab/689ec7e3b1e32.png)

教学拓扑图

---

### 工具与设备准备

- 核心设备：中科时代 SV35 系列伺服驱动器（带 STO 功能）、SM3 系列带抱闸伺服电机、Sx21 工智机（主站）、个人 PC（调试用）。​
- 外接组件：外接制动电阻、外接开关电源（驱动抱闸用）、继电器组件。​
- 辅助工具：防静电手环、标准线缆（含 5 芯电源插头、动力线、编码器线、STO 线缆 / 短接插头、Mini USB 线）、螺丝刀（锁紧连接器及端子用）。

---

### 接线步骤（含线缆指示与操作细节）

步骤 1：佩戴防静电手环​

操作前先佩戴好防静电手环并确保接地，避免静电损伤驱动器、电机编码器及抱闸控制电路。​

步骤 2：电源端子接线（区分控制电源与主电源）​

1. 取出 5 芯电源插头：使用包装盒中配套的 5 芯插头，对应驱动器电源输入端子。​



2. 控制电源接入（L1C/L2C）：将控制电源插头插入驱动器 “L1C”“L2C” 端子，为驱动器控制电路供电。​



3. 主电源接入（L1/L2/L3）：​



- 若为单相 220V 输入：将主电源插头插入 “L1”“L2” 端子。​



- 若为三相 220V 输入：将主电源插头分别插入 “L1”“L2”“L3” 端子（三相需注意相序一致性）。​



步骤 3：外接制动电阻与电机动力线连接​

1. 制动电阻接线（P/B 端子）：将外接制动电阻的线缆插入驱动器 “P”“B” 端子，确保插头牢固（制动电阻用于吸收电机减速时的再生能量，必须正确连接）。​



2. 电机动力线连接（U/V/W/PE）：​



- 松开电机动力线端子底部的固定螺丝，按 “U 相→V 相→W 相→PE（地线）” 顺序接入对应接口。​



- 接线后拧紧底部螺丝，确保动力线与端子紧密接触，防止缺相或过热。​



**步骤 4：带抱闸电机的制动器信号接线（核心易错点）**​

1. 原理说明：SM3 系列带抱闸电机需通过 “BRAKE-OFF” 信号控制抱闸的打开 / 闭合，该信号需外接开关电源及继电器实现。​



2. 接线步骤：​



- 提前将外接开关电源输出端连接至继电器线圈（确保电压匹配，如 DC24V）。​



- 将驱动器的 “BRAKE-OFF” 信号线缆连接至继电器的常开触点。​



- 继电器的另一端连接至电机抱闸的接线端子（形成回路：开关电源→继电器→抱闸线圈）。​



- 检查接线：确保继电器动作时，抱闸线圈能正常通电（抱闸打开），断电时抱闸闭合（电机锁死）。​



步骤 5：编码器接线（含多圈编码器电池安装）​

1. 电池安装：因演示电机为多圈内置编码器，需先将标配电池插入编码器线缆的电池插头（注意正负极，反接会导致编码器数据丢失）。​



2. 编码器线连接：将编码器线缆另一端插入驱动器的 “CN6” 接口，确保插头卡扣扣紧，防止信号中断。​



**步骤 6：STO 功能接线（核心易错点）**​

1. 功能说明：STO 为安全功能，用于紧急情况下切断电机扭矩，带 STO 功能的 SV35 驱动器必须正确接线才能解除报警。​



2. 接线方式：​



- 若需启用 STO 功能：将外部安全回路的 STO 信号线缆接入驱动器 “CN2” 接口（按引脚定义对应连接）。​



- 若暂不启用 STO 功能：必须使用驱动器附赠的STO 短接插头插入 “CN2” 接口（短接安全信号，避免报警）。​



- **警告：未接 STO 线缆或短接插头时，驱动器通电后会立即报 “STO 故障”，无法启动。**​



步骤 7：调试接口与主站组网连接​

1. 调试接口：用标准 Mini USB 线连接驱动器的调试接口与个人 PC，用于后续参数配置（如抱闸延时、STO 响应时间等）。​



2. 主站组网：​



- 第一台驱动器：将 Sx21 工智机（主站）的输出线接入驱动器 “CN3” 接口。​



- 多驱动器拓展：第一台驱动器的 “CN4” 接口（输出）通过线缆连接至第二台驱动器的 “CN3” 接口（输入），依次级联。​



步骤 8：电机连接器锁紧​

SM3 系列电机采用 “前后触线” 连接器设计，接线完成后用螺丝刀依次锁紧连接器两侧的螺丝，确保线缆在振动环境下不松动。



 

操作完成后，建议再次检查所有接线是否牢固、相序是否正确，确认无误后再通电测试。