- 登录工智机实时系统，参考文档[ 如何登录及查看系统](https://help.sinsegye.com.cn/docs/shjkjjai)

- 在终端中输入以下指令，打开grub文件

```sql
sudo vim /etc/default/grub
```
![](https://resource.helplook.net/docker_production/3648ne/article/RuY2aB2d/67ecfacfaf581.png)


**isolcpus：**&#x9694;离出CPU，系统不会自动将任务放到该参数指定的CPU上。要想在该CPU上运行任务，必须手动指定任务到该CPU上。

**nohz：**&#x51CF;少指定核心（0 和 1）上的时钟中断

**nohz\_full：**&#x6307;定哪些CPU进入无滴答状态。减少时钟中断。

**rcu\_nocbs：**&#x52;CU是Linux内核代码中常用的一种多任务同步机制，使用的过程中，会创建内核线程去执行回调，因此需要CPU来执行。使用rcu\_nocbs参数来指定哪些CPU不会用于执行回调代码。

**irqaffinity：**&#x8BBE;置中断亲和性，irqaffinity没有指定的CPU只会进行必要的中断处理。


---
### 以SX51系列为例

- 查看机器grub文件实时核为1，非实时核为0,2,3（isolcpus：此处的值为要隔离的实时核 irqaffinity：此处的值为非实时核）

![](https://resource.helplook.net/docker_production/3648ne/article/RuY2aB2d/67ecfad7cf607.png)


* 想要机器具备高实时的性能，grub文件中的参数需要修改为**isolcpus=0,1,2 nohz\_full=0,1,2 rcu\_nocbs=0,1,2 irqaffinity=3**

* 想要机器具备高算力的性能，grub文件中的参数需要修改为**isolcpus=1 nohz\_full=1 rcu\_nocbs=1 irqaffinity=0,2,3**

* 想要机器具备均衡的性能，grub文件中的参数需要修改为**isolcpus=0,1 nohz\_full=0,1 rcu\_nocbs=0,1 irqaffinity=2,3**

* 文件修改完毕后，终端下输入指令更新grub文件

```sql
sudo update-grub
```

* 以上步骤操作完毕后，需要给工智机断电重启生效

* 机器断电重启后，检查是否生效，可以登录到工智机，输入以下命令检查是否是更改后的值

```sql
cat /proc/cmdline
```

---
### 以SX21系列为例

- 查看机器grub文件实时核为0,1，非实时核为0,2,3（isolcpus：此处的值为要隔离的实时核 irqaffinity：此处的值为非实时核）

![](https://resource.helplook.net/docker_production/3648ne/article/RuY2aB2d/67ecfade2db33.png)


* 想要机器具备高实时的性能，grub文件中的参数需要修改为**isolcpus=0,1,2 nohz\_full=0,1,2 rcu\_nocbs=0,1,2 irqaffinity=3**

* 想要机器具备高算力的性能，grub文件中的参数需要修改为**isolcpus=1 nohz\_full=1 rcu\_nocbs=1 irqaffinity=0,2,3**

* 想要机器具备均衡的性能，grub文件中的参数需要修改为**isolcpus=0,1 nohz\_full=0,1 rcu\_nocbs=0,1 irqaffinity=2,3**

* 文件修改完毕后，终端下输入指令更新grub文件

```sql
sudo update-grub
```

* 以上步骤操作完毕后，需要给工智机断电重启生效

* 机器断电重启后，检查是否生效，可以登录到工智机，输入以下命令检查是否是更改后的值

```sql
cat /proc/cmdline
```

---
### 以SP7010系列为例

- 查看机器grub文件实时核为0,1，非实时核为2,3（isolcpus：此处的值为要隔离的实时核 irqaffinity：此处的值为非实时核）

![](https://resource.helplook.net/docker_production/3648ne/article/RuY2aB2d/67ecfae7685e8.png)


* 想要机器具备高实时的性能，grub文件中的参数需要修改为**isolcpus=0,1,2 nohz\_full=0,1,2 rcu\_nocbs=0,1,2 irqaffinity=3**

* 想要机器具备均衡的性能，grub文件中的参数需要修改为**isolcpus=0,1 nohz\_full=0,1 rcu\_nocbs=0,1 irqaffinity=2,3**

* 文件修改完毕后，终端下输入指令更新grub文件

```sql
sudo update-grub
```

* 以上步骤操作完毕后，需要给工智机断电重启生效

* 机器断电重启后，检查是否生效，可以登录到工智机，输入以下命令检查是否是更改后的值

```sql
cat /proc/cmdline
```

---
### 以SP702X系列为例

- 查看机器grub文件实时核为0,1，非实时核为2,3,4,5（isolcpus：此处的值为要隔离的实时核 irqaffinity：此处的值为非实时核）

![](https://resource.helplook.net/docker_production/3648ne/article/RuY2aB2d/67ecfaf1c8c4c.png)


* 想要机器具备高实时的性能，grub文件中的参数需要修改为**isolcpus=0,1,2 nohz\_full=0,1,2 rcu\_nocbs=0,1,2 irqaffinity=3,4,5**

* 想要机器具备均衡的性能，grub文件中的参数需要修改为**isolcpus=0,1 nohz\_full=0,1 rcu\_nocbs=0,1 irqaffinity=2,3,4,5**

* 文件修改完毕后，终端下输入指令更新grub文件

```sql
sudo update-grub
```

* 以上步骤操作完毕后，需要给工智机断电重启生效

* 机器断电重启后，检查是否生效，可以登录到工智机，输入以下命令检查是否是更改后的值

```sql
cat /proc/cmdline
```