以下以想要把虚拟机的内存大小由12G改为10G为例

- 右击工智机windows桌面的“此电脑”，点击“属性”，可以查看到当前分配给windows的内存大小

![](https://resource.helplook.net/docker_production/3648ne/article/nDOQp6r7/traffic/67ecfec2b62ec.jpg)


![](https://resource.helplook.net/docker_production/3648ne/article/nDOQp6r7/traffic/67ecfeec55bbc.jpg)


- 电脑通过网线直连工智机，登录工智机实时系统，参考文档[ 如何登录及查看系统](https://help.sinsegye.com.cn/docs/ru-he-deng-lu-ji-zha-kan-xi-tong-IGCa)

* 查看grub文件中是否有hugepages参数

  查看grub文件

  ```bash
  cat /etc/default/grub
  ```

  如果存在hugepages参数，则把grub文件中hugepages参数的值改为10G，键盘 i 进入编辑模式，esc 退出编辑模式，:wq 保存并退出

  ```bash
  sudo vim /etc/default/grub
  ```
![](https://resource.helplook.net/docker_production/3648ne/article/nDOQp6r7/67ecff19758d6.png)


  查看grub文件，如果不存在hugepages参数，则grub文件无需做修改。

* 查看虚拟机名称

```sql
sudo virsh list --all
```

如图，可以查看到虚拟机的名称为 win10，此步骤必须查看，不同的系统虚拟机名称不同，具体以在机器中查看到的虚拟机名称为准
![](https://resource.helplook.net/docker_production/3648ne/article/nDOQp6r7/67ecff20b6f6b.png)


* 强制关闭虚拟机（如果在第3步中查看到的虚拟机名称不是win10，指令中的win10替换为第3步实际查看到的虚拟机名称）

```sql
sudo virsh destroy win10   
```

![](https://resource.helplook.net/docker_production/3648ne/article/nDOQp6r7/67ecff4e45ec5.png)

* 编辑虚拟机配置文件

```sql
cd /etc/libvirt/qemu
sudo cp win10_default.xml win10_default.xml.bk   
sudo vim win10_default.xml
```

打开  虚拟机名称\_default.xml  文件后，可以查看到虚拟机的内存大小，机器当前的内存大小为12G，需要改为10G。

b、图片中两处的值需要修改为10485760（计算方式：10G=10\*1024\*1024KB=10485760KB），键盘 i 进入编辑模式，esc 退出编辑模式，:wq 保存并退出

![](https://resource.helplook.net/docker_production/3648ne/article/nDOQp6r7/67ecff58067ad.png)


* 定义虚拟机

```sql
sudo virsh define win10_default.xml
```
![](https://resource.helplook.net/docker_production/3648ne/article/nDOQp6r7/67ecff65e56a6.png)


* 启动虚拟机

```sql
 sudo virsh start win10
```
![](https://resource.helplook.net/docker_production/3648ne/article/nDOQp6r7/67ecff6de61be.png)


* 右击windows桌面的“此电脑”，点击“属性”，可以查看到内存大小是否修改成功（为了保险起见，也可以机器断电重启后再查看下）
![](https://resource.helplook.net/docker_production/3648ne/article/nDOQp6r7/traffic/67ecff94309f9.jpg)