### 问题1：中科时代 SV35 系列伺服驱动器型号命名规则说明

答：SM32系列伺服驱动器型号虽包含多段参数（最长达 13 段），但通过 **“功能模块分段定义”** 逻辑设计，可快速解析产品核心参数，辅助高效选型。

![](https://resource.helplook.net/docker_production/3648ne/article/c1wcU3E8/689067b90d0d8.png)

型号采用 “分段标识 + 横线分隔” 设计，共 13个功能段（①~⑬），各段定义如下：

| **序号** | **功能模块** | **代码及含义说明** |
|---|---|---|
| ① | 产品系列 | - `SM32`：SM32 系列伺服电机 - `SM33`：SM33 系列伺服电机 |
| ② | 法兰尺寸 | - **代码**：`04`、`06`、`08`、`13`、`18` - **含义**：对应法兰安装尺寸（单位：mm）：      - `04`→40mm \| `06`→60mm \| `08`→80mm \| `13`→130mm \| `18`→180mm |
| ③ | 惯量等级 | - **代码**：`A`、`M`、`H` - **含义**：      - `A`：低惯量（响应快，适合高速轻载）     - `M`：中惯量（平衡响应与负载）     - `H`：高惯量（适合大负载、低转速场景） |
| ④ | 电压等级 | - **代码**：`S`、`T` - **含义**：      - `S`：AC220V 单相供电     - `T`：AC380V 三相供电 |
| ⑤ | 额定功率 | - **格式**：`数字 + 后缀（B/C）`，后缀代表 **倍率**：      - `B`：×10（如 `85B` → 85×10 = 850W）     - `C`：×100（如 `15C` → 15×100 = 1500W，注：此处为转速示例，功率逻辑相同） |
| ⑥ | 额定转速 | - **格式**：`数字 + 后缀（B/C）`，后缀代表 **倍率**：      - `B`：×10（如 `10B` → 10×10 = 100rpm）     - `C`：×100（如 `15C` → 15×100 = 1500rpm） |
| ⑦ | 编码器类型 | - **代码**：`M`、`N`、`P` - **含义**：      - `M`：17bit 单圈磁编（精度适中，成本低）     - `N`：17bit 多圈磁编（支持多圈位置记忆）     - `P`：23bit 多圈光编（高精度，抗干扰强） |
| ⑧ | 接口类型 | - **代码**：`C`、`H`、`T`、`S` - **含义**：      - `C`：导线引出型（直接接线，简单通用）     - `H`：航空插座（快速插拔，适合频繁维护）     - `T`：连接器型（标准化接口，便于系统集成）     - `S`：螺丝端子型（接线稳定，适合工业环境） |
| ⑨ | 键槽类型 | - **代码**：`0`、`1` - **含义**：      - `0`：光轴（无键槽，需抱紧装置）     - `1`：带键槽（通过键连接，扭矩传递更可靠） |
| ⑩ | 抱闸 | - **代码**：`N`、`B` - **含义**：      - `N`：无抱闸（依赖外部制动）     - `B`：带抱闸（断电自锁，防止负载滑落） |
| ⑪ | 油封 | - **代码**：`0`、`1` - **含义**：      - `0`：无油封（适合清洁环境）     - `1`：带油封（防尘、防油污，适应恶劣环境） |
| ⑫ | 散热方式 | - **代码**：`（空缺）`、`F`、`W` - **含义**：      - 空缺：自然冷却（默认，适合低功率或常温场景）     - `F`：风冷散热（主动散热，提升功率密度）     - `W`：水冷散热（高效散热，适合高负载连续运行） |
| ⑬ | 选配功能 | - **代码**：`（空缺）` - **含义**：      - 空缺：标准型（无特殊功能，满足常规需求） |

以（ SM32 13 - H S 85B 15C - N H 1 B 1 - 为例）

该电机为 **SM32 系列**，130mm 法兰，**高惯量** 设计，适配 **AC220V** 电源，额定功率 **850W**、转速 **1500rpm**；配置 **17bit 多圈磁编** 和 **航空插座接口**，机械端带 **键槽、抱闸、油封**，散热方式为 **自然冷却**，属标准配置机型。

详细说明：

【SM32】【13】【H】【S】【85B】【15C】【N】【H】【1】【B】【1】【空缺】【空缺】

| 位置 | 代码 | 参数含义 | 计算 / 解释 |
|---|---|---|---|
| ① | SM32 | 产品系列 | SM32 系列电机 |
| ② | 13 | 法兰尺寸 | 130mm 法兰 |
| ③ | H | 惯量等级 | 高惯量 |
| ④ | S | 电压等级 | AC220V |
| ⑤ | 85B | 额定功率 | 85×10 = 850W |
| ⑥ | 15C | 额定转速 | 15×100 = 1500rpm |
| ⑦ | N | 编码器类型 | 17bit 多圈磁编 |
| ⑧ | H | 接口类型 | 航空插座 |
| ⑨ | 1 | 键槽类型 | 带键槽 |
| ⑩ | B | 抱闸 | 带抱闸（断电自锁） |
| ⑪ | 1 | 油封 | 带油封（防尘防油污） |
| ⑫ | 空缺 | 散热方式 | 自然冷却 |
| ⑬ | 空缺 | 选配功能 | 标准型（无特殊定制） |