### 概述

Socat 是一种可以把串口转为以太网的命令行工具，是开源免费的，支持TCP server, TCP Client, UDP， Linux 和windows均有版本。

* **windows下的版本:**

[socat-1.8.0.0\_windows.zip](files/socat-1.8.0.0_windows.zip)

* **Linux下的版本：**

```shell
sudo apt-get install socat
```
---

### Socat应用举例
![](https://resource.helplook.net/docker_production/3648ne/article/h9D0q2iv/67f3412e7399f.png)


- 工智机系统中安装socat软件
  在线安装

   ```bash
   apt-get install -y socat 
   ```

   离线安装

   [socat\_1.7.3.3-2\_amd64.deb](files/socat_1.7.3.3-2_amd64.deb)

   ```bash
   dpkg -i socat_1.7.3.3-2_amd64.deb
   ```
- 准备windows端串口工具


* 搭建测试环境

  硬件连接
  windows通过usb转485线 连接工智机，工智机上串口接线图参照
![](https://resource.helplook.net/docker_production/3648ne/article/h9D0q2iv/67f34141f3cae.jpg)

 linux端，打开终端，执行命令

  ```bash
  sudo socat TCP-LISTEN:9011,reuseaddr,fork FILE:/dev/ttyS6,b115200,raw,echo=0
  黄色部分为监听端口号，可修改
  ```

  * windows端，打开串口工具软件
    串口端：红色箭头所示的COM口，需要选择实际检测到COM口
![](https://resource.helplook.net/docker_production/3648ne/article/h9D0q2iv/67f3414a83d8a.png)


    TCP client端 ，需要设置IP 和端口号，其他参照图中所示设置
![](https://resource.helplook.net/docker_production/3648ne/article/h9D0q2iv/67f3415369737.png)


    测试效果图参考：
    TCP client端发送数据，会发现串口端收到数据。
![](https://resource.helplook.net/docker_production/3648ne/article/h9D0q2iv/67f3415a2503e.png)
串口端发送数据，TCP client端 收到数据。
![](https://resource.helplook.net/docker_production/3648ne/article/h9D0q2iv/67f341615946f.png)