### VGA接口说明

1. ​**信号类型：​**​ 模拟RGB (红、绿、蓝) + 水平同步(H-Sync) + 垂直同步(V-Sync)
2. ​**支持分辨率：​**​ 
    - 兼容主流分辨率，最高支持至 ​**1920x1080@60Hz (全高清)​**。
    - 其他常见分辨率如：640x480, 800x600, 1024x768, 1280x1024, 1366x768 等。
3. ​**色彩深度：​**​ 支持高色彩显示（最高可达24位真彩色/1677万色）。
4. ​**接口形状：​**​ 梯形（防呆设计），15个针孔呈三排分布（上排5孔，中排5孔，下排5孔）。
5. ​**连接器：​**​ 标准VGA线缆（公头），带螺钉/卡扣紧固装置。

引脚定义
----

| 针脚 | 信号名称 | 功能描述 |
|---|---|---|
| 1 | RED | 红色视频信号 |
| 2 | GREEN | 绿色视频信号 |
| 3 | BLUE | 蓝色视频信号 |
| 4 | N/C / ID2 | 未连接 / 监视器ID位2 (可选) |
| 5 | GND | 地线 (自检测用) |
| 6 | RGND | 红色地线 |
| 7 | GGND | 绿色地线 |
| 8 | BGND | 蓝色地线 |
| 9 | N/C / +5V | 未连接 / +5V (可选, 电源) |
| 10 | SGND | 同步信号地线 |
| 11 | ID0 / RES | 监视器ID位0 / 保留 (可选) |
| 12 | ID1 / SDA | 监视器ID位1 / DDC数据 (可选) |
| 13 | HSYNC | ​**水平同步信号**​ |
| 14 | VSYNC | ​**垂直同步信号**​ |
| 15 | ID3 / SCL | 监视器ID位3 / DDC时钟 (可选) |



*(注：N/C 表示通常未连接。DDC (显示器数据通道) 功能为可选，用于即插即用识别显示器能力)。*

​**提示：​**​

- ​**非热插拔接口：​**​ ​**强烈建议**在连接或断开VGA线缆时，关闭SP5040和显示设备的电源。热插拔可能导致瞬时电流冲击，存在损坏设备接口或图像异常的风险。
- ​**图像质量：​**​ VGA为模拟信号传输，图像质量会受线缆质量、长度和电磁干扰（EMI）影响。建议使用屏蔽良好、长度适中的高品质VGA线缆（建议不超过10-15米）。线缆过长可能导致信号衰减，图像模糊、拖影或偏色。
- **分辨率与刷新率：​**​ 支持的显示分辨率和刷新率取决于SP5040的显示输出设置（通常通过操作系统或设备菜单调整）以及所连接显示器的最大支持能力。如果显示器提示“信号超出范围”或黑屏，请尝试启动SP5040进入安全模式或使用更低的分辨率/刷新率设置。部分老式显示器可能无法支持较高分辨率（如1080p）。
- ​**接口清洁：​**​ 如发现接口接触不良或图像闪烁，可关闭电源后检查接口内是否有灰尘杂物，并用洁净的压缩空气或无绒布小心清洁。