**功能列表**
带*号的为正在开发中的功能：

- 使用URL统一描述通信协议和资源属性
- 面向通信模型而非通信协议的设计理念
- 极其简约的接口设计
- 混合多协议支持，面向全场景数据流（ZeroMQ，SHM）*
- 多语言支持，Rust/Golang等*
- 信息安全TLS支持*
- 数据捕获和所有协议引流到外部的支持，方便针对所有数据周期抓包、调试*
- 存储和持久化支持*

---

**SMQ的版本迭代计划**

- **1.0**：整合SHM通信协议，具备pub/sub、req/rep两种通信模型，使用Protobuf作为序列化协议。
- **1.5**：整合DDS等通信协议，持久化支持，协议间转换支持。
- **2.0**：多语言支持（Golang/C#/Rust），Protobuf/FlatBuffers等多元的序列化协议适配层支持。
- **3.0**：TLS支持，功能安全认证。

---

这份计划表明了SMQ系统在不断发展中，将通过引入新技术和支持多种协议、语言来提升系统的扩展性和安全性。

### 术语和缩写 {#TermsAndAbbreviations}

| 术语或缩写 | 含义                                         | 说明                                                                                                                                                                                      |
| ---------- | -------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| SOA        | Service Oriented Architecture 面向服务的架构 | 一种粗粒度、松耦合服务架构，服务之间通过**简单、精确定义接口**进行通讯，**不涉及底层编程接口和通讯模型**。                                                                                |
| DDS        | FastDDs 一个开源的消息传输库                 | 是一个高性能的实时发布-订阅中间件，它基于 DDS（Data Distribution Service）标准。DDS是一种面向数据的中间件标准，广泛应用于需要高性能和低延迟的数据通信领域，如自动驾驶、航空航天和机器人等 |
| SHM        | Shared Memory 共享内存                       | 同一台机器上两个进程间通过映射同一块内存区域进行数据交换                                                                                                                                  |

### URL格式定义 {#URLFormat}

![](https://resource.helplook.net/docker_production/3648ne/article/yydl96hK/cc6c1678562acd342a3ede26f4ee9ed2.png)

| protocol |  scheme  | authority | path[0]~path[n-1] | path[n] | query | example                                           |
| :------: | :------: | :-------: | :---------------: | :-----: | :---- | :------------------------------------------------ |
|   shm    | shm/shms | shm name  |       topic       | version | N/A   | shm://canservice/tp/v2<br>shms://canservice/tp/v2 |
|   dds    |   dds    | device_Id |       topic       | version | N/A   | dds://device_id/topic/v1                          |