### 日志标准化Api提供
`Slog`
#### 简介
为MetaOS提供的c/c++日志库，负责日志写入

#### 功能
- 支持C/C++ 接口
- 满足公司内部格式化要求
- 线程安全
- 支持输出到stderr, syslog
- Backtrace 支持 （待开发）
- 支持Linux, Windows 操作系统

#### 日志文件类型
- APPLICATION,         /* Application log */ 应用程序
- SERVICE,             /* Service log */ 守护进程
- IO_DEVICES,          /* IO devices log */ IO 设备日志
- COMMUNICATION_BUS,   /* Communication bus log */ 总线相关的日志
- SAFETY_SYSTEMS,      /* Safety systems log */ 安全模块相关的日志
- RUNTIME,             /* Codesys runtime log */ RTE相关的日志
- SYSTEM_MAINTENANCE,  /* System maintenance and diagnosis */ 系统维护模块的日志
- TEMPORARY_DEBUGGING, /* Temporary debugging log */ 临时日志，开发阶段可以使用

#### 日志等级
- TRACE < Trace logging level. >
- DEBUG < Debug logging level. >
- INFO  < Information logging level. >
- WARN  < Warning logging level. >
- ERR   < Error logging level. >
- FATAL < Fatal logging level. >

C使用示例,C++使用示例
```
// C style
#include "slog/slog.h"

int main() {
  const int int_value = 42;
  const float float_value = 3.14159;
  const char char_value = 'A';
  const char* string_value = "Hello, world!";

  SLOG_DEFAULT_LEVEL_C(SLOG_TRACE);
  ## 模块（标签）
  const char* tag = "cstyle.print_demo";
  ## 打开/关闭输出控制台
  SLOG_SET_QUIET_C(false);  // disable stdout output

  SLOG_FATAL_C(tag, "Integer: %d", int_value);
  SLOG_ERROR_C(tag, "Float: %f", float_value);
  ## 日志输出类型(与日志目录绑定)
  SLOG_SYSLOG_ENABLE_C(APPLICATION);  // syslog output

  SLOG_DEBUG_C(tag, "Character: %c", char_value);
  SLOG_INFO_C(tag, "String: %s", string_value);

  SLOG_TRACE_C(tag, "Formatted integer: %5d", int_value);
  SLOG_TRACE_C(tag, "Formatted float: %.2f", float_value);
  ## 关闭输出到syslog  
  SLOG_SYSLOG_DISABLE_C();
  return 0;
}
```

>C 日志控制台输出内容 
```
2024-09-25 17:24:19.473 DEBUG /home/sinsegye/workspace/apps/src/logger/logger.cc:53 slog.syslog: enabled
2024-09-25 17:24:19.473 FATAL /home/sinsegye/workspace/apps/test/selftest/test.c:22 cstyle.print_demo: Integer: 42
2024-09-25 17:24:19.473 ERROR /home/sinsegye/workspace/apps/test/selftest/test.c:23 cstyle.print_demo: Float: 3.141590
2024-09-25 17:24:19.473 DEBUG /home/sinsegye/workspace/apps/src/logger/logger.cc:53 slog.syslog: enabled
2024-09-25 17:24:19.473 DEBUG /home/sinsegye/workspace/apps/test/selftest/test.c:27 cstyle.print_demo: Character: A
2024-09-25 17:24:19.473 INFO /home/sinsegye/workspace/apps/test/selftest/test.c:28 cstyle.print_demo: String: Hello, world!
2024-09-25 17:24:19.473 TRACE /home/sinsegye/workspace/apps/test/selftest/test.c:30 cstyle.print_demo: Formatted integer:    42
2024-09-25 17:24:19.473 TRACE /home/sinsegye/workspace/apps/test/selftest/test.c:31 cstyle.print_demo: Formatted float: 3.14
2024-09-25 17:24:19.473 DEBUG /home/sinsegye/workspace/apps/src/logger/logger.cc:59 slog.syslog: disabled
```
>C 日志syslog输出内容
cat /log/`application`/application.log (路径与代码syslog_enable指定类型有关系)
```
[2024-09-25 17:24:19.4743] [sinsegye-gj] [debug] slog_c_style[2336069]: slog.syslog: enabled
[2024-09-25 17:24:19.4746] [sinsegye-gj] [crit] slog_c_style[2336069]: cstyle.print_demo: Integer: 42
[2024-09-25 17:24:19.4747] [sinsegye-gj] [err] slog_c_style[2336069]: cstyle.print_demo: Float: 3.141590
[2024-09-25 17:24:19.4747] [sinsegye-gj] [debug] slog_c_style[2336069]: slog.syslog: enabled
[2024-09-25 17:24:19.4748] [sinsegye-gj] [debug] slog_c_style[2336069]: cstyle.print_demo: Character: A
[2024-09-25 17:24:19.4749] [sinsegye-gj] [info] slog_c_style[2336069]: cstyle.print_demo: String: Hello, world!
[2024-09-25 17:24:19.4749] [sinsegye-gj] [debug] slog_c_style[2336069]: cstyle.print_demo: Formatted integer:    42
[2024-09-25 17:24:19.4750] [sinsegye-gj] [debug] slog_c_style[2336069]: cstyle.print_demo: Formatted float: 3.14
[2024-09-25 17:24:19.4751] [sinsegye-gj] [debug] slog_c_style[2336069]: slog.syslog: disable
```


```
#include <thread>

#include "slog/slog.hpp"

auto main() -> int {
  const int int_value{42};
  const float float_value{3.14159};
  const char char_value{'A'};
  const std::string string_value{"Hello, world!"};
  const auto level = slog::SlogLevel::TRACE;
  SLOG_DEFAULT_LEVEL(level);
  ## 模块（标签）
  const std::string tag{"cppstyle.print_demo"};
  ## 打开/关闭输出控制台
  SLOG_SET_QUIET(false);

  SLOG_FATAL(tag, "Integer: %d", int_value);
  SLOG_ERROR(tag, "Float: %f", float_value);

  ## 日志输出类型(与日志目录绑定)
  SLOG_SYSLOG_ENABLE(slog::SyslogType::SERVICE);  // syslog output

  SLOG_DEBUG(tag, "Character: %c", char_value);
  SLOG_INFO(tag, "String: %s", string_value.c_str());

  SLOG_TRACE(tag, "Formatted integer: %5d", int_value);
  SLOG_TRACE(tag, "Formatted float: %.2f", float_value);
  ## 关闭输出到syslog  
  SLOG_SYSLOG_DISABLE();
  return 0;
}
```
>C++ 日志输出内容
```
2024-09-25 17:24:56.527 DEBUG /home/sinsegye/workspace/apps/src/logger/logger.cc:53 slog.syslog: enabled
2024-09-25 17:24:56.527 FATAL /home/sinsegye/workspace/apps/test/selftest/test.cc:17 cppstyle.print_demo: Integer: 42
2024-09-25 17:24:56.527 ERROR /home/sinsegye/workspace/apps/test/selftest/test.cc:18 cppstyle.print_demo: Float: 3.141590
2024-09-25 17:24:56.527 DEBUG /home/sinsegye/workspace/apps/src/logger/logger.cc:53 slog.syslog: enabled
2024-09-25 17:24:56.528 DEBUG /home/sinsegye/workspace/apps/test/selftest/test.cc:22 cppstyle.print_demo: Character: A
2024-09-25 17:24:56.528 INFO /home/sinsegye/workspace/apps/test/selftest/test.cc:23 cppstyle.print_demo: String: Hello, world!
2024-09-25 17:24:56.528 TRACE /home/sinsegye/workspace/apps/test/selftest/test.cc:25 cppstyle.print_demo: Formatted integer:    42
2024-09-25 17:24:56.528 TRACE /home/sinsegye/workspace/apps/test/selftest/test.cc:26 cppstyle.print_demo: Formatted float: 3.14
2024-09-25 17:24:56.528 DEBUG /home/sinsegye/workspace/apps/src/logger/logger.cc:59 slog.syslog: disabled
```
>C++ 日志syslog输出内容
cat /log/`service`/service.log (路径与代码syslog_enable指定类型有关系)
```
[2024-09-25 17:24:56.5286] [sinsegye-gj] [debug] slog_cpp_style[2336567]: slog.syslog: enabled
[2024-09-25 17:24:56.5289] [sinsegye-gj] [crit] slog_cpp_style[2336567]: cppstyle.print_demo: Integer: 42
[2024-09-25 17:24:56.5290] [sinsegye-gj] [err] slog_cpp_style[2336567]: cppstyle.print_demo: Float: 3.141590
[2024-09-25 17:24:56.5290] [sinsegye-gj] [debug] slog_cpp_style[2336567]: slog.syslog: enabled
[2024-09-25 17:24:56.5290] [sinsegye-gj] [debug] slog_cpp_style[2336567]: cppstyle.print_demo: Character: A
[2024-09-25 17:24:56.5290] [sinsegye-gj] [info] slog_cpp_style[2336567]: cppstyle.print_demo: String: Hello, world!
[2024-09-25 17:24:56.5290] [sinsegye-gj] [debug] slog_cpp_style[2336567]: cppstyle.print_demo: Formatted integer:    42
[2024-09-25 17:24:56.5291] [sinsegye-gj] [debug] slog_cpp_style[2336567]: cppstyle.print_demo: Formatted float: 3.14
[2024-09-25 17:24:56.5291] [sinsegye-gj] [debug] slog_cpp_style[2336567]: slog.syslog: disable
```
 

#### 使用说明

- tag 区分日志内容

```
tag{"cstyle.print_demo"}; 日志关键信息
tag{"cppstyle.print_demo"}; 日志关键信息
```