### DPDK-Ethercat-Demo

#### 1. 创建主程序

``` shell
DpdkEthercat dpdk = {
            .portid = 0,
            .lcore_id = RTE_MAX_LCORE,
            .delay_µs = 0,
            .sync_interval = rte_get_timer_hz() / 1000
        };


int main(int argc, char *argv[]) {
    // 初始化EAL(环境抽象层)
    if (rte_eal_init(argc, argv) < 0) {
        rte_exit(EXIT_FAILURE, "Error with EAL initialization\n");
    }
    
    // 初始化定时器子系统
    rte_timer_subsystem_init();
    // 初始化一个具体的定时器对象
    rte_timer_init(&dpdk.sync_timer);
    // 初始化DPDK-Driver 
    setup(&dpdk);
    // DPDK运行执行数据包转发
    run(&dpdk);

    return 0;

}
```

#### 2. 创建线程通过**enqueue_tx_packet**发送数据包，或通过**enqueue_rx_packet**接收数据包

``` shell
void *test_send(void *arg){
    static uint64_t last_time = 0;
    uint64_t cur_time = rte_get_timer_cycles();
    if ((cur_time - last_time) > rte_get_timer_hz()) {
        last_time = cur_time;

        struct rte_mbuf *mbuf = rte_pktmbuf_alloc(dpdk->mbuf_pool);
        if (mbuf) {
            char *data = rte_pktmbuf_append(mbuf, 60);
            if (data) {
                memset(data, 0xFF, 60);
                if (enqueue_tx_packet(dpdk, mbuf) < 0) {
                    rte_pktmbuf_free(mbuf);
                }
            }
        }
    }
    return NULL;
}

int main()
{
    pthread_t thread;
    int thread_id = 1;

    // 创建线程
    pthread_create(&thread, NULL, test_send, &thread_id)

    // 等待线程结束
    pthread_join(thread, NULL);

    printf("主线程结束\n");
    return 0;
}
```