### DPDK应用
DPDK是一个高效的报文收发的I/O框架，不仅支持众多的网卡类型，也有多种内存和CPU调度的优化方案。

---
### 轮询模式

DPDK轮询网卡是否有网络报文的接受和发送，这样避免了传统网卡驱动的中断上下文的开销，当报文的吞吐量大的时候，性能及延时的改善十分明显。

---
### 用户态驱动

DPDK通过用户态驱动的开发的框架在用户态操作设备及数据包，避免了不必要的用户态和内核态之间的数据拷贝和系统调用。同时，为开发者开拓了更广阔的天地，比如快速迭代及程序优化。

---
### 降低访问存储开销

高性能数据包处理意味着处理器需要频繁访问数据包。显然降低访问存储开销可以有效的提高性能。DPDK使用大页降低TLB未命中率，保持缓存对齐避免处理器之间缓存交叉访问，利用预取等指令提高缓存的访问率。

---
### 亲和性和独占

利用线程的CPU亲和绑定方式，将特定的线程指定在固定的核上工作，可以避免线程在不同核间频繁切换带来的开销，提高可扩展性，更好地达到并行处理提高吞吐量的目的。

---
### 批处理

DPDK使用批处理的概念，一次处理多个包，降低了一个包处理的平均开销。

---
### 利用IA新硬件技术

IA的新指令、新特性都是DPDK挖掘数据包处理性能的源泉。比如利用vector 指令并行处理多个报文，原子指令避免锁开销等。

---
### 软件调优

软件调优散布在 DPDK 代码的各个角落，包括利用threshhold的提高 PCI带宽的使用率，避免Cache Miss（缓存不命中）以及 Branch Mispredicts（分支错误预测）的发生等。

---
### 充分挖掘外部设备潜能

以网卡为例，一些网卡的功能，例如RSS、Flow director、TSO等技术可以被用来加速网络的处理。比如RSS可以将包负载分担到不同的网卡队列上，DPDK多线程可以分别直接处理不同队列上的数据包。除以太网设备网卡以外，DPDK现已支持多种其他设备，例如crypto设备，这些专用硬件可以被DPDK应用程序用来加速其网络处理。