### 概述

虚拟机镜像是一个文件，包含了已经完成安装并且可启动操作系统的虚拟磁盘。虚拟机镜像具有不同格式，常见的有raw格式和qcow2格式。与raw格式镜像相比，qcow2格式镜像占用更小的空间，支持快照、Copy-On-Write、AES加密、zlib压缩等特性，但性能略逊于raw格式镜像。镜像文件的制作借助于qemu-img工具，本节以qcow2格式镜像文件为例，介绍虚拟机镜像制作过程。

#### 制作镜像

制作qcow2格式镜像文件的操作步骤如下：

1. 使用root用户安装qemu-img软件包。

    ```sh
    # apt update && apt install -y qemu-img
    ```

2. 使用qemu-img工具的create命令，创建镜像文件，命令格式为：

    ```sh
    qemu-img create -f <imgFormat> -o <fileOption> <fileName> <diskSize>
    ```

    其中，各参数含义如下：

    - _imgFormat_：镜像格式，取值为raw, qcow2等。
    - _fileOption_：文件选项，用于设置镜像文件的特性，如指定后端镜像文件，压缩，加密等特性。
    - _fileName_：文件名称。
    - _diskSize_：磁盘大小，用于指定块磁盘设备的大小，支持的单位有K、M、G、T，分别代表KiB、MiB、GiB、TiB。

    例如，创建一个磁盘设备大小为4GB、格式为qcow2的镜像文件metaOS-image.qcow2，命令和回显如下：

    ```sh
    $ qemu-img create -f qcow2 metaOS-image.qcow2 4G
    Formatting 'metaOS-image.qcow2', fmt=qcow2 size=4294967296 cluster_size=65536 lazy_refcounts=off refcount_bits=16
    ```

#### 修改镜像磁盘空间大小

当虚拟机需要更大的磁盘空间时，可以使用qemu-img工具，修改虚拟机镜像磁盘空间的大小，修改方法如下。

1. 查询当前虚拟机镜像磁盘空间大小，命令如下：

    ```sh
    qemu-img info <imgFiLeName>
    ```

    例如，查询metaOS-image.qcow2镜像磁盘空间大小的命令和回显如下，说明该镜像磁盘空间大小为4GiB。

    ```sh
    $ qemu-img info metaOS-image.qcow2
    ```

2. 修改镜像磁盘空间大小，命令如下，其中_imgFiLeName_为镜像名称，“+”和“-”分别表示需要增加或减小的镜像磁盘空间大小，单位为K、M、G、T，代表KiB、MiB、GiB、TiB。

    ```sh
    qemu-img resize <imgFiLeName> [+|-]<size>
    ```

    例如，将上述metaOS-image.qcow2镜像磁盘空间大小扩展到24GiB，即在原来4GiB基础上增加20GiB，命令和回显如下：

    ```sh
    $ qemu-img resize metaOS-image.qcow2 +20G
    Image resized.
    ```

3. 查询修改后的镜像磁盘空间大小，确认是否修改成功，命令如下：

    ```sh
    qemu-img info <imgFiLeName>
    ```

    例如，上述metaOS-image.qcow2镜像磁盘空间已扩展到24GiB，命令和回显如下：

    ```sh
    $ qemu-img info metaOS-image.qcow2 
    ```

### 准备虚拟机网络

#### 概述

为了使虚拟机可以与外部进行网络通信，需要为虚拟机配置网络环境。KVM虚拟化支持Linux网桥、Open vSwitch网桥等多种类型的网桥。如图1所示，数据传输路径为“虚拟机 -\> 虚拟网卡设备  -\> Linux网桥或Open vSwitch网桥 -\> 物理网卡”。创建网桥，除了为虚拟机配置虚拟网卡设备外，为主机创建网桥是连接虚拟化网络的关键。

本节给出搭建Linux网桥和Open vSwitch网桥的方法，使虚拟机连接到网络，用户可以根据情况选择搭建网桥的类型。

**图 1**  虚拟网络结构图<a name="fig1785384714917"></a>

![](https://resource.helplook.net/docker_production/3648ne/article/WoYmDMyD/63ac4b0cfcb68b89a1bb7e1a9afb8aa2.png)

#### 搭建Linux网桥

以物理网卡enp0s1绑定到Linux网桥br0的操作为例，使用root用户执行如下命令搭建Linux网桥：

1. 安装bridge-utils软件包。

    Linux网桥通常通过brctl工具管理，其对应的安装包为bridge-utils，安装命令如下：

    ```sh
    # apt install -y bridge-utils
    ```

2. 创建网桥br0。

    ```sh
    # brctl addbr br0
    ```

3. 将物理网卡enp0s1绑定到Linux网桥。

    ```sh
    # brctl addif br0 enp0s1
    ```

4. enp0s1与网桥连接后，不再需要IP地址，将enp0s1的IP设置为0.0.0.0。

    ```sh
    # apt install -y net-tools
    # ifconfig enp0s1 0.0.0.0
    ```

5. 设置br0的IP地址。
    - 如果有DHCP服务器，可以通过dhclient设置动态IP地址。

        ```sh
        # dhclient br0
        ```

    - 如果没有DHCP服务器，给br0配置静态IP，例如设置静态IP为192.168.1.2，子网掩码为255.255.255.0。

        ```sh
        # ifconfig br0 192.168.1.2 netmask 255.255.255.0
        ```

#### 搭建Open vSwitch网桥

Open vSwitch网桥，具有更便捷的自动化编排能力。搭建Open vSwitch网桥需要安装网络虚拟化组件，这里介绍总体操作。

##### 一、安装Open vSwitch组件

使用Open vSwitch提供虚拟网络，需要安装Open vSwitch网络虚拟化组件，使用root用户执行如下命令：

1. 安装Open vSwitch组件。

    ```sh
    # apt install -y openvswitch
    ```

2. 启动Open vSwitch服务。

    ```sh
    # systemctl start openvswitch
    ```

##### 二、确认安装是否成功

确认Open vSwitch组件是否安装成功。

1. 确认openvswitch组件是否安装成功。若安装成功，可以看到软件包相关信息，命令和回显如下：


2. 查看Open vSwitch服务是否启动成功。若服务处于“Active”状态，说明服务启动成功，可以正常使用Open vSwitch提供的命令行工具，命令和回显如下：


##### 三、搭建Open vSwitch网桥

以创建Open vSwitch一层网桥br0为例，介绍搭建方法，使用root用户执行如下命令：

1. 创建Open vSwitch网桥br0。

    ```sh
    # ovs-vsctl add-br br0
    ```

2. 将物理网卡enp0s1添加到br0。

    ```sh
    # ovs-vsctl add-port br0 enp0s1
    ```

3. enp0s1与网桥连接后，不再需要IP地址，将enp0s1的IP设置为0.0.0.0。

    ```sh
    # ifconfig enp0s1 0.0.0.0
    ```

4. 为OVS网桥br0分配IP。
    - 如果有DHCP服务器，可以通过dhclient设置动态IP地址。

        ```sh
        # dhclient br0
        ```

    - 如果没有DHCP服务器，给br0配置静态IP，例如192.168.1.2。

        ```sh
        # ifconfig br0 192.168.1.2
        ```

### 非root用户配置

#### 概述

metaOS虚拟化使用virsh管理虚拟机。如果希望在非root用户使用virsh命令管理虚拟机，在使用之前需要进行相关配置，这里给出配置指导。

#### 操作指导

允许非root用户使用virsh命令管理虚拟机的配置操作如下，以下命令中的userName请改为实际的非root用户名称：

1. 使用root用户登录主机。

2. 将非root用户添加到libvirt用户组。

3. 切换到非root用户。

4. 配置非root用户的环境变量。

5. 在虚拟机XML配置文件中的domain根元素中添加如下内容，使qemu-kvm进程可以访问磁盘镜像文件。