### 最低硬件要求

在metaOS系统中安装虚拟化组件，最低硬件要求：

-   AArch64处理器架构：ARMv8以上并且支持虚拟化扩展
-   x86\_64处理器架构：支持VT-x
-   2核CPU
-   4GB的内存
-   16GB可用磁盘空间

---
### 安装虚拟化核心组件

#### 安装方法

##### 前提条件

-   已经配置apt源。
-   安装操作需要root用户权限。

##### 安装步骤

1.  安装QEMU组件。

    ``` shell
    # apt install -y qemu
    ```

    >![](./public_sys-resources/icon-caution.gif) **注意：**  
    >QEMU组件默认以用户qemu和用户组qemu运行，如果您不了解Linux用户组、用户的权限管理，后续创建和启动虚拟机时可能会遇到权限不足问题，以下有两种解决方法：  
    >修改QEMU配置文件。使用以下命令打开QEMU配置文件，`sudo vim /etc/libvirt/qemu.conf`，找到以下两个字段，`user = "root"`和`group = "root"`，取消注释（即删除前面的`#`号），保存并退出。

2.  安装libvirt组件。

    ``` shell
    # apt install -y libvirt
    ```

3.  启动libvirtd服务。

    ``` shell
    # systemctl start libvirtd
    ```


>**说明：**   
>KVM模块已经集成在metaOS内核中，因此不需要单独安装。

#### 验证安装是否成功

1.  查看内核是否支持KVM虚拟化，即查看/dev/kvm和/sys/module/kvm文件是否存在，命令和回显如下：

    ``` shell
    $ ls /dev/kvm
    ```

    ``` shell
    $ ls /sys/module/kvm
    ```

    若上述文件存在，说明内核支持KVM虚拟化。若上述文件不存在，则说明系统内核编译时未开启KVM虚拟化，需要更换支持KVM虚拟化的Linux内核。

2.  确认QEMU是否安装成功。若安装成功则可以看到QEMU软件包信息，命令和回显如下：

    ``` shell
    $ rpm -qi qemu
    ```

3.  确认libvirt是否安装成功。若安装成功则可以看到libvirt软件包信息，命令和回显如下：

    ``` shell
    $ rpm -qi libvirt
    ```

4.  查看libvirt服务是否启动成功。若服务处于“Active”状态，说明服务启动成功，可以正常使用libvirt提供的virsh命令行工具，命令和回显如下：

    ``` shell
    $ systemctl status libvirtd
    ```