### 简介

在计算机技术中，虚拟化是一种资源管理技术，它将计算机的各种实体资源（处理器、内存、磁盘、网络适配器等）予以抽象、转换后呈现，并可分割、组合为一个或多个计算机配置环境。这种资源管理技术打破了实体结构不可分割的障碍，使这些资源在虚拟化后不受现有资源的架设方式、地域或物理配置限制，从而让用户可以更好地应用计算机硬件资源，提高资源利用率。

虚拟化使得一台物理服务器上可以运行多台虚拟机，虚拟机共享物理机的处理器、内存、I/O设备等资源，但逻辑上虚拟机之间是互相隔离的。在虚拟化技术中，通常将这个物理服务器称为宿主机，宿主机上运行的虚拟机也叫客户机，虚拟机内部运行的操作系统称为客户机操作系统。在宿主机和虚拟机之间存在一层叫虚拟化层的软件，用于实现虚拟硬件的模拟，通常这个虚拟化层被称为虚拟机监视器，如下图所示：

**图 1**  虚拟化架构<a name="fig19543114124914"></a>  ![](https://resource.helplook.net/docker_production/3648ne/article/78jfeXmo/1f5131cdc0b4631b9abb88d2018d5c09.png)


---
### 虚拟化架构

当前的主流虚拟化技术按照VMM（Virtual Machine Monitor）实现结构不同分为两种：

-   Hypervisor模型

    在这种模型中，VMM被看做是一个完备的操作系统，同时还具备虚拟化功能，VMM直接管理所有的物理资源，包括处理器，内存和I/O设备等。

-   宿主模型

    这种模型中，物理资源是由宿主机操作系统管理，宿主机操作系统是传统的操作系统，如Linux，Windows等，宿主机操作系统不提供虚拟化能力，提供虚拟化能力的VMM作为系统的一个驱动或者软件运行在宿主操作系统上，VMM通过调用host OS的服务获得资源，实现处理器，内存和I/O设备的模拟，这种模型的虚拟化实现有KVM、Virtual Box等。


KVM（Kernel-based Virtual Machine）即基于内核的虚拟机，是Linux的一个内核模块，该内核模块使Linux成为一个hypervisor。KVM架构如[图2](#fig310953013541)所示。KVM本身未模拟任何硬件设备，它用于使能硬件提供的虚拟化能力，比如Intel VT-x, AMD-V, ARM virtualization extensions等。主板、内存及I/O等设备的模拟由用户态的QEMU完成。用户态QEMU配合内核KVM模块共同完成虚拟机的硬件模拟，客户机操作系统运行在QEMU和KVM模拟的硬件上。

**图 2**  KVM架构图<a name="fig310953013541"></a>  
![](https://resource.helplook.net/docker_production/3648ne/article/78jfeXmo/45268f987fc8da9adee0671f896e1369.png)


---
### 虚拟化组件

metaOS软件包中提供的虚拟化相关组件：

-   KVM：提供核心的虚拟化基础设施，使Linux系统成为一个hypervisor，支持多个虚拟机同时在该主机上运行。
-   QEMU：模拟处理器并提供一组设备模型，配合KVM实现基于硬件的虚拟化模拟加速。
-   Libvirt：为管理虚拟机提供工具集，主要包含统一、稳定、开放的应用程序接口（API）、守护进程 （Libvirtd）和一个默认命令行管理工具（virsh）。
-   Open vSwitch：为虚拟机提供虚拟网络的工具集，支持编程扩展，以及标准的管理接口和协议（如NetFlow， sFlow，IPFIX， RSPAN， CLI， LACP， 802.1ag）。

---
### 虚拟化特点

业界普遍认可虚拟化有以下特点：

-   分区

    虚拟化可以对一台物理服务器进行软件逻辑分割，实现运行多台不同规格的虚拟机（虚拟服务器）。

-   隔离

    虚拟化能够模拟虚拟硬件，为虚拟机运行完整操作系统提供硬件条件，每个虚拟机内部操作系统都是独立的，互相隔离的。例如一台虚拟机的操作系统由于故障或者受到恶意破坏而崩溃，其他虚拟机内部的操作系统和应用不会受到任何影响。


-   封装性

    以虚拟机为粒度封装，优秀的封装性使得虚拟机比物理机更灵活，可以实现虚拟机的热迁移、快照、克隆等功能，实现数据中心的快速部署和自动化运维。


-   硬件无关

    经过虚拟化层的抽象后，虚拟机与底层的硬件没有直接的绑定关系，可以在其他服务器上不加修改地运行虚拟机。

---
### 虚拟化优势

虚拟化为数据中心的基础设施带来了众多优势：
-   灵活性和可扩展性
-   更高的可用性和更好的运维手段
-   提高安全性
-   更高的资源利用率

---
### MetaOS虚拟化

MetaOS提供了支持Linux Guest和Windows Guest架构的KVM虚拟化组件。