#### 概述

Libvirt工具采用XML格式的文件描述一个虚拟机特征，包括虚拟机名称、CPU、内存、磁盘、网卡、鼠标、键盘等信息。用户可以通过修改配置文件，对虚拟机进行管理。本章介绍XML配置文件各个元素的含义，指导用户完成虚拟机配置。

#### 基本格式

虚拟机XML配置文件以domain为根元素，domain根元素中包含多个其他元素。XML配置文件中的部分元素可以包含对应属性和属性值，用以详细地描述虚拟机信息，同一元素的不同属性使用空格分开。

XML配置文件的基本格式如下，其中label代表具体标签名，attribute代表属性，value代表属性值，需要根据实际情况修改。

```
<domain type='kvm'>
    <name>VMName</name>
    <memory attribute='value'>8</memory>
    <vcpu>4</vcpu>
    <os>
       <label attribute='value' attribute='value'>
         ...
       </label>
    </os>
    <label attribute='value' attribute='value'>
      ...
    </label>  
</domain>
```

#### 配置流程

1.  创建一个根元素为domain的XML配置文件。
2.  使用标签name，根据命名规则指定唯一的虚拟机名称。
3.  配置虚拟CPU和虚拟内存等系统资源。
4.  配置虚拟设备。
    1.  配置存储设备。
    2.  配置网络设备。
    3.  配置外部总线结构。
    4.  配置鼠标等外部设备。

5.  保存XML配置文件。

---
### 虚拟机描述

#### 概述

本节介绍虚拟机domain根元素和虚拟机名称的配置。

#### 元素介绍

-   domain：虚拟机XML配置文件的根元素，用于配置运行此虚拟机的hypervisor的类型。

    属性type：虚拟化中domain的类型。metaOS虚拟化中属性值为kvm。

-   name：虚拟机名称。

    虚拟机名称为一个字符串，同一个主机上的虚拟机名称不能重复，虚拟机名称必须由数字、字母、“\_”、“－”、“:”组成，但不支持全数字的字符串，且虚拟机名称不超过64个字符。


#### 配置示例

例如，虚拟机名称为metaOS的配置如下：

```
<domain type='kvm'>
    <name>metaOS</name>
    ...
</domain>
```

---
### 虚拟CPU和虚拟内存

#### 概述

本节介绍虚拟CPU和虚拟内存的常用配置。

#### 元素介绍

-   vcpu：虚拟处理器的个数。
-   memory：虚拟内存的大小。

    属性unit：指定内存单位，属性值支持KiB（2<sup>10</sup>  字节），MiB（2<sup>20</sup>  字节），GiB（2<sup>30</sup>  字节），TiB（2<sup>40</sup>  字节）等。

-   cpu：虚拟处理器模式。

    属性mode：表示虚拟CPU的模式。

    -   host-passthrough：表示虚拟CPU的架构和特性与主机保持一致。

    -   custom：表示虚拟CPU的架构和特性由此cpu元素控制。

    子元素topology：元素cpu的子元素，用于描述虚拟CPU模式的拓扑结构。

    -   子元素topology的属性socket、cores、threads分别描述了虚拟机具有多少个cpu socket，每个cpu socket中包含多少个处理核心（core），每个处理器核心具有多少个超线程（threads），属性值为正整数且三者的乘积等于虚拟CPU的个数。
    -   ARM架构支持虚拟超线程, 虚拟CPU热插与虚拟超线程功能互斥。

    子元素model：元素cpu的子元素，当mode为custom时用于描述CPU的模型。

    子元素feature：元素cpu的子元素，当mode为custom时用于描述某一特性的使能情况。其中，属性name表示特性的名称，属性policy表示这一特性的使能控制策略：

    -   force：表示强制使能该特性，无论主机CPU是否支持该特性。

    -   require：表示使能该特性，当主机CPU不支持该特性并且hypervisor不支持模拟该特性时，创建虚拟机失败。

    -   optional：表示该特性的使能情况与主机上该特性的使能情况保持一致。

    -   disable：禁用该特性。

    -   forbid：禁用该特性，当主机支持该特性时创建虚拟机失败。

#### 配置示例

例如，虚拟CPU个数为4，处理模式为host-passthrough，虚拟内存为8GiB，4个CPU分布在两个CPU socket中，且不支持超线程的配置如下：

```
<domain type='kvm'>
    ...
    <vcpu>4</vcpu>
    <memory unit='GiB'>8</memory>
    <cpu mode='host-passthrough'>
        <topology sockets='2' cores='2' threads='1'/>
    </cpu>
...
</domain>
```

虚拟内存为8GiB，虚拟CPU个数为4，处理模式为custom，model为Kunpeng-920，且禁用pmull特性的配置如下：

```
<domain type='kvm'>
    ...
    <vcpu>4</vcpu>
    <memory unit='GiB'>8</memory>
    <cpu mode='custom'>
        <model>Kunpeng-920</model>
        <feature policy='disable' name='pmull'/>
    </cpu>
    ...
</domain>
```

---
### 配置虚拟设备

虚拟机XML配置文件使用devices元素配置虚拟设备，包括存储设备、网络设备、总线、鼠标等，本节介绍常用的虚拟设备如何配置。
### 存储设备

#### 概述

XML配置文件可以配置虚拟存储设备信息，包括软盘、磁盘、光盘等存储介质及其存储类型等信息，本节介绍存储设备的配置方法。

#### 元素介绍

XML配置文件使用disk元素配置存储设备，disk常见的属性如[表1](#table14200183410353)所示。
元素disk的常用属性

<a name="table14200183410353"></a>
<table cellpadding="0" border="1" ><thead align="left"><tr id="row720143463519"><th class="cellrowborder" valign="top" width="7.5200000000000005%" id="mcps1.2.5.1.1"><p id="p559231514916"><a name="p559231514916"></a><a name="p559231514916"></a>元素</p>
</th>
<th class="cellrowborder" valign="top" width="11.39%" id="mcps1.2.5.1.2"><p id="p92021634133518"><a name="p92021634133518"></a><a name="p92021634133518"></a>属性</p>
</th>
<th class="cellrowborder" valign="top" width="21.69%" id="mcps1.2.5.1.3"><p id="p42026341354"><a name="p42026341354"></a><a name="p42026341354"></a>含义</p>
</th>
<th class="cellrowborder" valign="top" width="59.4%" id="mcps1.2.5.1.4"><p id="p12202193443516"><a name="p12202193443516"></a><a name="p12202193443516"></a>属性值及其含义</p>
</th>
</tr>
</thead>
<tbody><tr id="row1820215342359"><td class="cellrowborder" rowspan="2" valign="top" width="7.5200000000000005%" headers="mcps1.2.5.1.1 "><p id="p742912318910"><a name="p742912318910"></a><a name="p742912318910"></a>disk</p>
</td>
<td class="cellrowborder" valign="top" width="11.39%" headers="mcps1.2.5.1.2 "><p id="p3202103453512"><a name="p3202103453512"></a><a name="p3202103453512"></a>type</p>
</td>
<td class="cellrowborder" valign="top" width="21.69%" headers="mcps1.2.5.1.3 "><p id="p1920223493510"><a name="p1920223493510"></a><a name="p1920223493510"></a>指定后端存储介质类型。</p>
</td>
<td class="cellrowborder" valign="top" width="59.4%" headers="mcps1.2.5.1.4 "><p id="p1437102115361"><a name="p1437102115361"></a><a name="p1437102115361"></a>block：块设备</p>
<p id="p8202113415351"><a name="p8202113415351"></a><a name="p8202113415351"></a>file：文件设备</p>
<p id="p13953102263316"><a name="p13953102263316"></a><a name="p13953102263316"></a>dir：目录路径</p>
<p id="p1395310263316"><a name="p1395310263316"></a><a name="p1395310263316"></a>network：网络磁盘</p>
</td>
</tr>
<tr id="row142028345356"><td class="cellrowborder" valign="top" headers="mcps1.2.5.1.1 "><p id="p52031734143515"><a name="p52031734143515"></a><a name="p52031734143515"></a>device</p>
</td>
<td class="cellrowborder" valign="top" headers="mcps1.2.5.1.2 "><p id="p120313453518"><a name="p120313453518"></a><a name="p120313453518"></a>指定呈现给虚拟机的存储介质。</p>
</td>
<td class="cellrowborder" valign="top" headers="mcps1.2.5.1.3 "><p id="p18259554183415"><a name="p18259554183415"></a><a name="p18259554183415"></a>disk：磁盘（默认）</p>
<p id="p15491211123817"><a name="p15491211123817"></a><a name="p15491211123817"></a>floppy：软盘</p>
<p id="p720343433510"><a name="p720343433510"></a><a name="p720343433510"></a>cdrom：光盘</p>
</td>
</tr>
</tbody>
</table>

#### 配置示例

按照“准备虚拟机镜像”操作完成虚拟机镜像准备后，可以使用如下XML配置文件示例，为虚拟机配置虚拟磁盘。

例如，该示例为虚拟机配置了两个IO线程，一个块磁盘设备，一个光盘设备和一个rbd磁盘，第一个IO线程分配给块磁盘设备使用。该块磁盘设备的后端介质为qcow2格式，且被作为优先启动盘。
在使用rbd磁盘前请确保已经安装qemu-block-rbd驱动，如未安装，请在root下使用如下命令进行安装：
```
# apt install qemu-block-rbd
```
配置实例：

```
<domain type='kvm'>
    ...
    <iothreads>2</iothreads>
    <devices>
        <disk type='file' device='disk'>
	    <driver name='qemu' type='qcow2' cache='none' io='native' iothread="1"/>
	    <source file='/mnt/metaOS-image.qcow2'/>
	    <target dev='vda' bus='virtio'/>
	    <boot order='1'/>
	</disk>
	<disk type='network' device='disk'>
	    <driver name='qemu' type='raw' cache='none' />
	    <source protocol="rbd" name="rbd/vol2"/>
	    <host name="192.168.1.200" port="6789" />
	    <target dev='sdc' bus='scsi'/>
	    <boot order='3'/>
	</disk>
         ...
    </devices>
</domain>
```
---
### 网络设备

#### 概述

XML配置文件可以配置虚拟网络设备，包括ethernet模式、bridge模式、vhostuser模式等，本节介绍虚拟网卡设备的配置方法。

#### 元素介绍

XML配置文件中使用元素“interface”，其属性“type”表示虚拟网卡的模式，可选的值有“ethernet”、“bridge”、“vhostuser”等，下面以“bridge”模式虚拟网卡为例介绍其子元素以及对应的属性。

#### 配置示例

-   按照“准备虚拟机网络”创建了Linux网桥br0后，配置一个桥接在br0网桥上的virtio类型的虚拟网卡设备，对应的XML配置如下：

    ```
    <domain type='kvm'>
        ...
        <devices>
            <interface type='bridge'>
                <source bridge='br0'/>
                <model type='virtio'/>
            </interface>
            ...
        </devices>
    </domain>
    ```

-   如果按照“准备虚拟机网络”创建了OVS网桥，配置一个后端使用vhost驱动，且具有四个队列的virtio虚拟网卡设备。

    ```
    <domain type='kvm'>
        ...
        <devices>
            <interface type='bridge'>
                <source bridge='br0'/>
                <virtualport type='openvswitch'/> 
                <model type='virtio'/>
                <driver name='vhost' queues='4'/> 
            </interface>
            ...
        </devices>
    </domain>
    ```


---
### 总线配置

#### 概述

总线是计算机各个部件之间进行信息通信的通道。外部设备需要挂载到对应的总线上，每个设备都会被分配一个唯一地址（由子元素address指定），通过总线网络完成与其他设备或中央处理器的信息交换。常见的设备总线有ISA总线、PCI总线、USB总线、SCSI总线、PCIe总线。

PCIe总线是一种典型的树结构，具有比较好的扩展性，总线之间通过控制器关联，这里以PCIe总线为例介绍如何为虚拟机配置总线拓扑。

>![](./public_sys-resources/icon-note.gif) **说明：**   
>总线的配置相对比较繁琐，若不需要精确控制设备拓扑结构，可以使用libvirt自动生成的缺省总线配置。  

#### 元素介绍

在libvirt的XML配置中，每个控制器元素（使用controller元素表示）可以表示一个总线，根据虚拟机架构的不同，一个控制器上通常可以挂载一个或多个控制器或设备。这里介绍常用属性和子元素。

controller：控制器元素，表示一个总线。

-   属性type：控制器必选属性，表示总线类型。常用取值有“pci”、“usb”、“scsi”、“virtio-serial”、“fdc”、“ccid”。
-   属性index：控制器必选属性，表示控制器的总线“bus”编号（编号从0开始），可以在地址元素“address”元素中使用。
-   属性model：控制器必选属性，表示控制器的具体型号，其可选择的值与控制器类型“type”的值相关。
-   子元素address：为设备或控制器指定其在总线网络中的挂载位置。
    -   属性type：设备地址类型。常用取值有“pci”、“usb”、“drive”。

-   子元素model：控制器具体型号的名称。
    -   属性name：指定控制器具体型号的名称，和父元素controller中的属性model对应。

#### 配置示例

该示例给出一个PCIe总线的拓扑结构。PCIe根节点（BUS 0）下挂载了三个PCIe-Root-Port控制器。第一个PCIe-Root-Port控制器（BUS 1）开启了multifunction功能，并在其下挂载一个PCIe-to-PCI-bridge控制器，形成了一个PCI总线（BUS 3），该PCI总线上挂载了一个virtio-serial设备和一个USB 2.0控制器。第二个PCIe-Root-Port控制器（BUS 2）下挂载了一个SCSI控制器。第三个PCIe-Root-Port控制器（BUS 0）下无挂载设备。配置内容如下：

```
<domain type='kvm'>
    ...
    <devices>
        <controller type='pci' index='0' model='pcie-root'/>
	<controller type='pci' index='1' model='pcie-root-port'>
	    <address type='pci' domain='0x0000' bus='0x00' slot='0x01' function='0x0' multifunction='on'/>
	</controller>
	<controller type='pci' index='2' model='pcie-root-port'>
	    <address type='pci' domain='0x0000' bus='0x00' slot='0x01' function='0x1'/>
	</controller>
	<controller type='pci' index='3' model='pcie-to-pci-bridge'>
	    <model name='pcie-pci-bridge'/>
	    <address type='pci' domain='0x0000' bus='0x01' slot='0x00' function='0x0'/>
	</controller>
	<controller type='pci' index='4' model='pcie-root-port'>
	    <address type='pci' domain='0x0000' bus='0x00' slot='0x01' function='0x2'/>
	</controller>
	<controller type='scsi' index='0' model='virtio-scsi'>
	    <address type='pci' domain='0x0000' bus='0x02' slot='0x00' function='0x0'/>
	</controller>
	<controller type='virtio-serial' index='0'>
	    <address type='pci' domain='0x0000' bus='0x03' slot='0x02' function='0x0'/>
	</controller>
	<controller type='usb' index='0' model='ehci'>
	    <address type='pci' domain='0x0000' bus='0x03' slot='0x01' function='0x0'/>
	</controller>
	...
	</devices>
</domain>
```

---
### 其他常用设备

#### 概述

除存储设备、网络设备外，XML配置文件中还需要指定一些其他外部设备，本节介绍这些元素的配置方法。

#### 元素介绍

-   serial：串口设备

    属性type：用于指定串口类型。常用属性值为pty、tcp、pipe、file。


-   video：媒体设备

    属性type：媒体设备类型。AArch64架构常用属性值为virtio，x86\_64架构通常使用属性值为vga或cirrus。

    子元素model：video的子元素，用于指定媒体设备类型。

    在model元素中，type属性为vga表示配置VGA类型显卡，vram属性代表显存大小，单位默认为KB。

    例如：给x86\_64架构虚拟机配置16MB的VGA类型的显卡，XML示例如下，其中vram属性代表显存大小，单位默认为KB：

    ```
    <video>
        <model type='vga' vram='16384' heads='1' primary='yes'/>
    </video>
    ```

-   input：输出设备

    属性type：指定输出设备类型。常用属性值为tabe、keyboard，分别表示输出设备为写字板、键盘。

    属性bus：指定挂载的总线。常用属性值为USB。

-   emulator：模拟器应用路径
-   graphics：图形设备

    属性type：指定图形设备类型。常用属性值为vnc。

    属性listen：指定侦听的IP地址。


#### 配置示例

例如，在下面的示例中，配置了虚拟机的模拟器路径，pty串口、virtio媒体设备、USB写字板、USB键盘以及VNC图形设备。

>![](./public_sys-resources/icon-note.gif) **说明：**   
>graphics的type配置为VNC时，建议配置属性passwd，即使用VNC登录时的密码。  

```
<domain type='kvm'>
    ...
    <devices>
        <emulator>/usr/libexec/qemu-kvm</emulator>
        <console type='pty'/>
        <video>
            <model type='virtio'/>
        </video>
        <input type='tablet' bus='usb'/>
        <input type='keyboard' bus='usb'/>
        <graphics type='vnc' listen='0.0.0.0' passwd='n8VfjbFK'/>
	...
	</devices>
</domain>
```

---
### 体系架构相关配置

#### 概述

XML中还有一部分体系架构相关的配置，这部分配置包括主板，CPU，一些与体系架构相关的feature，本章节主要介绍它们的配置和含义。

#### 元素介绍

-   os：定义虚拟机启动参数。

    子元素type：指定虚拟机类型，属性arch表示架构类型，如aarch64，属性machine表示虚拟机的芯片组类型，虚拟机支持的芯片组可以通过 **qemu-kvm -machine ?** 命令查询，如AArch64结构使用“virt”类型。

    子元素loader：指定加载固件 ，如配置EDK提供的UEFI文件，属性readonly表示是否是只读文件，值为“yes”或“no”，属性type表示loader的类型，常用的值有“rom”、“pflash”。

    子元素nvram：指定nvram文件路径，用于存储UEFI启动配置。


-   features：hypervisor支持控制一些虚拟机CPU/machine的特性，如高级电源管理接口“acpi”，ARM处理器指定GICv3中断控制器等。

#### x86\_64架构配置示例

x86\_64架构支持BIOS和UEFI两种启动方式，如果不配置loader，则使用默认启动方式BIOS。这里给出启动方式为UEFI、芯片组为q35的配置参考。

```
<domain type='kvm'>
    ...
    <os>
        <type arch='x86_64' machine='q35'>hvm</type>
        <loader type='rom'>/usr/share/edk2/ovmf/OVMF.fd</loader>
    </os>
    ...
</domain>
```

---
### 其他常见配置项

#### 概述

除系统资源和虚拟设备外，XML配置文件还需要配置一些其他元素，本节介绍这些元素的配置方法。

#### 元素介绍

-   iothreads：指定iothread数量，可以用于加速存储设备性能。

-   on\_poweroff：虚拟机关闭时采取的动作。
-   on\_reboot：虚拟机重启时采取的动作。
-   on\_crash：虚拟机崩溃时采取的动作。
-   clock：采用的时钟类型。

    属性offset：设置虚拟机时钟的同步类型，可选的值有“localtime”、“utc”、“timezone”、“variable”等。


#### 配置示例

为虚拟机配置两个iothread，用于加速存储设备性能。

```
<iothreads>2</iothreads>
```

虚拟机关闭时，销毁虚拟机。

```
<on_poweroff>destroy</on_poweroff>
```

虚拟机重启时，重新启动虚拟机。

```
<on_reboot>restart</on_reboot>
```

虚拟机崩溃时，重新启动虚拟机。

```
<on_crash>restart</on_crash>
```

时钟采用“utc”的同步方式。

```
<clock offset='utc'/>
```
---
### XML配置文件示例

#### 概述

本节给出一个基本的AArch64虚拟机和一个x86\_64虚拟机的XML配置文件示例，供用户参考。

#### 示例

一个包含基本元素及总线元素x86\_64架构虚拟机的XML配置文件，其配置示例如下：

```
<domain type='kvm'>
  <name>metaOSVM</name>
  <memory unit='KiB'>8388608</memory>
  <currentMemory unit='KiB'>8388608</currentMemory>
  <vcpu placement='static'>4</vcpu>
  <iothreads>1</iothreads>
  <os>
    <type arch='x86_64' machine='pc-i440fx-4.0'>hvm</type>
  </os>
  <features>
    <acpi/>
  </features>
  <cpu mode='host-passthrough' check='none'>
    <topology sockets='2' cores='2' threads='1'/>
  </cpu>
  <clock offset='utc'/>
  <on_poweroff>destroy</on_poweroff>
  <on_reboot>restart</on_reboot>
  <on_crash>restart</on_crash>
  <devices>
    <emulator>/usr/libexec/qemu-kvm</emulator>
    <disk type='file' device='disk'>
      <driver name='qemu' type='qcow2' iothread='1'/>
      <source file='/mnt/metaOS-image.qcow2'/>
      <target dev='vda' bus='virtio'/>
      <boot order='1'/>
      <address type='pci' domain='0x0000' bus='0x00' slot='0x08' function='0x0'/>
    </disk>
    <controller type='scsi' index='0' model='virtio-scsi'>
    </controller>
    <controller type='virtio-serial' index='0'>
    </controller>
    <controller type='usb' index='0' model='ehci'>
    </controller>
    <controller type='sata' index='0'>
    </controller>
    <controller type='pci' index='0' model='pci-root'/>
    <interface type='bridge'>
      <mac address='52:54:00:c1:c4:23'/>
      <source bridge='virbr0'/>
      <model type='virtio'/>
    </interface>
    <serial type='pty'>
      <target type='isa-serial' port='0'>
        <model name='isa-serial'/>
      </target>
    </serial>
    <console type='pty'>
      <target type='serial' port='0'/>
    </console>
    <input type='tablet' bus='usb'>
      <address type='usb' bus='0' port='1'/>
    </input>
    <input type='keyboard' bus='usb'>
      <address type='usb' bus='0' port='2'/>
    </input>
    <input type='mouse' bus='ps2'/>
    <input type='keyboard' bus='ps2'/>
    <graphics type='vnc' port='-1' autoport='yes' listen='0.0.0.0'>
      <listen type='address' address='0.0.0.0'/>
    </graphics>
    <video>
      <model type='vga' vram='16384' heads='1' primary='yes'/>
      <address type='pci' domain='0x0000' bus='0x00' slot='0x02' function='0x0'/>
    </video>
    <memballoon model='virtio'>
    </memballoon>
  </devices>
</domain>
```