### 什么是ADI
MetaOS作为工业实时操作系统，可满足工业领域各类任务对时间的约束，确保任务在既定时间段按时完成，获得任务完成时间的确定性。同时为了便于用户使用底层系统的资源，管理系统资源，需要将MetaOS的硬件相关资源和能力的系统调用进行抽象层封装，向上一层应用提供接口服务。Automation Device Interface (ADI)： 是一个综合性的服务接口，基于MetaOS通过系统调用能力，提供接口完成工智机的硬件整体服务和管理。同时这一接口定义了硬件和 MetaOS的集成功能，实现了高级的设备管理和控制。ADI 服务使用ACP作为通信中间件，使用protobuf定义通信协议，通信机制维持 request/response 模式。

主体大的功能模块有三个，包括
**设备管理**：ADI 提供了一套完整的工具和协议来管理和配置硬件设备，包括但不限于设备初始化、状态监控、故障诊断和固件更新。
**系统集成**：通过将硬件功能与 MetaOS 的高级特性结合，ADI 确保了设备能够无缝集成进更广泛的系统架构中，支持跨平台操作和互操作性。
**系统调用**：工智机对外暴露的所有接口功能均通过 ADI 实现，确保了接口的一致性和标准化，便于开发和维护。

其中系统调用提供了虚拟机管理、日志查询、系统状态查询、网络管理、内存管理、磁盘管理、实时资源管理、诊断等接口，提供给上层应用通过SDK或者ACP接口统一使用。

---
### ADI接口使用指引

ADI Port: 504

**依赖服务：中科时代ACP通讯总线，开发者最终用户通过ACP使用ADI服务功能**

ADI接口内容

特别说明：协议使用Protobuf定义

关于“Protobuf”  https://protobuf.dev/overview/

---
#### 通用内容定义

Action

```java
syntax = "proto3";

package enums.action;

enum ActionType {
    TYPE_UNKNOW = 0;   // 未知操作
    TYPE_QUERY = 1;    // 查询操作
    TYPE_SET = 2;      // 设置操作
    TYPE_UPDATE = 3;   // 更新操作
    TYPE_DELETE = 4;   // 删除操作
}
```

Error

```protobuf
syntax = "proto3";

package enums.errors;

enum Errors {
  option allow_alias = true;
  /* Common error codes
  (range: 0 - 255)
  */
  ERR_OK = 0;
  ERR_FAILED = 1; /* General error - to be used only for internal errors */
  ERR_PARAMETER = 2;
  ERR_NOTINITIALIZED =
      3;            /* Function cannot be executed, since component has not been
                       initialized yet. It may work later, though */
  ERR_VERSION = 4;  /* Version conflict */
  ERR_TIMEOUT = 5;  /* Operation timed out */
  ERR_NOBUFFER = 6; /* Insufficient memory to carry out the request */
  ERR_PENDING = 7;  /* For async-calls: call not complete, yet */
  ERR_NUMPENDING = 8;     /* To many pending calls. Try later */
  ERR_NOTIMPLEMENTED = 9; /* The function is not implemented */
  ERR_INVALIDID = 10;     /* No object with the provided id found */
  ERR_OVERFLOW = 11;      /* Integer overflow */
  ERR_BUFFERSIZE = 12;    /* The size of a buffer is to small or invalid */
  ERR_NO_OBJECT = 13;     /* No object with this specified name available */
  ERR_NOMEMORY = 14;      /* No heap memory available */
  ERR_NO_MEMORY = 15;

  ERR_DUPLICATE = 16; /* An object with the same name is still available */
  ERR_MEMORY_OVERWRITE =
      17; /* Heap memory was written out of bounds! Memory overwrite error */
  ERR_INVALID_HANDLE = 18;    /* Invalid handle to an object */
  ERR_END_OF_OBJECT = 19;     /* End of object reached */
  ERR_NO_CHANGE = 20;         /* No changes done */
  ERR_INVALID_INTERFACE = 21; /* Invalid or unknown interface */
  ERR_NOT_SUPPORTED = 22;     /* Functionality not supported */
  ERR_NO_ACCESS_RIGHTS = 23;  /* No access rights for this operation */
  ERR_OUT_OF_LIMITS = 24;     /* Specified limits of a resource exceeded */
  ERR_ENTRIES_REMAINING = 25; /* Remaining entries that could not be transmitted
                                 because of buffer limitation */
  ERR_INVALID_SESSION_ID = 26; /* Invalid online sessionid */
  ERR_EXCEPTION = 27;          /* Exception occurred */
  ERR_SIGNATURE_MISMATCH = 28; /* Signature mismatch of an api function */
  ERR_VERSION_MISMATCH = 29;   /* Version mismatch */
  ERR_TYPE_MISMATCH = 30;      /* Type mismatch */
  ERR_ID_MISMATCH = 31;        /* ID mismatch */
  ERR_NO_CONSISTENCY = 32;     /* Consistency error */
  ERR_NO_COMM_CYCLE = 33;      /* No COMM_CYCLE needed */
  ERR_DONT_SUSPEND_TASK = 34;  /* Do not suspend task after an exception */
  ERR_MEMORY_LOCK_FAILED = 35; /* Memory cannot be locked in this operation */
  ERR_LICENSE_MISSING = 36;    /* License missing for the runtime */
  ERR_OPERATION_DENIED = 37;   /* Operation denied */
  ERR_DEVICE = 38;             /* Device error */
  ERR_DISK_FULL = 39;          /* Disk full */
  ERR_CRC_FAILED = 40;
  ERR_MEDIA_ERASE = 41;
  ERR_FILE_ERROR = 42;       /* File error. e.g. cannot open a file for writing
                                because it could be write protected */
  ERR_NO_RETAIN_MEMORY = 43; /* No retain memory available */
  ERR_OUT_OF_LIMITS_MIN =
      44; /* Specified minimum-limit of a resource exceeded */
  ERR_OUT_OF_LIMITS_MAX =
      45;                 /* Specified maximum-limit of a resource exceeded */
  ERR_SIZE_MISMATCH = 46; /* Size mismatch */
  ERR_CALL_AGAIN =
      47; /* Operation is not yet finished, call function again to proceed */
  ERR_NOTHING_TO_DO = 48; /* Operation has nothing to do. No execution. */
  ERR_SECURITY_CHECKS_FAILED =
      49; /* Some security checks have failed. This is a generic error code to
             report this error over public channels. In this case the error code
             doesn't provide a detailed cause for the error. */
  ERR_INVALID_SEQUENCE = 50;
  ERR_INVALID_REFERENCE =
      51; /* Dereferencing an IEC reference in IecVarAccess failed due to
             invalid destination address, e. G. NULL. */
  ERR_CONVERSION_INCOMPLETE =
      52; /* Conversion of string encodings was not lossless. */
  ERR_TOO_MANY_RETRIES = 53; /* Too many retries of an action */
  ERR_ALIGNMENT = 54; /* There is an unaligned access on memory detected. */
  ERR_CHANGE_PASSWORD = 55; /* The password has to be changed */
  ERR_REAUTHENTICATE = 56;  /* The user has to reauthenticate oneself */
  ERR_RELOGIN = 57;         /* The user has to relogin */
  ERR_INVALID_URL = 58;     /* An URL was not valid. */
  ERR_INVALID_STATE =
      59; /* The component state does not allow to call this function. */
  ERR_USER_MISMATCH = 60; /* User mismatch */
  ERR_NOT_READY_YET = 61; /* The service is not ready yet. Try again later */
  ERR_ACTIVATE_USERMGMT = 62; /* The user management has to be activated. */
  ERR_NO_USERMGMT = 63;       /* A login was done with a user name, but no user
                                 management is active. */
  ERR_INVALID_ENCODING = 64;  /* A string encoding was not correct. */
  ERR_TARGET_MISMATCH = 65;   /* Target mismatch detected */
  ERR_CLIENT_IN_RO_MODE =
      66; /* Client is in readonly mode and has no rights for this service. */
  ERR_LICENSE_EXCEEDED = 67; /* License is not sufficient */
  ERR_ASYNC_EXCEPTION =
      68; /* Exception occured during execution of async service task */
  ERR_NO_SIGNATURE = 69; /* Object contains no siganture */
  ERR_NO_AUTHENTICATED = 70; /* Device no authenticated */
  ERR_UNISOLATE_BINDED_CPU = 71; /* Unisolated cpu has already binded */
  ERR_REPEATED_ALARM_CFG = 72;

  /* General network errors
    (range: 256 - 271)
  */
  ERR_NET_FAILED = 256;       /* General failure of a network call */
  ERR_NET_NOTCONNECTED = 257; /* Connection not established or closed */
  ERR_NET_MSGSIZE = 258;      /* Message exceeds the maximum message size */
  ERR_NET_NOROUTE = 259;      /* No route found */
  ERR_NET_TIMEOUT = 260;      /* Timeout of the network call */
  ERR_NET_PKGINVALID = 261;   /* A network (Layer 3) package is invalid */
  ERR_NET_INVALIDADDR = 262;  /* Invalid address */

  /* Network service errors (issued by the server of a network service)
     (range: 288 - 303)
  */
  ERR_SVC_PKGINVALID = 288; /* The received package is not compliant with the
                               service specification */
  ERR_SVC_INVALIDSERVICE = 289; /* The requested service does not exist */
  ERR_SVC_VERSION_MISMATCH =
      290; /* The requested service version does not exist */

  /* Network client errors (issued by the client of a network service)
     (range: 320 - 335)
  */
  ERR_CLNT_PKGINVALID = 320; /* The received package is not compliant with the
                                service specification */

  /* Device server errors
    (range: 368 - 383)
  */
  ERR_DEVS_LOGINFAILED = 368;    /* User login failed */
  ERR_DEVS_SESSIONTIMEOUT = 369; /* Inactive session closed due to timeout */
  ERR_DEVS_CHANNELCLOSED = 370;  /* Channel has been closed */

  /* Channel server (PLC) errors
    (range: 384 - 415)
  */
  ERR_CHS_CHINVALID = 384; /* Channel Id invalid */
  ERR_CHS_TIMEOUT = 385;   /* Channel closed due to a timeout */
  ERR_CHS_PROTOCOL = 386;  /* Protocol error */
  ERR_CHS_CHECKSUM = 387; /* Inrecoverable transmission error (checksum) etc. */
  ERR_CHS_MODEHOST = 388; /* The server application tried to send a message
                             although the channel is in receive mode */
  ERR_CHS_MODEPEER =
      389; /* Incoming message although the channel is in send mode. */
  ERR_CHS_NUMCHANNELS = 390;   /* No more channels available. */
  ERR_CHS_CLOSED = 391;        /* Channel closed by peer */
  ERR_CHS_MESSAGESIZE = 392;   /* Message exceeds the commbuffer size */
  ERR_CHS_REQNOTHANDLED = 393; /* The server application didn't properly handle
                                  an incoming request */
  ERR_CHS_SHUTDOWN =
      394; /* The channel is closed due a runtime system shutdown */
  ERR_CHS_ENCRYPTION_NOT_READY_YET =
      395; /* The CmpSecureChannel is not ready for encrypted communication. Try
              again later */

  ERR_CHS_NOTSERVER = 396; /* This node is not a server node */

  /* Channel client (eg. the gateway) errors
    (range: 416 - 447)
  */
  ERR_CHC_CHINVALID = 416; /* Channel Id invalid */
  ERR_CHC_TIMEOUT = 417; /* Channel closed or connect failed due to a timeout */
  ERR_CHC_PROTOCOL = 418; /* Protocol error */
  ERR_CHC_CHECKSUM = 419; /* Inrecoverable transmission error (checksum) etc. */
  ERR_CHC_MODEHOST = 420; /* The client application tried to send a message
                             although the channel is in receive mode */
  ERR_CHC_MODEPEER =
      421; /* Incoming message although the channel is in send mode. */
  ERR_CHC_NUMCHANNELS = 422; /* No more channels available. */
  ERR_CHC_CLOSED = 423;      /* Channel closed by peer */
  ERR_CHC_MESSAGESIZE = 424; /* Message exceeds the commbuffer size */
  ERR_CHC_NOCHBUFFER =
      425; /* Not enough memory to provide the required communication buffer */

  /* Gateway errors (Client-Gateway communication)
     (range: 448 - 464)
  */
  ERR_GW_INVALIDPKG = 448;   /* Invalid pkg */
  ERR_GW_PROTOCOL = 449;     /* Protocol error */
  ERR_GW_VERSION = 450;      /* Clients protocol version cannot be handled */
  ERR_GW_NOAUTHMODULE = 451; /* The authentication modules provided by the
                                client are not available on the gateway */
  ERR_GW_UNKNOWNCMD =
      452; /* Command or command group not known by the gateway */
  ERR_GW_REQCANCELED =
      453; /* The request has been canceled by a cancelrequest message */
  ERR_GW_REQUNKNOWN =
      454; /* A reference to an other request is unknown (eg. a cancelRequest
              refering to a request that has already been answered. */
  ERR_GW_CANCELFAILED =
      455; /* The referenced request cannot be canceled (certain requests may
              not be canceled once they are initiated) */
  ERR_GW_INVALIDCONN = 456; /* The connection handle is invalid. */
  ERR_GW_NUMCONNECTIONS =
      457; /* GWClient/driver can't handle another connection. */
  ERR_GW_PARAMETER_NOT_SUPPORTED =
      458; /* Parameter values are not supported by the negotiated protocol
              version between GwClient and Gateway (old Gateway). */
  ERR_GW_COMMAND_NOT_SUPPORTED =
      459; /* Command is not supported by the negotiated protocol version
              between GwClient and Gateway (old Gateway). */
  ERR_GW_CLIENT_TIMEOUT =
      460; /* GwClient has not received any data within the timeout */
  ERR_GW_TIMEOUT =
      461; /* Gateway has not received any data within the timeout */

  /* Socket errors
    (range: 512 - 767)
  */
  ERR_SOCK_NOTINITIALIZED = 512;
  ERR_SOCK_NOTSOCKET = 513;        /* The provided socket handle is invalid */
  ERR_SOCK_AFUNSUPPORTED = 514;    /* The address family is not supported */
  ERR_SOCK_PROTOUNSUPPORTED = 515; /* Protocol is not supported */
  ERR_SOCK_NOBUFFER = 516;         /* Not enough buffer to handle the request */
  ERR_SOCK_WOULDBLOCK =
      517; /* Socket is in nonblocking mode but this call would block */
  ERR_SOCK_ADDRINUSE = 518; /* The provided address is already in use */
  ERR_SOCK_ADDRNOTAVAILABLE =
      519; /* The provided address is not available on this computer */
  ERR_SOCK_CONNREFUSED =
      520;                 /* Connection has been refused by the remote host */
  ERR_SOCK_TIMEDOUT = 521; /* Operation timed out */
  ERR_SOCK_HOSTNOTFOUND = 522;    /* The host has not been found */
  ERR_SOCK_HOSTUNREACHABLE = 523; /* Host is unreachable */
  ERR_SOCK_ISCONNECTED = 524;     /* Socket is already connected */
  ERR_SOCK_NOTCONNECTED = 525;    /* The socket is not connected */
  ERR_SOCK_SHUTDOWN = 526;        /* Shutdown has been called on the socket */
  ERR_SOCK_MSGSIZE = 527; /* For sockets of type DGRAM. The package to send
                             exceeds the maximum package size */
  ERR_SOCK_CLOSED = 528;  /* Socket has been gracefully closed. No more
                             send/receives allowed */

  /* L7 Protocol errors
    (range: 768 - 1023)
  */
  ERR_L7_TAG_MISSING = 768;     /* Tag missing in online communication buffer */
  ERR_L7_UNKNOWNCMDGROUP = 769; /* Unknown command group */
  ERR_L7_UNKNOWNCMD = 770; /* Unknown command (within a valid command group) */
  ERR_L7_INCOMPLETE = 771; /* Level 7 service incomplete */
  ERR_L7_PROTOCOLMISMATCH = 772; /* Received protocol does not match to the
                                    expected protocol on this channel */

  /* Errors of the BinTagUtils library
     (range: 1024-1039)
  */
  ERR_BTAG_TAGOVERLAP =
      1024; /* A nested tag reaches beyond the end of the surrounding tag */
  ERR_BTAG_BUFFEROVERRUN =
      1025; /* A tag reaches beyond the end of the buffer */
  ERR_BTAG_MAXNESTINGDEPTH =
      1026; /* The number of nested tags exceeds the maximum nesting depth */
  ERR_BTAG_NOTAG =
      1027; /* No current tag - reader/writer is at the toplevel. */
  ERR_BTAG_NODATATAG = 1028;      /* The current tag is not a data tag */
  ERR_BTAG_NOCONTAINERTAG = 1029; /* The operation is allowed only on a
                                     container tag not on a data tag */
  ERR_BTAG_NOTTOPLEVEL =
      1030; /* Operation only allowed on toplevel (not inside a tag) */
  ERR_BTAG_ALIGNMENT = 1031; /* Invalid alignment */

  /* Errors of the Application component
     (range: 1280-1535)
  */
  ERR_APP_EXISTS = 1280;            /* Application with same name exists */
  ERR_APP_NOT_EXIST = 1281;         /* Application not available */
  ERR_APP_INVALID_SESSIONID = 1282; /* Invalid sessionid */
  ERR_APP_INVALID_DATAID =
      1283; /* Invalid dataid of application. Data don't match! */
  ERR_APP_NOT_LOADED = 1284;              /* Application not loaded */
  ERR_APP_NO_SESSIONID = 1285;            /* no sessionid specified */
  ERR_APP_UNRESOLVED_REFERENCE = 1286;    /* unresolved external function */
  ERR_APP_SIGNATURE_MISMATCH = 1287;      /* signature mismatch */
  ERR_APP_LOAD_RETAIN_DATA_FAILED = 1288; /* loading retain data failed */
  ERR_APP_VERSION_MISMATCH =
      1289; /* Version mismatch of an external lib function */
  ERR_APP_RETAIN_MISMATCH = 1290; /* Retain mismatch of the retain area */
  ERR_APP_SINGLECYCLE_ON_BREAKPOINT =
      1291; /* Ask, if single cycle should be done on breakpoint */
  ERR_APP_CREATE_BOOTPROJECT_FAILED =
      1292; /* Bootproject could not be created */
  ERR_APP_BP_CONDITION_TOO_COMPLEX =
      1293;                             /* Breakpoint condition too complex */
  ERR_APP_BP_BREAKPOINT_NOT_SET = 1294; /* Breakpoint could not be set */
  ERR_APP_BP_INTERP_CODE_TOO_COMPLEX =
      1295; /* Interpreter code for Breakpoint is too complex */
  ERR_APP_CREATE_BOOTPROJECT_FAILED_DISK_FULL =
      1296; /* Bootproject could not be created, disk full */
  ERR_APP_LOADING_CINTEGRATION_MODULES =
      1297; /* Loading any of the C-Integration modules failed */
  ERR_APP_DONT_INIT_AREA = 1298;        /* Don't initialize area */
  ERR_APP_MAPPED_AREA_NOT_FOUND = 1299; /* A data segment has been mapped to an
                                           area that could not be found */
  ERR_APP_SIGNATURE_MISSING =
      1300; /* The digital signature of the download is missing. This is
               requried by the runtime configuration */
  ERR_APP_DECRYPTION_FAILED =
      1301; /* The decrytion of the application code failed */
  ERR_APP_ENCRYPTION_MISSING = 1302; /* The application code is not encrypted.
                                        This is required by the runtime */
  ERR_APP_SIGNATURE_AND_ENCRYPTION_MISSING =
      1303; /* The application code is not signed and encrypted */
  ERR_APP_BP_BREAKPOINT_NOT_DELETED =
      1304; /* Breakpoint could not be deleted */

  /* TLS errors
   * (range: 1536 - 1791)
   */

  ERR_TLS_INTERNAL = 1536; /* Internal Error of TLS component */
  ERR_TLS_RAND_NOT_INIT =
      1537; /* Random number generator was not seeded with enough entropy */
  ERR_TLS_INVALID_SOCKETTYPE = 1538; /* The configured type of the socket does
                                        not allow this operation */
  ERR_TLS_ALREADY_STARTED = 1539; /* The TLS handshake has already been done */
  /* IO operations */
  ERR_TLS_CONNECTION_CLOSED = 1540; /* The TLS connection has been closed. */
  ERR_TLS_RETRY_OPERATION =
      1541;                 /* The same TLS operation should be called again */
  ERR_TLS_IO_SYSTEM = 1542; /* The underlaying transport caused a problem */
  ERR_TLS_WANT_READ =
      1543; /* The finish this operation data have to be read. The data was not
               available. Receive TLS protocol data to finish this operation */
  ERR_TLS_WANT_WRITE = 1544; /* To finish this operation data has to be written.
                                The buffer doesn't allow that. Send existing
                                data to allow writing new data */

  /* Certificate errors*/
  ERR_TLS_CERT_INVALID = 1545;
  ERR_TLS_CERT_SELFSIGNED = 1546;
  ERR_TLS_CERT_EXPIRED = 1547;

  /*
   * X509 Cert errors range(1792 - 2047)
   */

  /* Certificate validation error codes */
  ERR_CERT_OK = 0;

  /* illegal error (for uninitialized values, to avoid ERR_CERT_OK) */
  ERR_CERT_UNABLE_TO_GET_ISSUER_CERT = 1792;
  ERR_CERT_UNABLE_TO_GET_CRL = 1793;
  ERR_CERT_UNABLE_TO_DECRYPT_CERT_SIGNATURE = 1794;
  ERR_CERT_UNABLE_TO_DECRYPT_CRL_SIGNATURE = 1795;
  ERR_CERT_UNABLE_TO_DECODE_ISSUER_PUBLIC_KEY = 1796;
  ERR_CERT_SIGNATURE_FAILURE = 1797;
  ERR_CERT_CRL_SIGNATURE_FAILURE = 1798;
  ERR_CERT_NOT_YET_VALID = 1799;
  ERR_CERT_HAS_EXPIRED = 1780;
  ERR_CERT_CRL_NOT_YET_VALID = 1781;
  ERR_CERT_CRL_HAS_EXPIRED = 1782;
  ERR_CERT_ERROR_IN_CERT_NOT_BEFORE_FIELD = 1783;
  ERR_CERT_ERROR_IN_CERT_NOT_AFTER_FIELD = 1784;
  ERR_CERT_ERROR_IN_CRL_LAST_UPDATE_FIELD = 1785;
  ERR_CERT_ERROR_IN_CRL_NEXT_UPDATE_FIELD = 1786;
  ERR_CERT_OUT_OF_MEM = 1787;
  ERR_CERT_DEPTH_ZERO_SELF_SIGNED_CERT = 1788;
  ERR_CERT_SELF_SIGNED_CERT_IN_CHAIN = 1789;
  ERR_CERT_UNABLE_TO_GET_ISSUER_CERT_LOCALLY = 1790;
  ERR_CERT_UNABLE_TO_VERIFY_LEAF_SIGNATURE = 1791;
  ERR_CERT_CHAIN_TOO_LONG = 1792;
  ERR_CERT_REVOKED = 1793;
  ERR_CERT_INVALID_CA = 1794;
  ERR_CERT_PATH_LENGTH_EXCEEDED = 1795;
  ERR_CERT_INVALID_PURPOSE = 1796;
  ERR_CERT_UNTRUSTED = 1797;
  ERR_CERT_REJECTED = 1798;

  /* These are 'informational' when looking for issuer cert */
  ERR_CERT_SUBJECT_ISSUER_MISMATCH = 1799;
  ERR_CERT_AKID_SKID_MISMATCH = 1800;
  ERR_CERT_AKID_ISSUER_SERIAL_MISMATCH = 1801;
  ERR_CERT_KEYUSAGE_NO_CERTSIGN = 1802;
  ERR_CERT_UNABLE_TO_GET_CRL_ISSUER = 1803;
  ERR_CERT_UNHANDLED_CRITICAL_EXTENSION = 1804;
  ERR_CERT_KEYUSAGE_NO_CRL_SIGN = 1805;
  ERR_CERT_UNHANDLED_CRITICAL_CRL_EXTENSION = 1806;
  ERR_CERT_INVALID_NON_CA = 1807;
  ERR_CERT_PROXY_PATH_LENGTH_EXCEEDED = 1808;
  ERR_CERT_KEYUSAGE_NO_DIGITAL_SIGNATURE = 1809;
  ERR_CERT_PROXY_CERTIFICATES_NOT_ALLOWED = 1810;
  ERR_CERT_INVALID_EXTENSION = 1811;
  ERR_CERT_INVALID_POLICY_EXTENSION = 1812;
  ERR_CERT_NO_EXPLICIT_POLICY = 1813;
  ERR_CERT_DIFFERENT_CRL_SCOPE = 1814;
  ERR_CERT_UNSUPPORTED_EXTENSION_FEATURE = 1815;
  ERR_CERT_UNNESTED_RESOURCE = 1816;
  ERR_CERT_PERMITTED_VIOLATION = 1817;
  ERR_CERT_EXCLUDED_VIOLATION = 1818;
  ERR_CERT_SUBTREE_MINMAX = 1819;
  ERR_CERT_UNSUPPORTED_CONSTRAINT_TYPE = 1820;
  ERR_CERT_UNSUPPORTED_CONSTRAINT_SYNTAX = 1821;
  ERR_CERT_UNSUPPORTED_NAME_SYNTAX = 1822;
  ERR_CERT_CRL_PATH_VALIDATION_ERROR = 1823;

  /* The application is not happy */
  ERR_CERT_APPLICATION_VERIFICATION = 1824;

  ERR_CERT_MISSING = 1825;
  ERR_CERT_UNKNOWN_ERROR = 1826;

  ERR_P12_UNKNOWN_ERROR =
      1827; /* The p12 operation failed for an unknown reason */
  ERR_P12_MAC_INVALID =
      1828; /* The MAC of the p12 operation was invalid. Typically this is
               because of a wrong passphrase */
  ERR_P12_UNSUPPORTED_CIPHER = 1829; /* The p12 container was created with an
                                        unsupported encryption algorithm */
  ERR_P12_UNSUPPORTED_DIGEST = 1830; /* The p12 container was created with an
                                        unsupported digest algorithm */
  ERR_P12_UNSUPPORTED_OPTION =
      1831; /* The p12 container was created with an unsupported option. */
  ERR_P12_PARSE_ERROR = 1832; /* The p12 container could not be parsed. */
  ERR_P12_KEY_NOMATCH = 1833; /* The private key of the p12 container does not
                                 match the certifictate within the container. */
  ERR_P12_NO_KEY = 1834; /* The p12 container does not contain a private key. */
  ERR_P12_NO_CERT =
      1835; /* The p12 container does not contain a certificate. */

  /* Device management errors
   * (range: 0x800 - 0x8FF)
   */
  ERR_DMS_SERVICE_NOT_RUNNING =
      1836; /* The corresponding device management service is not running and
               cannot be started! */

  /* Monitoring errors -
      For use in the monitoring reply packages only. Not to be mixed with the
      standard ERR_xxx result values.
      These errors values must not exceed a single byte (ie. <= 255)
  */
  MONITORING_ERR_OK = 0;
  MONITORING_ERR_INVALID_AREA = 1;
  MONITORING_ERR_UNSUPPORTED_DATATYPE = 2;
  MONITORING_ERR_SIZE_0 = 3;
  MONITORING_ERR_NOBP = 4;
  MONITORING_ERR_INVALID_POINTER = 5;
  MONITORING_ERR_NESTING_DEPTH = 6;
  MONITORING_ERR_NO_CONSISTENCY = 7;
  MONITORING_ERR_BUFFERSIZE_EXCEEDED = 8;
  MONITORING_ERR_INVALID_INDEX = 9;
  MONITORING_ERR_UNSUPPORTED_OPERATOR = 10;
  MONITORING_ERR_OPERATION_DENIED = 11;
  MONITORING_ERR_EXCEPTION =
      12; /* An exception occurred while executing the monitoring expression */
  MONITORING_ERR_STACK_OVERFLOW = 13; /* The monitoring stack was not large
                                         enough to evaluate the expression */
  MONITORING_ERR_STACK_UNDERFLOW =
      14; /* The expression caused an underflow of the monitoring stack */
  MONITORING_ERR_IOPARAM = 15;        /* Accessing an I/O parameter failed        */
  MONITORING_ERR_DIVISIONBYZERO = 16; /* A division by zero occured */
  MONITORING_ERR_INVALIDBRANCHOFFSET =
      17;                    /* The branch offset is too large in magnitude                    */
  MONITORING_ERR_NOAPP = 18; /* No application context has been given */
  MONITORING_ERR_WRONGFUNCTION =
      19; /* The break point is not in the current function */
  MONITORING_ERR_FORCE_FAILED = 20; /* Adding a forced valule failed
                                     */
  MONITORING_ERR_FAILED = 21;       /* Generic monitoring error
                                     */
  MONITORING_ERR_UNKNOWN = 22;

  /* FileTransfer errors */
  ERR_FT_FILE_SIZE_MISMATCH = 2048; /* File size don't match */
  ERR_FT_CRC_MISMATCH = 2049;       /* Crc of file don't match */

  /* IecVarAccess errors */
  ERR_IECVARACC_UNKNOWN_NODE_TYPE = 2304; /* Unknown symbolic node type */
  ERR_IECVARACC_NO_CHILD_NODE = 2305;     /* No child not available */
  ERR_IECVARACC_CONFIG_CHANGED = 2306;    /* Symbolconfiguration has changed */
  ERR_IECVARACC_SYNC_CONSISTENCY_DENIED =
      2307; /* AF_ALLOW_SYMBOLIC_VARIABLE_ACCESS_IN_SYNC_WITH_IEC_TASK is not
               set for all applications on the device*/

  ERR_EDGE_INVALID_MESSAGEID = 2560; /* A received message id was invalid. */
  ERR_EDGE_INVALID_STATE = 2561;     /* A session is in an invalid state. */
  ERR_EDGE_SESSIONID_INVALID = 2562; /* Unknown session id requested */
  ERR_EDGE_PKGINVALID = 2563; /* The received package is not compliant with the
                                 service specification */
  ERR_EDGE_NOBUFFER = 2564;   /* Not enough buffer to handle the request */
  ERR_EDGE_TIMEOUT = 2565;    /* Timeout of the request */
  ERR_EDGE_VAR_MISMATCH = 2566; /* The requested variable type or size does not
                                   match, maybe out of date */
  ERR_EDGE_PLC_NOT_CONNECTED =
      2567; /* The PLC state is not in state STATE_RUNNING */
  ERR_EDGE_PLC_NO_CYCLIC_LIST_DEFINED =
      2568; /* Invalid variable list specified */
  ERR_EDGE_COMM_FATAL =
      2569; /* Communication error occurred during symbol load */

  /* Visu redundancy errors */
  ERR_REDU_TOO_TAGS = 2816;            /* Too many tags */
  ERR_REDU_MEMORY = 2817;              /* Memory error during ID creation */
  ERR_REDU_CLIENT_CREATION_ERR = 2818; /* Client creation error */

  /**
   * <category>CFA (CODESYS Firmware Archive) Verifier Issues</category>
   * <description>Errors or warnings encountered while verifying an CFA's
   * signatures.</description>
   */
  ERR_DM_SIG_SIG_MALFORMED_SIGNERS = 2816; /* Malformed list of signers */
  ERR_DM_SIG_SIG_MALFORMED_SIGNER = 2817;  /* Malformed signer block */
  ERR_DM_SIG_SIG_MALFORMED_PUBLIC_KEY =
      2818; /* Public key embedded in the CFA Signature Scheme v1 signature of
               this signer could not be parsed. */
  ERR_DM_SIG_SIG_MALFORMED_CERTIFICATE =
      2819; /* This CFA Signature Scheme v1 signer's certificate could not be
               parsed. */
  ERR_DM_SIG_SIG_MALFORMED_SIGNATURE =
      2820; /* Failed to parse this signer's signature record contained in the
               CFA Signature Scheme v1 signature. */
  ERR_DM_SIG_SIG_MALFORMED_DIGEST =
      2821; /* Failed to parse this signer's digest record contained in the CFA
               Signature Scheme v1 signature. */
  ERR_DM_SIG_SIG_MALFORMED_ADDITIONAL_ATTRIBUTE =
      2822; /* This CFA Signature Scheme v1 signer contains a malformed
               additional attribute. */
  ERR_DM_SIG_SIG_NO_SIGNERS =
      2823; /* No signers in CFA Signature Scheme v1 signature */
  ERR_DM_SIG_SIG_UNKNOWN_SIG_ALGORITHM =
      2824; /* This CFA Signature Scheme v1 signer contains a signature produced
               using an unknown algorithm. */
  ERR_DM_SIG_SIG_UNKNOWN_ADDITIONAL_ATTRIBUTE =
      2825; /* This CFA Signature Scheme v1 signer contains an unknown
               additional attribute. */
  ERR_DM_SIG_SIG_VERIFY_ERROR =
      2826; /* An error was encountered while verifying CFA Signature Scheme v1
               signature of this signer. */
  ERR_DM_SIG_SIG_DID_NOT_VERIFY =
      2827; /* Signature over signed-data did not verify */
  ERR_DM_SIG_SIG_NO_SIGNATURES = 2828;           /* No signatures */
  ERR_DM_SIG_SIG_NO_SUPPORTED_SIGNATURES = 2829; /* No supported signatures */
  ERR_DM_SIG_SIG_NO_CERTIFICATES = 2830;         /* No certificates */
  ERR_DM_SIG_SIG_PUBLIC_KEY_MISMATCH_BETWEEN_CERTIFICATE_AND_SIGNATURES_RECORD =
      2831; /* This CFA Signature Scheme v1 signer's public key listed in the
               signer's certificate does not match the public key listed in the
               signatures record. */
  ERR_DM_SIG_SIG_SIG_ALG_MISMATCH_BETWEEN_SIGNATURES_AND_DIGESTS_RECORDS =
      2832; /* This CFA Signature Scheme v1 signer's signature algorithms listed
               in the signatures record do not match the signature algorithms
               listed in the signatures record. */
  ERR_DM_SIG_SIG_CFA_DIGEST_DID_NOT_VERIFY =
      2833; /* The CFA's digest does not match the digest contained in the CFA
               Signature Scheme v1 signature. */
  ERR_DM_SIG_CFA_SIG_BLOCK_UNKNOWN_ENTRY_ID =
      2834; /* CFA Signing Block contains an unknown entry. */

  /* OEM specific error code range */
  ERR_OEM_START = 32768; /* OEM error range start */
  ERR_OEM_END = 65535;   /* OEM error range end */
}
```

#### CPU

本接口用于查询和管理CPU核心的信息与隔离状态。用户可以先查询和设置系统中CPU核心的隔离配置。根据操作类型，用户端可以请求隔离或取消隔离特定的CPU核心。响应中包括了系统的CPU核心配置情况和当前的隔离状态。

1. 获取cpu信息接口

**GetCpuInfo**

**GroupID**:  0x103

**OffsetID**:  1

```protobuf
// 获取Cpu信息
message GetCpuInfoOutput{
    //核数
    int32 Count = 1;
    //温度
    double Temperature = 2;
    //总占用率
    double Load = 3;
    //CPU厂家型号
    string ModelName = 4;
    //基础频率
    string Frequency = 5;
}
```

* 获取cpu分核列表接口

**GetCpuCoreList**

**GroupID**:  0x103

**OffsetID**:  2

```protobuf
//获取cpu分核列表
message GetCpuCoreListOutput{

    repeated CpuCoreInfo CpuCoreInfo = 1;
}

//cpu分核信息
message CpuCoreInfo{
    // cpu编号
    int32 CpuId = 1;
    //是否实时核
    bool IsRealCore = 2;
    //占用
    double Load = 3;
}
```

* 设置实时核接口

**SetRealCpu**

**GroupID**:  0x103

**OffsetID**:  3

```protobuf
//设置实时核
message SetRealCpuInput{

    repeated int32 CpuId=1;
}
```

* 获取cpu分核接口定义

**CpuIsolation**

**GroupID**:  0x103

**OffsetID**:  4

输入：

```protobuf
// 定义CPU架构类型
enum CpuArch {
  CPU_ARCH_UNSPECIFIED = 0; // 默认值，未指定
  CPU_ARCH_X86_64 = 1;      // 表示 x86-64 架构
  CPU_ARCH_ARM64 = 2;       // 表示 ARM64 架构
}

// 请求消息：指定希望执行的操作和隔离的CPU核心编号
message CpuCoreIsolationRequest {
  enums.action.ActionType action = 1;         // 操作类型，包括隔离和取消隔离, 需要使用 TYPE_SET 类型，非默认值, 查询使用TYPE_QUERY
  repeated int32 isolate_cpus = 2;            // 需要隔离的CPU核心编号列表（实时核列表）
  repeated int32 non_isolate_cpus = 3;        // 不需要隔离的CPU核心编号列表（非实时核列表）
}
```

输出：

```protobuf
// 响应消息：返回执行结果，包括系统的CPU核心配置情况和当前的隔离状态
message CpuCoreIsolationResponse {
  int32 total_cpu = 1;                              // 系统的总CPU核数
  repeated int32 available_cpus = 2;                // 当前支持设置隔离的CPU核心编号列表
  repeated int32 unsupported_cpus = 3;              // 当前不支持隔离的CPU核心编号列表（如操作系统保留核心）
  repeated int32 isolated_cpus = 4;                 // 当前已经隔离的CPU核心编号列表
  int32 max_isolated_cpus = 5;                      // 系统最大支持隔离的CPU核心数量
  CpuArch cpu_architecture = 6;                     // CPU架构类型
  int32 numa_nodes = 7;                             // 系统的NUMA节点数量
  enums.errors.Errors error_code = 8;               // 错误码，正确返回OK
}
```

#### 内存

本接口用于查询和管理内存的信息与状态。用户可以查询和设置总的内存大小、域内存大小。

1. 获取内存信息接口

**GetMemoryInfo**

**GroupID**:  0x102

**OffsetID**:  1

```protobuf
//获取内存信息
message GetMemoryInfoOutput {
     //总大小 
     double TotalSize = 1; 
     //使用大小
     double UsedSize=2;
     //类型：DDR4
     string Type = 3;
}
```

* 获取域内存默认值接口

**GetMemoryInfo**

**GroupID**:  0x102

**OffsetID**:  2

```protobuf
//获取域内存默认值
message GetDomainMemoryDefaultValueOutput{    
     //实时域最小
     int32 RelaMemoryMin = 1;
     //实时域默认大小
     int32 RelaMemoryDefault = 2;
     //非实时域最小
     int32 NotRelaMemoryMin = 3;
}
```

* 设置实时域内存接口

**GetMemoryInfo**

**GroupID**:  0x102

**OffsetID**:  3

```protobuf
//设置实时域内存
message SetRealMemoryInput{    

     int32 Size = 1;
}
```

* 获取域内存分配接口定义

**GetMemoryInfo**

**GroupID**:  0x102

**OffsetID**:  4

```protobuf
//获取域内存分配
message GetDomainMenoryOutput{    
     //实时域内存    
int32 RelaMemory = 1;    
     //非实时域内存    
int32 NotRelaMemory = 2;    
     //实时域最小    
int32 RelaMemoryMin = 3;    
     //非实时域最小    
int32 NotRelaMemoryMin = 4;    
MemoryConfigType MemoryConfigType = 5;
}
```

内存配置类型接口

**SetInitConfig**

**GroupID**:  0x102

**OffsetID**:  5

```protobuf
//内存配置类型
enum MemoryConfigType
{
    InitConfig=0;//初始配置
    CustomConfig=1;//自定义配置
}
```

#### 磁盘

本接口用于查询磁盘的信息，包括磁盘的总大小，以及使用的大小。

1. 获取磁盘信息接口定义

**GetMemoryInfo**

**GroupID**:  0x101

**OffsetID**:  1

```protobuf
//获取磁盘信息
message GetDiskInfoOutput {
    // 总大小
    int64 TotalSize = 1;
    // 使用大小
    int64 UsageSize = 2;
}
```



#### 网卡

本接口用于网卡的信息查询和管理，包括网卡配置列表，对网卡配置，获取网卡状态，IP\DNS\网关等信息，可以设置网卡DHCP，监听网卡等功能，可以进行状态切换，包括激活等。

使用隐藏网卡接口时，客户端需要指定希望对隐藏网卡进行的操作类型（如启用或禁用）和目标状态，服务端将返回当前网卡状态及对应的错误码。服务端应保证状态变更的原子性和有效性，使调用方能够可靠地对隐藏网卡状态进行管理。

1. 获取网卡信息接口定义

**GetNetworkCardList**

**GroupID**:  0x203

**OffsetID**:  1

```java
// 网卡列表
message GetNetworkCardListOutput {
  repeated NetworkCardOutput NetworkCardList = 1;
}

// 网卡信息
message NetworkCardOutput {
  // 设备唯一标识=Mac
  string Key = 1;
  // 网卡昵称(LAN1/LAN2)
  string NickName = 2;
  // 网卡名称
  string InterfaceName = 3;
  // mac地址
  string MacAddress = 4;
  // 网卡状态
  NetworkCardDeviceState NetworkCardDeviceState = 5;
  // 设备类型
  common.DeviceType DeviceType = 6;
  // 设备路径
  string DevicePath = 7;
  // 网卡ip设置模式
  NetworkCardMode NetworkCardMode = 8;
  // 网卡配置类型
  NetworkCardCongigType NetworkCardCongigType = 9;
}
```

* 获取IP地址信息接口

**GetIPV4Address**

**GroupID**:  0x203

**OffsetID**:  2

```java
// 获取ip地址输入
message GetIPV4AddressListInput {
  // 设备唯一标识=Mac
  string Key = 1;
}

// 获取ip地址输出
message GetIPV4AddressListOutput {
  // 设备唯一标识=Mac
  string Key = 1;
  // ip 地址信息
  repeated IPV4AddressInfo AddressList = 2;
}

// ip地址信息
message IPV4AddressInfo {
  // 地址
  string Address = 1;
  // 掩码
  string Netmask = 2;
}
```



* 获取网关信息接口

**GetGateway**

**GroupID**:  0x203

**OffsetID**:  3

```protobuf
// 获取网关输入
message GetGatewayInput {
  // 设备唯一标识=Mac
  string Key = 1;
}

// 获取网关输出
message GetGatewayOutput {
  // 网关
  string GatewayAddress = 1;
}
```



* 获取DNS信息接口

**GetDNSList**

**GroupID**:  0x203

**OffsetID**:  4

```protobuf
// 获取DNS输入
message GetDNSInput {
  // 设备唯一标识=Mac
  string Key = 1;
}

// 获取DNS输出
message GetDNSOutput { repeated string DNSAddressList = 1; }
```





* 获取路由信息接口

**GetRoute**

**GroupID**:  0x203

**OffsetID**:  5

```protobuf
// 获取路由输入
message GetRouteInput {
  // 设备唯一标识=Mac
  string Key = 1;
}

// 获取路由输出
message GetRouteOutput {
  // 路由列表
  repeated RouteInfo RouteInfoList = 1;
}

// 路由信息
message RouteInfo {
  // 地址
  string Address = 1;
  // 掩码
  string Netmask = 2;
  // 网关
  string Gateway = 3;
  // 跃点Metric
  int64 Point = 4;
```



* 设置网络配置

**SetNetworkConfig**

**GroupID**:  0x203

**OffsetID**:  6

输入：

```protobuf
// 设置网卡配置
message SetNetworkCardConfig {
  // 设备唯一标识=Mac
  string Key = 1;
  // 网关地址
  string GatewayAddress = 2;
  // ip地址信息
  repeated IPV4AddressInfo IPV4AddressInfoList = 3;
  // Dns地址列表
  repeated string DNSAddressList = 4;
  // 路由信息列表
  repeated RouteInfo RouteInfoList = 5;
  // 网卡模式
  NetworkCardMode NetworkCardMode = 6;
}
```



* 禁用网卡

**DisableNetworkCard**

**GroupID**:  0x203

**OffsetID**:  7

```protobuf
// 禁用网卡
message DisableNetworkCardInput {
  // 设备唯一标识=Mac
  string Key = 1;
}
```



* 设置DHCP

**SetDHCP**

**GroupID**:  0x203

**OffsetID**:  8

```protobuf
// 设置网卡DHCP
message SetNetworkCardDHCPInput {
  // 设备唯一标识=Mac
  string Key = 1;
}
```



* 启用EtherCAT输入

**EnableEtherCAT**

**GroupID**:  0x203

**OffsetID**:  9

```protobuf
// 启用EtherCAT输入
message EnableEtherCATInput {
  // 设备唯一标识=Mac
  string Key = 1;
  // 绑定的cpu
  int32 BindCpu = 2;
}
```



* 禁用EtherCAT

**DisableEtherCAT**

**GroupID**:  0x203

**OffsetID**:  10

```protobuf
// 禁用EtherCAT
message DisableEtherCATInput { string Key = 1; }
```



* 获取初始网络配置

**GetDefaultNetworkCardConfigList**

**GroupID**:  0x203

**OffsetID**:  11

```protobuf
// 默认网卡配置列表
message DefaultNetwrokConfigListOutput {
  // 网卡默认配置列表
  repeated DefaultNetworkCardConfig DefaultNetworkCardConfigList = 1;
}

// 默认网卡配置
message DefaultNetworkCardConfig {
  // 设备唯一标识=Mac
  string Key = 1;
  // 网卡昵称
  string NickName = 2;
  // 网卡名称
  string InterfaceName = 3;
  // 是否透传
  bool Passthrought = 4;
  // 是否是不能透传的网卡
  bool Fixed = 5;
  // 网关
  string Gateway = 6;
  // 是否DHCP
  bool DHCP = 7;
  // IP 配置
  repeated IPV4AddressInfo IPV4AddressInfoList = 8;
  // EtherCAT 配置
  EtherCAT EtherCAT = 9;
  // 设备路径
  string DevicePath = 10;
}
```



* 检查IP存在

**CheckIpExists**

**GroupID**:  0x203

**OffsetID**:  12

```protobuf
// 检测IP是否存在输入
message CheckIpExistsInput { string ipAddress = 1; }

// 检测ip是否存在输出
message CheckIpExistsOutput {

  // 是否存在
  bool IsExits = 1;
  // 设备唯一标识
  string Key = 2;
  // 网卡昵称
  string NickName = 3;
  // 网卡名称
  string InterfaceName = 4;
}
```



* 获取网卡状态

**GetNetworkCardState**

**GroupID**:  0x203

**OffsetID**:  13

```protobuf
// 获取网卡状态输入
message GetNetworkCardStateInput {
  // 设备唯一标识=Mac
  string Key = 1;
}

// 获取网卡状态输出
message GetNetworkCardStateOutput {
  // 网卡状态
  NetworkCardDeviceState NetworkCardDeviceState = 1;
}

// 网卡状态
enum NetworkCardDeviceState {
  // 设备没有负载，指没有插入网线，对应Dbus状态码20
  NoCarrier = 0;
  // 设备正常，状态码100
  Normal = 1;
  // 设备寻址，大于20，小100
  Looking = 2;
  // 设备异常，指大于100
  Abnormal = 3;
  // 网卡透传
  PassthroughState = 4;
  // EtherCAT
  EtherCATState = 5;
}
```



* 网卡监听

**NetworkMonitor**

**GroupID**:  0x203

**OffsetID**:  14

```protobuf
// 网卡监听
message NetworkMonitorOutput {
  // 设备唯一标识
  string key = 1;
  // 新状态
  NetworkCardChangeState NetworkCardChangeState = 2;
}
```



* 获取EtherCAT信息

**GetEtherCATInfoList**

**GroupID**:  0x203

**OffsetID**:  15

```protobuf
// EtherCAT信息
message EtherCAT {
  // 是否启用
  bool Status = 1;
  // 网卡中断绑定Cpu
  string Bind = 2;
}
```



* 隐藏网卡控制

**HiddenCardOperation**

**GroupID**:  0x203

**OffsetID**:  16

输入：

```protobuf
// 定义隐藏网卡状态
enum NetworkInterfaceState {
  INTERFACE_INACTIVE = 0;
  INTERFACE_ACTIVE   = 1;
  INTERFACE_DISABLED = 2;
}

// 请求消息：指定希望执行的操作和目标状态
message ToggleHiddenNetworkInterfaceRequest {
  enums.action.ActionType action = 1;
  NetworkInterfaceState desired_state = 2;
}
```

输出：

```protobuf
// 响应消息：返回执行结果，包括错误码和当前网卡状态
message ToggleHiddenNetworkInterfaceResponse {
  enums.errors.Errors error_code = 1;
  NetworkInterfaceState current_state = 2;
}
```



#### PCIe设备

本接口用于工智机中PCIe设备的信息查询和管理，包括设备的唯一标识、设备类型、透传管理（是否给非实时域使用）等功能。

1. 获取PCIe设备接口

**GetPciDevice**

**GroupID**:  0x204

**OffsetID**:  3

```protobuf
// 设备类型
enum PciDeviceType {

  // 未知
  Unknown = 0;

  // 网卡
  NetworkCard = 1;

  // 显卡
  DisplayCard = 2;
}

// Pcie设备获取
message PciDevice {
  // 设别唯一标识 不变
  string Key = 1;
  // 设备名称
  string Name = 2;
  // 设备路径
  string Path = 3;
  // 设备的父节点
  string Parent = 4;
  // 设备描述
  string Description = 5;

  // pci设备类型
  PciDeviceType PciDeviceType = 7;
  // 设备类型（内置还是拓展）
  common.DeviceType DeviceType = 8;

  // 是否允许用户选择透传
  bool CanPassthrough = 9;

  // 设备是否被透传
  bool IsPassthrough = 10;

  // IOMMU编号
  int32 IommuGroupNum = 11;

  // 是否丢失
  bool IsLost = 12;
}



// pci设备设置透传返回结果
message SetPassthroughResult {
  // 是否成功
  bool isSuccess = 1;
  // 错误消息
  string errorMessage = 2;
}

// 设置pci设备透传参数
message SetPassthroughParams {
  string Key = 1;
  bool IsPassthrough = 2;
}

// pci设备地址
message PciDeviceKey { string Key = 1; }

// pci设备地址
message PciDeviceKeys { repeated string Keys = 1; }

// pci设备透传; 透传警告检测输入
message PciDeviceKeyListInput {
  repeated SetPassthroughParams PciDeviceKeyList = 1;
}

// 透传警告检测输出
message PassthroughWarningCheckOutput {
  bool isWarning = 1;

  repeated PassthroughWarningType TypeList = 2;
}

// 透传警告类型
enum PassthroughWarningType {
  EtherCatPassthrough = 0;
}
```



* 获取PCIe设备接口

**IsMachinePcieDevicePassthrough**

**GroupID**:  0x204

**OffsetID**:  2

```protobuf
// pci设备设置透传返回结果
message SetPassthroughResult {
  // 是否成功
  bool isSuccess = 1;
  // 错误消息
  string errorMessage = 2;
}

// 设置pci设备透传参数
message SetPassthroughParams {
  string Key = 1;
  bool IsPassthrough = 2;
}

```

获取PCIe设备透传警告接口

**PassthroughWarningCheck**

**GroupID**:  0x204

**OffsetID**:  6

```protobuf
// 透传警告检测输出
message PassthroughWarningCheckOutput {
  bool isWarning = 1;

  repeated PassthroughWarningType TypeList = 2;
}

// 透传警告类型
enum PassthroughWarningType {
  EtherCatPassthrough = 0;
}
```



#### 串口设备

本接口用于工智机中串口设备的信息查询和管理，包括设备串口清单、初始化、端口信息等功能。

1. 获取当前串口信息接口

**GetSerialPortInfo**

**GroupID**:  0x201

**OffsetID**:  3

```protobuf
enum SerialPortType {
  RS232 = 0;
  RS422 = 1;
  RS485 = 2;
  Unknown = 3;
}

message SerialPortInfo {
  // 串口名称
  string Key = 1;
  // 设备类型
  common.DeviceType DeviceType = 2;
  // 串口类型
  SerialPortType SerialPortType = 3;
}

message SerialPortInfos { repeated SerialPortInfo SerialPorts = 1; }
```



* 设置串口显示接口

**SetSerialPortDisplayScreen**

**GroupID**:  0x201

**OffsetID**:  1

```protobuf
message SerialPortDisplayScreen { repeated string messages = 1; }
```

```protobuf
message SerialPortDisplayScreen { repeated string messages = 1; }
```



* 初始化串口类型接口

**GetSerialPortInfo**

**GroupID**:  0x201

**OffsetID**:  2

```protobuf
rpc InitSerialPort (SerialPortInfos) returns (google.protobuf.BoolValue);
```



* 设置串口类型接口

**SetSerialPortInfo**

**GroupID**:  0x201

**OffsetID**:  4

```protobuf
设置串口类型
// rpc SetSerialPort(SerialPortInfo) returns (google.protobuf.BoolValue);
//}
```



#### 电池设备

本接口用于获取电池的当前电压值，可以判断BIOS所用电池是否需要更换。

1. 获取电池信息接口定义

**GetBatteryInfo**

**GroupID**:  0x105

**OffsetID**:  1

输入：

```protobuf
//获取电池信息
message GetBatteryInfoOutput {
    double Voltage = 1; // 电压值
    enums.errors.Errors error_code = 2; // 错误码, 正确返回OK, 设备不支持返回 MONITORING_ERR_UNSUPPORTED_OPERATOR
}
```

#### 虚拟机

本接口用于监控虚拟机的资源和运行情况，对虚拟机进行启动、状态获取、暂停等操作。

1. 启动虚拟机接口

**StartVirtualMachine**

**GroupID**:  0x301

**OffsetID**:  1

```protobuf
//启动虚拟机输入
message StartVirtualMachineInput{
    //内存
    int64  MemorySize=1;
    //pcie
    repeated string PCIEDevices=2;
 }

 //启动虚拟机输出
message StartVirtualMachineOutput{
    //状态码(0代表成功，其他为具体的错误码)
    int32 Code=1;
    //内容
    string Message=2;
 }
```

* 获取虚拟机状态接口

**GetVirtualMachineState**

**GroupID**:  0x301

**OffsetID**:  2

```protobuf
 //获取虚拟机状态
 message VirtualMachineStatusOutput{
     VirtualMachineStatus VirtualMachineStatus  = 1;
 }

 //虚拟机运行状态
 enum VirtualMachineStatus{
    NONE = 0;
    //运行
    Running = 1;
    //暂停
    Paused = 2;
    //停止
    ShutOff = 3;
 }
```

* 根据状态启动虚拟机接口

**StartVirtualMachineByStatus**

**GroupID**:  0x301

**OffsetID**:  3

```protobuf
//启动虚拟机输入
message StartVirtualMachineWithState{
    //根据状态启动虚拟机
    VirtualMachineState  VirtualMachineState = 1;
 }

//根据状态启动虚拟机
enum VirtualMachineState{
    None = 0;
    //运行
    Start = 1;
    //暂停
    Stop = 2;
    //重启
    Restart = 3;
 }
```

* 监控虚拟机接口

**MonitorMachine**

**GroupID**:  0x301

**OffsetID**:  5

输入：

```protobuf
// 定义总CPU使用情况的消息结构
message TotalCpuUsage {
  double cpu_used = 1;  // 总CPU使用时间，单位为纳秒
  uint64 timestamp = 2; // 时间戳
  int32 cpu_count = 3; // 虚拟机cpu数量
}

// 定义单个磁盘使用情况的消息结构
message DiskUsage {
  double allocation = 1; // 磁盘使用
  double capacity = 2;   // 磁盘容量
  uint64 timestamp = 3;  // 时间戳
}

// 定义内存使用情况的消息结构
message MemoryUsage {
  double used = 1;      // 已使用内存，单位为字节
  double total = 2;     // 总内存，单位为字节
  uint64 timestamp = 3; // 时间戳
}

// 定义虚拟机状态的枚举类型
enum DomainState {
  DOMAIN_NOSTATE = 0;     // 无状态
  DOMAIN_RUNNING = 1;     // 运行中
  DOMAIN_BLOCKED = 2;     // 阻塞
  DOMAIN_PAUSED = 3;      // 暂停
  DOMAIN_SHUTDOWN = 4;    // 关闭
  DOMAIN_SHUTOFF = 5;     // 已关闭
  DOMAIN_CRASHED = 6;     // 崩溃
  DOMAIN_PMSUSPENDED = 7; // 挂起
}

// 定义单个网卡使用情况的消息结构
message NetworkUsage {
  string interface_name = 1; // 网卡名称
  uint64 rx_bytes = 2;       // 接收的字节数
  uint64 tx_bytes = 3;       // 发送的字节数
  uint64 rx_packets = 4;     // 接收的包数
  uint64 tx_packets = 5;     // 发送的包数
  uint64 rx_errors = 6;      // 接收错误次数
  uint64 tx_errors = 7;      // 发送错误次数
  uint64 rx_dropped = 8;     // 接收丢包数
  uint64 tx_dropped = 9;     // 发送丢包数
}

message MonitorRequest {
  enums.action.ActionType action =
      1; // 操作类型，包括隔离和取消隔离, 需要使用 TYPE_SET 类型，非默认值,
         // 查询使用TYPE_QUERY
  uint64 startTimestamp = 2; // 单位 seconds
  uint64 endTimestamp = 3;
}
```

输出：

```protobuf
message MonitorResponse {
  repeated TotalCpuUsage cpuUsage = 1;
  repeated MemoryUsage memoryUsage = 2;
  repeated DiskUsage diskUsage = 3;
  enums.errors.Errors error_code = 4; // 错误码，正确返回OK
}
```



#### 工智机设备信息

1. 获取工智机设备序列号信息接口定义

**GetSerialNumberInfo**

**GroupID**:  0x104

**OffsetID**:  9

输入：

```java
// 请求机器序列号信息
message SerialNumberRequest {
  enums.action.ActionType action = 1;  // 请求操作类型
}
```

输出：

```java
// 响应机器序列号信息
message SerialNumberResponse {
  enums.errors.Errors error_code = 1;  // 操作结果状态码
  string serial_number = 2;            // 机器的唯一序列号
  string model = 3;                    // 机器型号
  string vendor = 4;                   // 机器制造商名称
}
```



* 获取工智机设备日志报告接口

**GetSerialNumberInfo**

**GroupID**:  0x104

**OffsetID**:  10

输入：

```protobuf
message SosreportRequest {
    enums.action.ActionType action =
        1; // 操作类型，包括隔离和取消隔离, 需要使用 TYPE_SET 类型，非默认值,
           // 查询使用TYPE_QUERY
  }
```

输出：

```protobuf
  message SosreportResponse {
    string report_zip_path = 1;
    enums.errors.Errors error_code = 2; // 错误码，正确返回OK
  }
```



#### 工智机诊断接口

1. 获取工智机诊断信息接口定义

**GetAlarmInfo**

**GroupID**:  0x401

**OffsetID**:  1

输入：

```java
enum AlarmType{
  AlarmTypeTypeUnspecified = 0;
  System = 1;
  Process = 2;
}

enum AlarmCode{
  AlarmCodeUnspecified = 0;
  CpuUsageExceed = 10001;
  MemoryUsageExceed = 10002;
  DiskUsageExceed = 10003;
  BatteryVoltageExceed = 10004;
  CpuTempExceed = 10005;
}

message AlarmConfig{
  AlarmCode alarm_code = 1;
  double alarm_threshold = 2;
  uint32 detect_cycle = 3;
  uint32 continuous_times = 4;
  google.protobuf.Timestamp updated_time = 5;
  bool enable_state = 6;
}

// 请求消息：指定希望执行的操作和更改的告警配置
message AlarmConfigRequest {
  enums.action.ActionType action = 1;     // 操作类型，包括查询和设置阈值, 需要使用 TYPE_SET 类型，非默认值, 查询使用TYPE_QUERY
  repeated AlarmConfig config = 2;        // 告警配置项
}


```

输出：

```java
// 响应消息：返回执行结果，包括当前在检告警的配置
message AlarmConfigResponse {
  repeated AlarmConfig alarm_config = 1;
  enums.errors.Errors error_code = 2;               // 错误码，正确返回OK
}

enum AlarmStatus {
  AlarmStatusUnspecified = 0;
  AlarmStatusAlarm = 1;                                                                                                                                                     
  AlarmStatusClear = 2;
}

message AlarmInfo{
  AlarmCode alarm_code = 1;
  string alarm_position = 2;
  AlarmStatus status = 3;
  AlarmType type = 4;
  google.protobuf.Timestamp alarm_time = 5;
  double alarm_data = 6; // 告警上报时刻的检测值
  uint32 detect_cycle = 7; // 告警检测周期
  uint32 continuous_times = 8; // 连续超过门限次数
  double alarm_threshold = 9;  // 告警门限值
}

message AlarmInfoReported {
  repeated AlarmInfo alarm_info = 1;
}
```

---
### 使用示例

**如何使用ACP标准接口调用的示例**
```C++
#include <string.h>
#include <string.h>
#include <sstream>
#include <ostream>
#include <iostream>
#include <chrono>
#include <thread>
#include "libacp/libacp.h"
#include "libacp/libacpErr.h"

// 订阅topic的回调函数
void SubscribeCallback(const char* szTopic, const char* data, uint32_t dataLen, void* lpContext) {
  printf("recv sub topic:%s,size:%d,data:%s\n", szTopic, dataLen, data);
}

// 客户端连接状态的回调函数
void AcpConnCallback(AcpDeviceId* acpDeviceId, void* lpContext, int rc) { printf("rc:%d\n", rc); }

int main(int argc, char** argv) {
  // 1:第一步初始化客户端
  libacp_init();

  // 2:第二步获取指定服务端的deviceId
  AcpDeviceId devId;
  int result = libacp_getRemoteAcpDeviceId("127.0.0.1", 1000, &devId);

  //  2:或者指定一个deviceId,
  //  libacp_makeAcpDeviceId("192.168.110.180.1.1", &devId);

  //  3:创建一个通讯实例句柄 指定使用TCP进行连接
  ACP_HANDER handler = libacp_createInstanceEx(&devId, CONN_TYPE_TCP, 1000, AcpConnCallback, nullptr);

  // 4: 客户端进行同步收发 并向700的port进行数据发送
  uint16_t port = 504;
  CpuCoreIsolationRequest req;
  req.set_action(::enums::action::ActionType::TYPE_QUERY);
  std::string data = input.SerializeAsString();
    // 同步发送
    uint32_t nIdGroup=0x103;
    uint32_t nIdOffset=1;
    result = libacp_sync_send(handler, port, nIdGroup,nIdOffset, data.c_str(), data.length(), 1000);
    if (result <= 0) {
      int err = libacp_get_errno();
      printf("libacp_sync_send:%d,%s\n", err, libacp_strerror(err));
      return -1;
    }
    // 同步请求
    uint16_t nRecvPort = 504;
    char szRecvBuff[4096] = {0};
    auto size = libacp_sync_recv(handler, &nRecvPort, szRecvBuff, sizeof(szRecvBuff), 5000);
    if (size <= 0) {
      int err = libacp_get_errno();
      printf("libacp_sync_recv:%d,%s\n", err, libacp_strerror(err));
      return -1;
    }
  CpuCoreIsolationResponse response;  
  response.ParseFromString(std::string(szRecvBuff, size)); 
  libacp_releaseInstance(handler);
  libacp_destory();
  return 0;
}
```