### rtnet 驱动配置示例

#### SX21 机器

```shell
lspci -knn
# 00:00.0 Host bridge [0600]: Chengdu Haiguang IC Design Co., Ltd. # Root Complex [1d94:1450]
#         Subsystem: Chengdu Haiguang IC Design Co., Ltd. Root Complex # [1d94:1450]
# 00:00.2 IOMMU [0806]: Chengdu Haiguang IC Design Co., Ltd. I/O # Memory Management Unit [1d94:1451]
#         Subsystem: Chengdu Haiguang IC Design Co., Ltd. I/O Memory # Management Unit [1d94:1451]
# 00:01.0 Host bridge [0600]: Chengdu Haiguang IC Design Co., Ltd. # PCIe Dummy Host Bridge [1d94:1452]
# 00:01.3 PCI bridge [0604]: Chengdu Haiguang IC Design Co., Ltd. PCIE # GPP Bridge [1d94:1453]
#         Kernel driver in µse: pcieport
# 00:01.4 PCI bridge [0604]: Chengdu Haiguang IC Design Co., Ltd. PCIE # GPP Bridge [1d94:1453]
#         Kernel driver in µse: pcieport
# 00:01.5 PCI bridge [0604]: Chengdu Haiguang IC Design Co., Ltd. PCIE # GPP Bridge [1d94:1453]
#         Kernel driver in µse: pcieport
# 00:01.6 PCI bridge [0604]: Chengdu Haiguang IC Design Co., Ltd. PCIE # GPP Bridge [1d94:1453]
#         Kernel driver in µse: pcieport
# 00:02.0 Host bridge [0600]: Chengdu Haiguang IC Design Co., Ltd. # PCIe Dummy Host Bridge [1d94:1452]
# 00:03.0 Host bridge [0600]: Chengdu Haiguang IC Design Co., Ltd. # PCIe Dummy Host Bridge [1d94:1452]
# 00:04.0 Host bridge [0600]: Chengdu Haiguang IC Design Co., Ltd. # PCIe Dummy Host Bridge [1d94:1452]
# 00:07.0 Host bridge [0600]: Chengdu Haiguang IC Design Co., Ltd. # PCIe Dummy Host Bridge [1d94:1452]
# ......
# ......
# 01:00.0 Ethernet controller [0200]: Intel Corporation I350 Gigabit # Network Connection [8086:1521] (rev 01)
#         Kernel driver in µse: igb
#         Kernel modules: igb, rt_igb
# 01:00.1 Ethernet controller [0200]: Intel Corporation I350 Gigabit # Network Connection [8086:1521] (rev 01)
#         Kernel driver in µse: igb
#         Kernel modules: igb, rt_igb
# 01:00.2 Ethernet controller [0200]: Intel Corporation I350 Gigabit # Network Connection [8086:1521] (rev 01)
#         Kernel driver in µse: igb
#         Kernel modules: igb, rt_igb
# 01:00.3 Ethernet controller [0200]: Intel Corporation I350 Gigabit # Network Connection [8086:1521] (rev 01)
#         Kernel driver in µse: igb
#         Kernel modules: igb, rt_igb
# 01:10.0 Ethernet controller [0200]: Intel Corporation I350 Ethernet # Controller Virtual Function [8086:1520] (rev 01)
#         Kernel driver in µse: vfio-pci
#         Kernel modules: igbvf
# ......
# ......
sudo vim /µsr/xenomai/etc/rtnet.conf
```

对配置文件进行简要说明, 解释如下

| 配置选项          | 描述                      |
| ----------------- | ------------------------- |
| RT_DRIVER         | rtnet 驱动名称            |
| RT_DRIVER_OPTIONS | rtnet 驱动索引            |
| REBIND_RT_NICS    | rtnet 驱动设备            |
| IPADDR            | rtnet 驱动加载后的静态 ip |
| NETMASK           | rtnet 驱动加载后的掩码    |

配置文件路径为 /µsr/xenomai/etc/rtnet.conf
针对上述几项配置，结合机器，修改配置文件

```conf
# RT-NIC driver
RT_DRIVER="rt_igb"
RT_DRIVER_OPTIONS="1"
REBIND_RT_NICS="0000:01:00.2" # 此项为支持 rt_igb 的 pci 设备的具体位置信息

IPADDR="192.168.1.244"  # 此项需根据实际网络环境进行配置
NETMASK="255.255.255.255" # 此项需根据实际网络环境进行配置

#TDMA_MODE="master"
#TDMA_SLAVES="127.0.0.1"
#TDMA_CYCLE="5000"
#TDMA_CONFIG="${prefix}/etc/tdma.conf"
```

对必要配置选项针对不同设备, ip 网段配置完成后, 取消 TDMA 相关配置(在配置文件中注释掉 TDMA 相关选项即可)

以下为配置文件修改样例


#### 1: 修改驱动名称

```txt
RT_DRIVER="rt_igb"
```

#### 2: 修改网卡索引

```txt
RT_DRIVER_OPTIONS="1"
```

#### 3: 选择支持 rt_igb 驱动的 pci 网卡设备路径信息

```txt
REBIND_RT_NICS="0000:01:00.2"
```

### 4: 配置实时网卡的静态 ip 以及 netmask 

```txt
IPADDR="192.168.1.244"  # 此项需根据实际网络环境进行配置
NETMASK="255.255.255.255" # 此项需根据实际网络环境进行配置
```

#### 5: 删除 TDMA 配置默认配置选项（TDMA 暂未开放）
```txt
# TDMA_MODE="master"
# TDMA_SLAVES="127.0.0.1"
# TDMA_CYCLE="5000"
# TDMA_CONFIG="${prefix}/etc/tdma.conf"
```

以下是 rtnet.conf 配置文件示例

```txt
# ......
# ......

# RT-NIC driver
RT_DRIVER="rt_igb"
RT_DRIVER_OPTIONS="1"

# PCI addresses of RT-NICs to claim (format: 0000:00:00.0)
#   If both Linux and RTnet drivers for the same hardware are loaded, this
#   list instructs the start script to rebind the given PCI devices, detaching
#   from their Linux driver, attaching it to the RT driver above. Example:
#   REBIND_RT_NICS="0000:00:19.0 0000:01:1d.1"
REBIND_RT_NICS="0000:01:00.2"

# IP address and netmask of this station
#   The TDMA_CONFIG file overrides the IPADDR parameter for masters.
#   Leave blank if you do not µse IP addresses or if this station is
#   intended to retrieve its IP from the master based on its MAC address.
#   If this station is a TDMA master, netmask is µsed also for slaves.
#   If leaved blank, the default netmask for the IPADDR IP class will be µsed.
IPADDR="192.168.1.244"
NETMASK="255.255.255.255"

# ......
# ......

# TDMA_MODE="master"
# TDMA_SLAVES="127.0.0.1"
# TDMA_CYCLE="5000"
# TDMA_CONFIG="${prefix}/etc/tdma.conf"

```

**`xenomai rtnet` 工具路径在 /µsr/xenomai/bin/**

以 `sx21` 机器为样例，具体操作如下

```shell
ls /µsr/xenomai/bin/rt* -al
# -rwxr-xr-x 1 root root 14464 May 11  2023 /µsr/xenomai/bin/# rtcanconfig
# -rwxr-xr-x 1 root root 18568 May 11  2023 /µsr/xenomai/bin/rtcanrecv
# -rwxr-xr-x 1 root root 23112 May 11  2023 /µsr/xenomai/bin/rtcansend
# -rwxr-xr-x 1 root root 18560 May 11  2023 /µsr/xenomai/bin/rtcfg
# -rwxr-xr-x 1 root root 18560 May 11  2023 /µsr/xenomai/bin/rtifconfig
# -rwxr-xr-x 1 root root 14464 May 11  2023 /µsr/xenomai/bin/rtiwconfig
# -rwxr-xr-x 1 root root  8185 May 11  2023 /µsr/xenomai/bin/rtnet
# -rwxr-xr-x 1 root root 14472 May 11  2023 /µsr/xenomai/bin/rtping
# -rwxr-xr-x 1 root root 14464 May 11  2023 /µsr/xenomai/bin/rtps
# -rwxr-xr-x 1 root root 14464 May 11  2023 /µsr/xenomai/bin/rtroute
rtnet start
# Stage 1: searching for master...
rtifconfig
# rteth0    Medium: Ethernet  Hardware address: C8:6B:BC:80:08:EE
#           IP address: 192.168.1.244  Broadcast address: 192.168.1.244
#           UP BROADCAST RUNNING  MTU: 1500
#           RX packets:5 errors:0 dropped:0 overruns:0 frame:0
#           TX packets:0 errors:0 dropped:0 overruns:0 carrier:0
#           collisions:0
#           RX bytes:300 (300.0 b)  TX bytes:0 (0.0 b)
# 
# rtlo      Medium: Local Loopback
#           IP address: 127.0.0.1
#           UP LOOPBACK RUNNING  MTU: 1500
# 
rtifconfig rteth0 down
rtifconfig rteth0 up 192.168.1.244 netmask 255.255.255.255
rtroute add 192.168.1.244 C8:6B:BC:80:08:EE dev rteth0
rtifconfig
# rteth0    Medium: Ethernet  Hardware address: C8:6B:BC:80:08:EE
#           IP address: 192.168.1.244  Broadcast address: 192.168.1.244
#           UP BROADCAST RUNNING  MTU: 1500
#           RX packets:181 errors:0 dropped:0 overruns:0 frame:0
#           TX packets:0 errors:0 dropped:0 overruns:0 carrier:0
#           collisions:0
#           RX bytes:12022 (11.7 Kb)  TX bytes:0 (0.0 b)
# 
# rtlo      Medium: Local Loopback
#           IP address: 127.0.0.1
#           UP LOOPBACK RUNNING  MTU: 1500
# 
rtroute
# Host Routing Table
# Hash    Destination     HW Address              Device
# 00      0.0.0.0         00:00:00:00:00:00       rtlo
# 01      127.0.0.1       00:00:00:00:00:00       rtlo
# 34      192.168.1.244   C8:6B:BC:80:08:EE       rteth0
# 34      192.168.1.244   00:00:00:00:00:00       rtlo
# 
# Network Routing Table
# Hash    Destination     Mask                    Gateway
rtroute
# Host Routing Table
# Hash    Destination     HW Address              Device
# 00      0.0.0.0         00:00:00:00:00:00       rtlo
# 01      127.0.0.1       00:00:00:00:00:00       rtlo
# 2B      192.168.1.107   38:CA:84:3E:17:12       rteth0
# 34      192.168.1.244   C8:6B:BC:80:08:EE       rteth0
# 34      192.168.1.244   00:00:00:00:00:00       rtlo
# 
# Network Routing Table
# Hash    Destination     Mask                    Gateway
rtping 192.168.1.107
# Real-time PING 192.168.1.107 56(84) bytes of data.
# 64 bytes from 192.168.1.107: icmp_seq=1 time=196.8 µs
# 64 bytes from 192.168.1.107: icmp_seq=2 time=206.4 µs
# 64 bytes from 192.168.1.107: icmp_seq=3 time=151.2 µs
# ^C
# --- 192.168.1.107 rtping statistics ---
# 3 packets transmitted, 3 received, 0% packet loss
# worst case rtt = 206.4 µs
```

此时 `rtnet` 驱动以及基础配置完成

当手动将其他机器如 ip: 192.168.1.107，mac: 38:CA:84:3E:17:12 添加至静态路由表中，使用 `rtping` 则可以完成基础网络测试