### 实时程序初始化

从用户代码的角度来看，每个应用程序都像往常一样在main()程序中开始。

`Cobalt`提供了两种不同的启动方式：自动启动和手动启动

--
### 自动启动

- **定义**：如果采用自动启动模式，应用程序会自动接收传递到 main() 函数中的命令行参数，这些参数已经排除了 [标准命令行选项](https://help.sinsegye.com.cn/docs/SinsegyeMetaOSoptions) 。
- **行为**：在这种模式下，当进入 main() 函数时，所有 `Cobalt` 服务已经就绪并可供使用。
- **用途**：这是大多数应用程序应该使用的默认行为。

### 手动启动

- **定义**：在手动启动模式中，应用程序接收未修改的原始参数列表，并且 `Cobalt` 服务未初始化。
- **行为**：如果您需要在启动 `Cobalt` 服务之前进行一些早期的初始化，应该使用此模式。
- **如何启用**：参考 [构建实时程序(手动启动)](https://help.sinsegye.com.cn/docs/compile-code-manual)。
- **实施步骤**：
  - 在初始化阶段的某个点，应用程序代码必须调用 `xenomai_init(&argc, &argv)` 来启动进程的 `Cobalt` 服务。
  - 这个函数处理所有标准的 `Cobalt` 选项，然后更新参数指向一个清除了[标准命令行选项](https://help.sinsegye.com.cn/docs/SinsegyeMetaOSoptions)参数的副本。

### C++静态构造函数处理注意

- 自动启动模式

在自动启动模式下，`Cobalt` 确保在执行任何主执行文件中的 C++ 静态对象构造函数之前，其服务已经被初始化。这意味着，位于主执行文件中的静态对象的构造函数可以安全地调用 `Cobalt` 服务。这种保证适用于默认优先级的静态构造函数。

- 手动启动模式

与自动模式不同，手动启动模式下，`Cobalt` 服务在调用 `xenomai_init()` 之前不可用。如果你选择手动模式，需要在 `xenomai_init()` 被成功调用之后，才能在构造函数中安全地使用 `Cobalt` 服务。这意味着，如果构造函数需要在此之前使用 `Cobalt` 服务，你需要在静态对象构造之前手动初始化 `Cobalt`。

- 在共享库中的静态对象

如果静态对象被实例化在共享库中，无论是在自动还是手动模式下，这些对象的构造函数都无法访问 `Cobalt` 服务，因为它们被实例化的时间点在 `Cobalt` 启动代码之前。这是因为共享库的加载和初始化通常在主执行文件的初始化之前完成。

- 非默认静态构造优先级

如果你有使用非默认构造优先级的静态对象，或者你的执行文件依赖于实例化了静态对象的共享库，你可能需要在这些构造函数尝试调用 `Cobalt` 服务之前，提供自己的早期引导代码。这包括在合适的时间点调用 `xenomai_init()`，以确保在这些静态构造函数运行时，`Cobalt` 服务已经可用。

### 程序初始化顺序

实时应用程序初始化过程引导软件层如下：

![](https://resource.helplook.net/docker_production/3648ne/article/NQWiqV6x/a72b0474c2f57723870a89d00b01f9f2.png)


如果您使用手动初始化程序，请参考[构建实时程序(手动启动)](https://help.sinsegye.com.cn/docs/compile-code-manual)