### 标准命令行选项
应用程序如何自动识别一组标准的命令行选项，以及如何使用这些选项来调试和配置应用程序。这些选项可以在不需要修改应用程序代码的情况下被解释和执行。例如，使用 --dump-config 选项，应用程序会自动输出其链接的 `Cobalt` 库的构建设置。

| 选项                            | 描述                                                      |
| ------------------------------- | --------------------------------------------------------- |
| `--main-prio=<prio>`            | 设置主线程优先级                                          |
| `--print-buffer-size=<bytes>`   | 设置用于输出的打印缓冲区大小，默认为 16k                  |
| `--print-buffer-count=<num>`    | 设置输出环中的缓冲区总数，默认为 4                        |
| `--print-sync-delay=<ms>`       | 设置输出缓冲区同步之前的最长延迟，默认每 100 毫秒刷新一次 |
| `--cpu-affinity=<cpu[,cpu]...>` | 设置线程的 CPU亲和性                                      |
| `--[no-]sanity`                 | 关闭/开启 健壮性检查                                      |
| `--verbose[=level]`             | 将详细程度设置为所需的水平，默认值为1                     |
| `--silent`, `--quiet`           | Same as `--verbose=0`                                     |
| `--trace[=level]`               | 将trace设置为所需的级别，默认值为1                        |
| `--version`                     | 获取实时核版本信息                                        |
| `--dump-config`                 | 构建应用程序链接的Cobalt库的设置                          |
| `--help`                        | 帮助                                                      |

---
#### --main-prio

用于这是主线程的线程优先级，通常是在 main() 函数内部进行。

**参数 <priority> 的具体规则如下**：
1. 如果 <priority> 为零 (0):
调用线程将被分配 `SCHED_OTHER` 调度策略。这是标准的非实时调度策略，通常用于普通的后台处理。
2. 如果 <priority> 大于零 (>0):
调用线程将被分配 `SCHED_FIFO` 调度策略，并设置为给定的优先级。`SCHED_FIFO`（先进先出）是一种实时调度策略，确保了更高优先级的线程总是能够在低优先级线程之前运行。
3. 如果 <priority> 为负数 (<0):
调用线程的调度参数将保持不变。


#### --print-buffer-size

标准输出函数（如 printf(3), fprintf(3), 和 puts(3)）背后的缓冲机制。

当启用符号封装时，`Cobalt` 会介入常见的 `stdio` 输出调用。这意味着，即便是在实时线程中调用如 `printf` 等函数，也不会因为等待 I/O 操作而阻塞，从而保证了实时性。

这些 `stdio` 调用使用一种缓冲区的机制。这些缓冲区组成一个输出环，由实时线程无锁地填充，然后定期由一个常规的（非实时）Linux 帮助线程刷新到进程的目的输出流（如 `stdout`、`stderr` 或其他特定的流）。

**参数用途**:

- 缓冲区大小设置：通过 `--print-buffer-size` 参数，开发者可以设置每个缓冲区的大小。默认情况下，每个缓冲区大小为 16 KB。
- 性能调优：调整缓冲区大小可以根据特定应用的输出需求和性能特征进行优化。更大的缓冲区可能会减少需要刷新的频率，从而降低管理缓冲区的开销，但同时也可能增加内存使用量。

#### --print-buffer-count

用于设置输出环中缓冲区的总数量。这些缓冲区与之前提到的 `--print-buffer-size` 参数密切相关，后者定义了单个缓冲区的大小。

**参数用途**:

- 缓冲区总数设置：此参数允许你指定输出环中应存在的缓冲区的总数。默认情况下，系统配置有 4 个缓冲区。
- 输出管理：缓冲区是由实时线程填充的，然后由一个非实时的 `Linux` 帮助线程定期清空，将数据刷新到如 `stdout` 或 `stderr` 这样的目的输出流。通过增加缓冲区的数量，可以提高在高负载下处理输出请求的能力，因为这样可以在输出流被阻塞或延迟时存储更多的输出数据。

#### --print-sync-delay

此参数用于设置输出环中缓冲区内容在被同步到最终输出流之前的最大延迟时间，单位为毫秒（ms），这与之前提到的 `--print-buffer-size` 和 `--print-buffer-count` 参数配合使用，共同管理输出数据的处理。

**参数用途**:

- 延迟时间设置：通过此参数，你可以指定在输出数据被最终刷新到如 stdout 或 stderr 的输出流之前，可以在缓冲区中保留的最长时间。默认情况下，输出环每 100 毫秒被刷新一次。
- 输出流管理：缓冲区由实时线程填充，而清空操作则由一个非实时的 Linux 辅助线程周期性地执行。设置这个延迟参数可以帮助调整输出数据刷新的频率，以适应应用程序的实际需求。

#### --cpu-affinity

用于指定 `Cobalt` 应用程序创建的线程可以运行的 CPU 集合。这个参数在没有明确指定线程应该固定运行在特定 CPU 上时非常有用。默认情况下，线程可以在任何在线的 CPU 上运行。

**参数用途**:
- CPU 亲和性设置：通过此参数，可以为应用程序中的实时线程指定一个或多个 CPU，允许这些线程只在指定的 CPU 上运行。这可以通过列出有效（即在线的）CPU 编号，并用逗号分隔来实现。
- 线程性能优化：为线程设置 CPU 亲和性可以减少 CPU 之间的上下文切换，提高线程的运行效率。固定线程到特定的 CPU 也有助于更好地利用 CPU 缓存，减少缓存丢失，从而提高性能。
- 重复使用：这个选项可以在命令行中多次出现，每次出现都会累积设置。这意味着可以逐步构建最终的 CPU 亲和性设置，根据需要调整每个线程或线程组的 CPU 分配。

#### --[no-]sanity

用于在 `Cobalt` 库中开启或关闭启动期间的健全性检查。这是一个开关选项，其中 --sanity 表示开启检查，而 --no-sanity 表示关闭检查。这些检查主要在应用程序启动时进行，以确保运行环境符合预期的配置和健康状态。

**检查的内容**：

这些健全性检查包括但不限于：

- 确认运行 `Cobalt` 库的系统配置是否正确。

#### --verbose

用于设置 `Cobalt` 应用程序的输出详细级别。这个参数允许应用程序在运行时显示多少详细的日志或调试信息。

**参数用途**:

- 没有指定具体级别：如果在命令行中使用 --verbose 而没有指定级别，那么默认的详细级别会被设置为 1。这意味着将启用基本的详细输出。
- 完全静默：使用 --verbose=0 将会关闭所有日志输出，确保应用程序在运行时不会输出任何信息。这通常用于生产环境，或者当用户需要确保输出不会干扰到程序输出的其他部分时。

#### --silent，--quiet

与参数 `--verbose=0` 相同

### --trace

用来调整和控制应用程序的跟踪详细度，有助于监控和调试内部操作。