### 安装 `stress-ng`
首先确保你已经安装了 `stress-ng`。如果没有安装，可以通过以下命令进行安装：

```bash
sudo apt update
sudo apt install stress-ng
```

### 测试 CPU、内存和磁盘 I/O

#### 1. CPU 压力测试
你可以指定 CPU 的负载程度和运行时间来进行测试。例如，使用 4 个 CPU 核心运行 60 秒：

```bash
sudo stress-ng --cpu 4 --timeout 60s
```

这会让 `stress-ng` 使用 4 个 CPU 核心进行计算密集型操作，持续 60 秒。

#### 2. 内存压力测试
你可以使用 `--vm` 选项来测试内存。`stress-ng` 会启动多个虚拟内存工作线程来分配并操作内存块。下面是使用 2 个内存线程测试内存，持续 60 秒的示例：

```bash
sudo stress-ng --vm 2 --vm-bytes 1G --timeout 60s
```

此命令会启动 2 个内存线程，每个线程分配 1GB 内存，持续 60 秒。

#### 3. 磁盘 I/O 压力测试
你可以使用 `--hdd` 选项来执行磁盘 I/O 压力测试。此示例使用 2 个线程，进行 I/O 操作，持续 60 秒：

```bash
sudo stress-ng --hdd 2 --timeout 60s
```

这将创建 2 个磁盘 I/O 工作线程，持续写入文件，执行 60 秒的磁盘 I/O 操作。

#### 4. 综合 CPU、内存和磁盘 I/O 压力测试
你还可以同时测试 CPU、内存和磁盘 I/O。下面是一个综合测试的例子：

```bash
sudo stress-ng --cpu 4 --vm 2 --vm-bytes 1G --hdd 2 --timeout 60s
```

此命令会同时运行：
- 4 个 CPU 线程进行计算任务。
- 2 个虚拟内存线程，每个线程分配 1GB 内存。
- 2 个磁盘 I/O 线程。

所有任务持续 60 秒。

##### 其他常用参数
- `--cpu-load PERCENTAGE`：设置 CPU 负载百分比（例如 `--cpu-load 80` 表示保持 CPU 使用率在 80% 左右）。
- `--metrics-brief`：显示简洁的测试结果摘要，方便查看。
- `--hdd-bytes SIZE`：指定要写入的字节数，测试磁盘 I/O。

##### 示例总结
综合运行 CPU、内存和磁盘 I/O 压力测试的命令如下：
```bash
sudo stress-ng --cpu 4 --cpu-load 80 --vm 2 --vm-bytes 1G --hdd 2 --timeout 60s --metrics-brief
```

这个命令会持续 60 秒，使用 4 个 CPU 核心、2 个虚拟内存线程（每个分配 1GB 内存）和 2 个磁盘 I/O 线程，保持 CPU 负载在 80%。