Benchmark | Units | Version | Source 
--- | --- | --- | --- 
Cyclictest |microseconds | 2.7 |https://git.kernel.org/pub/scm/utils/rt-tests/rt-tests.git/snapshot/rt-tests-2.7.tar.gz


```bash
cd rt-tests-2.7
make
sudo make install
```

#### 基本命令行格式
```bash
cyclictest [选项]
```

#### 常用选项

1. **`-t [num]`**：指定线程数。
   ```bash
   cyclictest -t 4
   ```
   这将启动 4 个线程来进行延迟测试。

2. **`-p [priority]`**：设置线程的实时优先级（1 到 99，数字越高优先级越高）。
   ```bash
   cyclictest -p 80
   ```
   这将为测试线程设置优先级为 80。

3. **`-n`**：不对线程进行时间片调度（即使用 `SCHED_FIFO` 调度策略）。
   ```bash
   cyclictest -n
   ```
   此选项确保线程以 FIFO（先入先出）方式调度，不允许时间片调度。

4. **`-i [interval]`**：设定线程的唤醒间隔（以微秒为单位）。
   ```bash
   cyclictest -i 1000
   ```
   这将线程唤醒的时间间隔设置为 1000 微秒（1 毫秒）。

5. **`-l [loops]`**：设置循环次数。测试将运行指定次数后停止。
   ```bash
   cyclictest -l 10000
   ```
   该命令将运行 10000 次循环测量延迟。

6. **`-D [duration]`**：设置测试运行时间（支持时间格式如 `s` 秒, `m` 分钟, `h` 小时）。
   ```bash
   cyclictest -D 60s
   ```
   这将让测试运行 60 秒后自动停止。

7. **`-h`**：显示帮助信息。
   ```bash
   cyclictest -h
   ```

8. **`-q`**：静默模式，禁用输出，仅显示测试结果。

9. **`-m`**：锁定内存，防止内存页交换到磁盘，以保持测试的实时性。
   ```bash
   cyclictest -m
   ```

10. **`-a [cpu-list]`**：将线程绑定到特定的 CPU 核心上。
    ```bash
    cyclictest -a 0-3
    ```
    这将把线程绑定到 CPU 0 到 3 核心上运行。

11. **`--histogram [bucket-size]`**：生成延迟直方图，`bucket-size` 是桶的大小（以微秒为单位）。
    ```bash
    cyclictest --histogram=10
    ```
    生成延迟数据的直方图，每个桶大小为 10 微秒。

#### 综合示例

假设你想运行 4 个线程，实时优先级为 80，唤醒间隔为 1000 微秒，绑定到 CPU 0 和 1，测试持续 60 秒，同时生成直方图：

```bash
cyclictest -t 4 -p 80 -i 1000 -a 0-1 -D 60s --histogram=10
```

##### 关键术语

- **T (线程)**：  
   线程的索引和 ID。`cyclictest` 可以创建多个线程来模拟多线程条件下的实时性能。

- **P (优先级)**：  
   分配给线程的实时优先级。在 Linux 中，实时优先级的范围是 1（最低）到 99（最高）。数值越大，调度优先级越高。

- **I (间隔)**：  
   线程应唤醒并测量延迟的预期周期（以微秒为单位）。这个间隔是用户定义的，表示实时任务的唤醒频率。

- **C (计数)**：  
   线程中测量延迟的次数，即唤醒事件的总计数。

- **Min (最小延迟)**：  
   测试期间观察到的最小延迟。表示线程唤醒时间中观察到的最短延迟。

- **Act (实际延迟)**：  
   最近一次迭代中测量的延迟。这是预期唤醒和实际唤醒之间的实时延迟。

- **Avg (平均延迟)**：  
   整个测试期间的平均延迟。它可以帮助了解系统在整个测试中的整体性能一致性。

- **Max (最大延迟)**：  
   测试期间观察到的最大延迟。对于实时系统，这个值至关重要，因为它表示系统响应的最差情况或最大的延迟。

#### 示例解释

假设你有以下 Cyclictest 结果：

| 线程 | 优先级 | 间隔 | 计数 | 最小延迟 | 实际延迟 | 平均延迟 | 最大延迟 |
|------|--------|------|------|----------|----------|----------|----------|
| 0    | 99     | 1000 µs  | 10000 | 5 µs   | 8 µs   | 6 µs   | 15 µs   |

- **线程 0** 的运行优先级为 **99**（较高的实时优先级）。
- 设定的 **间隔** 为 1000 微秒，意味着线程应该每 1 毫秒唤醒一次。
- 测试运行了 **10000 次迭代**，每次迭代测量延迟。
- **最小延迟** 为 5 微秒，表示系统在最佳情况下几乎立即响应。
- **最近一次（实际）** 延迟为 8 微秒。
- **平均延迟** 为 6 微秒，表示系统在整个测试期间表现稳定。
- **最大延迟** 为 15 微秒，代表测试期间观察到的最差响应时间。

在实时系统中，通常 **最大延迟** 是最关键的值，因为它表明系统响应的最长延迟，可能会影响时间敏感的应用程序。

`Cyclictest` 是一个用于测量 Linux 系统实时性能的工具，尤其是测量线程唤醒延迟。你可以通过不同的命令行参数来配置测试。下面是一些常用的 `Cyclictest` 命令行选项及其解释：