Benchmark | Units | Version | Source 
--- | --- | --- | --- 
Cyclictest |microseconds | 2.7 |https://git.kernel.org/pub/scm/utils/rt-tests/rt-tests.git/snapshot/rt-tests-2.7.tar.gz

```bash
cd rt-tests-2.7
make
sudo make install
```

```bash
sudo hwlatdetect --threshold=1µs --duration=1m --window=1000ms --width=950ms --report=hwlat.log
```

`hwlatdetect` 是用于检测系统中由硬件中断（如 SMI，System Management Interrupts）引起的延迟的工具。它通过在运行时捕获延迟来测量系统中潜在的硬件层面的性能问题。下面是一些常用的 `hwlatdetect` 命令行选项及其解释。

#### 基本命令行格式
```bash
hwlatdetect [选项]
```

#### 常用选项

1. **`--duration [seconds]`**：设置测试运行时间（以秒为单位）。
   ```bash
   sudo hwlatdetect --duration 120
   ```
   这将让测试运行 120 秒。

2. **`--threshold [microseconds]`**：设置延迟阈值（以微秒为单位）。超出该阈值的延迟会被报告。
   ```bash
   sudo hwlatdetect --threshold 10
   ```
   这将把延迟阈值设置为 10 微秒。

3. **`--window [microseconds]`**：设置采样窗口的大小（以微秒为单位）。在这个窗口期间内进行延迟测量。
   ```bash
   sudo hwlatdetect --window 1000000
   ```
   这会将采样窗口设置为 1000000 微秒（1 秒）。

4. **`--width [microseconds]`**：设置每次采样的时间宽度（以微秒为单位），表示在非采样周期内测量的时间。
   ```bash
   sudo hwlatdetect --width 500000
   ```
   此命令将采样宽度设置为 500000 微秒（0.5 秒）。

5. **`--nonsample [microseconds]`**：设置非采样周期的时间长度（以微秒为单位），即在两次采样之间的休眠时间。
   ```bash
   sudo hwlatdetect --nonsample 500000
   ```
   这将非采样时间设为 500000 微秒（0.5 秒）。

6. **`--tracer [type]`**：选择使用的延迟探测器，默认是 `tracer`。
   ```bash
   sudo hwlatdetect --tracer tracer
   ```
   这个选项可以设置为 `tracer`，或者使用其他自定义探测器。

7. **`--cpµs [cpu-list]`**：指定在哪些 CPU 上运行延迟检测。支持 CPU 列表格式（例如 `0-3` 或 `0,1,2`）。
   ```bash
   sudo hwlatdetect --cpµs 0-3
   ```
   此命令将限制检测范围，仅在 CPU 0 到 3 上运行。

8. **`--output [file]`**：指定输出文件以保存检测结果。
   ```bash
   sudo hwlatdetect --output result.txt
   ```
   结果将被保存到 `result.txt` 文件中。

9. **`--debug`**：启用调试输出，用于更详细的输出和日志记录。

10. **`--help`**：显示帮助信息和所有可用的命令行选项。
   ```bash
   hwlatdetect --help
   ```

#### 综合示例

假设你想运行 `hwlatdetect` 进行 120 秒的测试，延迟阈值设置为 10 微秒，采样窗口为 1 秒，采样宽度为 0.5 秒，非采样周期为 0.5 秒，输出到文件 `hwlat_results.txt`：

```bash
sudo hwlatdetect --duration 120 --threshold 10 --window 1000000 --width 500000 --nonsample 500000 --output hwlat_results.txt
```