### 产品概念
awCenter平台，是设备接入与管理的一体化平台。它实现设备的快速接入和设备生命周期的高效管理，为用户提供一站式的物联网解决方案。实现设备数据的接入与整合，支持对设备进行增加、删除、修改、查询，以及用户设备和应用交互进行在线调试等功能操作，并以直观的可视化界面向用户展示设备状态、设备影子、设备上报下发数据及设备故障报警等信息。同时为物联网应用提供修改设备或者所属传感器基本信息的功能，实现对新增设备接入的灵活操作和远程控制。

awCenter设备应用模拟器平台支持设备通过MQTT、OPCUA、HTTPS等通用原生通信协议对接物联网平台。同时提供开放的泛协议接入框架，支持加载和管理第三方/客户开发的基于ACP、TCP的私有协议接入驱动，从而实现私有协议设备的接入。

#### 产品特点

产品功能架构
![](https://resource.helplook.net/docker_production/3648ne/article/n5GtFTcM/6881a17650519.png)


#### 设备操作流程

1. 主体操作流程
![](https://resource.helplook.net/docker_production/3648ne/article/n5GtFTcM/6881a18e8a6ce.png)
![](https://resource.helplook.net/docker_production/3648ne/article/n5GtFTcM/6881a18ea2114.png)

---
### 功能介绍

#### 概览大屏

客户可以使用awCenter概览大屏快速了解到当前接入设备的实时运行状态、设备影子、设备上报下发数据及设备故障报警信息。

#### 登陆页面

**功能概述**

用户使用邮箱和密码登录和注册系统平台，若为首次登录需进行密码重置修改以确保客户密码安全性。
![](https://resource.helplook.net/docker_production/3648ne/article/n5GtFTcM/6881a1cf17fee.png)

---
### 操作流程

**访问系统**

网络协议采用TCP/IP协议，显示器分辨率>=1920 \* 1080，且谷歌内核浏览器（版本>=92）访问：[http://dev.app.sinsegye.com.cn:20591/](http://dev.app.sinsegye.com.cn:20601/) 后进入进入平台登录页面。


 **身份验证**

用户输入用户名、密码后，点击登录按钮或敲击回车键登录。登陆成功后进入产品管理页面。首次登录需进行密码重置。


### 产品管理

**功能概述**

客户使用产品管理完成对产品的管理，查看所属公司下指定产品下辖所有设备的数量及信息。同一公司下的产品型号不允许重复。

**产品查询**

登录系统后点击 “**产品管理**” 进入产品管理页面，用户可查看系统内置产品及用户所属公司创建的产品。查询显示产品型号、产品名称、通讯协议、创建公司、产品图片、产品描述，制造商、创建时间、操作。产品列表默认按照创建时间由近及远倒序排列，支持按创建时间正序、反序排列。
![](https://resource.helplook.net/docker_production/3648ne/article/n5GtFTcM/6881a215a3cef.png)

输入产品型号或产品名称，选择通讯方式，点击 **查询** 按钮筛选指定产品。
![](https://resource.helplook.net/docker_production/3648ne/article/n5GtFTcM/6881a21f6b7ea.png)

**创建产品**

用户在产品管理页面点击 “**创建产品**”。在弹出的创建产品对话框中输入产品信息，点击 **确定** 。其中产品型号可自定义填写，同公司内 **产品型号&#x20;**&#x4E0D;可重复，**通讯协议** 为产品所支持的所有数据传输和通信协议、**数据格式** 是产品在进行数据传输时所采用的报文具体结构和规范（可选二进制或json），产品图片支持 jps、png 格式，最大不得超过 10mb。
![](https://resource.helplook.net/docker_production/3648ne/article/n5GtFTcM/6881a23a8c121.png)

**编辑产品**

点击指定产品操作栏中的 **编辑&#x20;**&#x6309;钮。在弹出的对话框中输入编辑相关内容，点击 **确定&#x20;**。其中，产品型号、通讯协议不可编辑。
![](https://resource.helplook.net/docker_production/3648ne/article/n5GtFTcM/6881a246ce675.png)

**删除产品**

**指定产品删除**

点击指定产品操作栏中的 **删除&#x20;**&#x6309;钮。在弹出的二次确认窗口中点击 **确定**。
![](https://resource.helplook.net/docker_production/3648ne/article/n5GtFTcM/6881a262d06f7.png)

#### **多选产品删除**

勾选或全选待删除产品，点击 “**多选删除**”。在弹出的二次确认窗口中点击 **确定**。
![](https://resource.helplook.net/docker_production/3648ne/article/n5GtFTcM/6881a26ab2992.png)

### 设备管理

**功能概述**

客户使用设备管理对所属公司内的所有设备进行管理，实现设备注册、编辑、删除操作。同一公司下的设备编号不允许重复。

**设备查询**

点击 “**设备管理**” 进入设备管理页面，设备列表显示当前用户所绑定的设备。查询显示设备名称、设备编号、产品名称、产品型号、通讯方式、在线状态、激活状态、启用状态、设备图片、归属公司、设备描述、操作。设备列表默认按照创建时间由近及远倒序排列，支持按创建时间正序、反序排列。
![](https://resource.helplook.net/docker_production/3648ne/article/n5GtFTcM/6881a2b0a0327.png)


输入 设备名称 或 设备编号 或 产品型号，选择通讯方式，输入归属公司，选择在线状态，点击 **查询** 按钮筛选指定设备。

**注册设备**

用户在设备列表页面点击 “注册设备”。在弹出的注册设备窗口中输入设备编号、设备名称、选择设备类型、通讯协议，选择产品型号，输入设备描述，点击 **确定&#x20;**。
![](https://resource.helplook.net/docker_production/3648ne/article/n5GtFTcM/6881a2ca09112.png)

**编辑设备**

点击指定设备操作栏的 **编辑&#x20;**&#x6309;钮。在弹出的编辑设备窗口中可以修改设备名称、设备类型、通讯协议，设备描述，点击 **确定&#x20;**&#x5B8C;成设备编辑。
![](https://resource.helplook.net/docker_production/3648ne/article/n5GtFTcM/6881a2d81bfdd.png)


#### 删除设备

**指定设备删除**

点击指定设备操作栏的 **删除&#x20;**&#x6309;钮。在弹出的二次确认窗口中点击 **确定&#x20;**。
![](https://resource.helplook.net/docker_production/3648ne/article/n5GtFTcM/6881a2f17fe9d.png)


**多选设备删除**

勾选或全选需删除的设备，点击 **多选删除** 。在弹出的二次确认窗口中点击 **确定&#x20;**。
![](https://resource.helplook.net/docker_production/3648ne/article/n5GtFTcM/6881a30458715.png)

---
### 设备详情

**功能概述**

客户在设备详情页面查看指定设备的状态和实时数据信息，完成设备影子的配置及服务的增、删、改、查管理。对应每个服务，提供属性和指令的增、删、改、查管理。对应每个服务，提供服务参数的增、删、改、查管理。同一个设备内，服务名唯一；同一服务内，属性名称唯一、指令名称唯一；同一指令的下发参数或响应参数内，参数名称唯一。

**路径导航**

进入设备管理，点击指定设备编号，进入指定设备详情页面。
![](https://resource.helplook.net/docker_production/3648ne/article/n5GtFTcM/6881a325c7bdc.png)


#### 设备基本信息

进入设备详情页面后，点击上方 tab 页中 **总览&#x20;**&#x67E5;看设备基本信息。
![](https://resource.helplook.net/docker_production/3648ne/article/n5GtFTcM/6881a33b9aea2.png)

**密钥重置**

进入 “设备详情” 页面，点击设备基本信息中密钥栏中 “重置密钥” 按钮。
![](https://resource.helplook.net/docker_production/3648ne/article/n5GtFTcM/6881a34e80d78.png)

在弹出的重置密码弹窗中输入当前密码，新密码，并再次输入密码，点击 **确定&#x20;**。
![](https://resource.helplook.net/docker_production/3648ne/article/n5GtFTcM/6881a35990bba.png)


**设备实时数据**

进入 设备详情-总览 页面。模糊搜索服务名称，点击指定服务，右侧显示该服务的属性看板。
![](https://resource.helplook.net/docker_production/3648ne/article/n5GtFTcM/6881a36d406a0.png)

### **设备影子**

进入设备详情页面后，点击上方 tab 页中 **设备影子**，跳转至设备影子页面。
![](https://resource.helplook.net/docker_production/3648ne/article/n5GtFTcM/6881a386a10f5.png)


模糊搜索服务名，点击指定服务，右侧出现该服务的服务信息、属性列表、指令列表。
![](https://resource.helplook.net/docker_production/3648ne/article/n5GtFTcM/6881a38f51204.png)

**服务配置**

**添加服务**

点击添加服务按钮。在弹出的添加服务窗口中输入服务名称、服务类型、服务描述，点击 **保存&#x20;**。
![](https://resource.helplook.net/docker_production/3648ne/article/n5GtFTcM/6881a3a38d044.png)

**编辑服务**

点击指定服务栏右上角的 **编辑&#x20;**&#x6309;钮。在弹出的服务编辑窗口中输入服务类型、服务描述，点击 **保存&#x20;**。
![](https://resource.helplook.net/docker_production/3648ne/article/n5GtFTcM/6881a3b02e5cd.png)

**删除服务**

点击指定服务栏右上角的 **删除&#x20;**&#x6309;钮。在弹出的二次确认窗口中点击 **确定 ，**&#x5220;除该服务。
![](https://resource.helplook.net/docker_production/3648ne/article/n5GtFTcM/6881a3bad8838.png)


勾选或全选需删除的服务，点击 **多选删除&#x20;**&#x6309;钮。在弹出的二次确认窗口中点击 **确定&#x20;**。
![](https://resource.helplook.net/docker_production/3648ne/article/n5GtFTcM/6881a3e8bafb8.png)

**清除服务影子**

点击指定服务栏右上角的 **删除&#x20;**&#x6309;钮。在弹出的二次确认窗口中点击 **确定 ，**&#x6E05;除该服务所有影子数值。
![](https://resource.helplook.net/docker_production/3648ne/article/n5GtFTcM/6881a3f6bd199.png)

#### **影子配置**

**影子属性管理**

**创建属性**

选择指定服务，点击 **创建属性。**&#x5728;弹出的创建属性弹窗中输入属性名称、属性描述，选择数据类型、读写类型及其他信息，点击 **保存&#x20;**。
![](https://resource.helplook.net/docker_production/3648ne/article/n5GtFTcM/6881a40d3c174.png)

**编辑属性**

点击指定属性操作栏中的 **编辑&#x20;**&#x6309;钮。在弹出的编辑属性弹窗中输入属性描述，读写类型及其他信息，点击 **确定&#x20;**。
![](https://resource.helplook.net/docker_production/3648ne/article/n5GtFTcM/6881a41d401f3.png)

**删除属性**

点击指定属性操作栏中的 **删除&#x20;**&#x6309;钮。在弹出的二次确认窗口中点击 **确定&#x20;**。
![](https://resource.helplook.net/docker_production/3648ne/article/n5GtFTcM/6881a43b826cf.png)

**多选删除属性**

用户勾选或全选需删除的属性，点击 **多选删除&#x20;**&#x6309;钮。在弹出的二次确认窗口中点击 **确定&#x20;**。
![](https://resource.helplook.net/docker_production/3648ne/article/n5GtFTcM/6881a45407dae.png)

**清除属性影子**

点击指定属性操作栏中的 **清除&#x20;**&#x6309;钮。在弹出的二次确认窗口中点击 **确定&#x20;**。
![](https://resource.helplook.net/docker_production/3648ne/article/n5GtFTcM/6881a461d8559.png)

**影子数值配置**

**编辑设备影子数值**

点击 **影子配置&#x20;**&#x6309;钮。在弹出的属性配置页面中配置设备全部影子数值，点击 **保存&#x20;**。
![](https://resource.helplook.net/docker_production/3648ne/article/n5GtFTcM/6881a47651095.png)

**清除设备影子数值**

点击 **清除影子&#x20;**&#x6309;钮。在弹出的二次确认窗口中点击 **确定&#x20;**，清除设备全部影子数值。
![](https://resource.helplook.net/docker_production/3648ne/article/n5GtFTcM/6881a4829a25b.png)

**指令配置**

进入设备管理，选择指定设备编号，点击进入设备详情，上方 tab 页选择设备影子，跳转至设备影子页面，选择指定服务。点击创建指令，在弹出的创建指令弹窗中输入指令名称，管理下发、响应参数，点击 **确定&#x20;**。
![](https://resource.helplook.net/docker_production/3648ne/article/n5GtFTcM/6881a48e0c441.png)


用户点击创建参数按钮，在弹出的创建参数窗口中输入参数名称、参数描述、数据类型及其他信息，点击 **确定&#x20;**。
![](https://resource.helplook.net/docker_production/3648ne/article/n5GtFTcM/6881a4988971d.png)

用户可在编辑参数窗口编辑参数名称、参数描述、数据类型及其他信息，点击 **确定&#x20;**。
![](https://resource.helplook.net/docker_production/3648ne/article/n5GtFTcM/6881a49f05c80.png)

点击指定指令中的参数的删除按钮，进行参数删除操作。
![](https://resource.helplook.net/docker_production/3648ne/article/n5GtFTcM/6881a4a664ad0.png)

点击指定指令的编辑按钮，在弹出的指令编辑页面中编辑完成后点击 **确定&#x20;**。
![](https://resource.helplook.net/docker_production/3648ne/article/n5GtFTcM/6881a4adc35bb.png)


点击指定指令的删除按钮，在系统二次确认弹窗中点击 **确定&#x20;**。
![](https://resource.helplook.net/docker_production/3648ne/article/n5GtFTcM/6881a4b671f5b.png)

---
### 在线调试

用户登录系统后点击 “**在线调试**” 进入在线调试页面，可以进行应用模拟调试、设备模拟调试操作，完成命令下发流程和数据上报流程的模拟操作，及时发现通信过程的问题进行处理；还可以通过查看日志信息进行细节定位。

**应用模拟器**

进入在线调试页面后，默认选中应用模拟器，页面右侧显示平台上所有已激活、且在线的虚拟设备列表，用户通过选择设备、服务、需要调试的命令和参数信息，进行命令下发调试。
![](https://resource.helplook.net/docker_production/3648ne/article/n5GtFTcM/6881a4e1091b0.png)


点击调试输出模块的”应用模拟器”、”awCenter”、”设备”进行切换，分别查看数据流向过程的日志信息。
![](https://resource.helplook.net/docker_production/3648ne/article/n5GtFTcM/6881a516265b2.png)

日志信息根据所属的数据类型进行分类展示，可以进行日志的查看、复制、清除操作。
![](https://resource.helplook.net/docker_production/3648ne/article/n5GtFTcM/6881a50bedcb4.png)


切换至设备模拟器模块后，可以进行虚拟设备的数据上报流程模拟，需要选中模拟的设备、服务、以及数据上报的属性信息。
![](https://resource.helplook.net/docker_production/3648ne/article/n5GtFTcM/6881a51f4815c.png)


---
### 公司管理

**功能概述**

管理员使用公司管理可以对公司进行增删改查。公司名全网唯一，不允许重复。

**公司查询**

管理员登录系统后点击 “**公司管理**” 进入公司管理页面，查询内容显示：序号、公司编码、公司名称、地址、创建时间、描述和操作。输入公司名称，点击 **查询&#x20;**&#x6309;钮。
![](https://resource.helplook.net/docker_production/3648ne/article/n5GtFTcM/6881a5344012a.png)


**公司添加**

管理员在公司管理页面点击 “**添加公司**” 按钮。在弹出的窗口中输入公司名称、地址和描述后点击 **确定&#x20;**。
![](https://resource.helplook.net/docker_production/3648ne/article/n5GtFTcM/6881a540b9829.png)


**公司编辑**

点击指定公司操作栏中的 **编辑&#x20;**&#x6309;钮。在弹出窗口中修改公司信息，点击 **确定  。**
![](https://resource.helplook.net/docker_production/3648ne/article/n5GtFTcM/6881a55299db7.png)


**公司删除**

**指定公司删除**

管理员进入 “公司管理” 页面点击公司操作栏中 “删除” 按钮。在删除确认窗口中点击 **确定&#x20;**。
![](https://resource.helplook.net/docker_production/3648ne/article/n5GtFTcM/6881a57513c2a.png)

**多选公司删除**

勾选或全选待删除公司，点击 “**批量删除**”。在弹出的二次确认窗口中点击 **确定**。
![](https://resource.helplook.net/docker_production/3648ne/article/n5GtFTcM/6881a5b347c70.png)

---
### 角色管理

**功能概述**

客户使用角色管理可为公司创建角色。每个角色均可设定其可以使用的功能页面及按钮。同一公司下，角色名称不允许重复。

**角色查询**

系统管理员进入 “角色管理” 页面，查询内容显示：序号、角色名称、所属公司、创建时间、角色描述和操作。输入角色名称、选择所属公司后点击 **查询&#x20;**&#x6309;钮。
![](https://resource.helplook.net/docker_production/3648ne/article/n5GtFTcM/6881a617f02af.png)

**角色添加**

用户在角色管理页面点击 “**添加角色**” 按钮。在弹出窗口中输入角色信息并选择角色权限后点击 **确定&#x20;**。
![](https://resource.helplook.net/docker_production/3648ne/article/n5GtFTcM/6881a62347cc7.png)

**角色编辑**

点击指定角色操作栏中的 **编辑&#x20;**&#x6309;钮。在弹出窗口中修改角色信息后点击 **确定&#x20;**。
![](https://resource.helplook.net/docker_production/3648ne/article/n5GtFTcM/6881a63085e0c.png)

**角色删除**

**指定角色删除**

管理员进入 “角色管理” 页面点击角色操作栏中 “删除” 按钮。在删除确认窗口中点击 **确定&#x20;**。
![](https://resource.helplook.net/docker_production/3648ne/article/n5GtFTcM/6881a643b7e6d.png)

**多选角色删除**

勾选或全选待删除角色，点击 **批量删除&#x20;**&#x6309;钮。在弹出的二次确认窗口中点击 **确定**。
![](https://resource.helplook.net/docker_production/3648ne/article/n5GtFTcM/6881a66ac819b.png)

---
### 用户管理

**功能概述**

客户使用用户管理可以对管辖用户进行添加、编辑及删除，可设定用户的启/停用状态、为其重置密码，调整用户对应角色，并为其分配绑定设备。用户使用邮箱登录，邮箱号全网唯一，不允许重复。

**用户查询**

用户登录系统后点击 “**用户管理**” 进入用户管理页面，查询内容显示：序号、账号名称、邮箱、所属公司、所属角色、所属部门、联系电话、账号状态、创建时间和操作。输入**账号名称&#x20;**&#x6216;**&#x20;邮箱&#x20;**&#x6216;**&#x20;电话**、输入所属角色和所属公司后点击查询按钮。
![](https://resource.helplook.net/docker_production/3648ne/article/n5GtFTcM/6881a68b3ea08.png)

**用户添加**

用户在用户管理页面点击 “**添加用户**” 按钮。在弹出窗口中输入用户信息后点击 **确定&#x20;**。其中，账号名称是用户的姓名或自定义名称，邮箱及联系电话必须唯一，所属部门为自定义。
![](https://resource.helplook.net/docker_production/3648ne/article/n5GtFTcM/6881a6a17b357.png)

用户创建成功，显示初始密码弹窗。
![](https://resource.helplook.net/docker_production/3648ne/article/n5GtFTcM/6881a6d8b1c0a.png)

**用户编辑**

用户点击指定用户操作栏中的 **编辑&#x20;**&#x6309;钮。在弹出窗口中修改用户信息后点击 **确定 ，**&#x5176;中，用户邮箱和联系电话不可修改。
![](https://resource.helplook.net/docker_production/3648ne/article/n5GtFTcM/6881a6e54d792.png)

**设备绑定**

进入 “用户管理” 页面，点击指定用户操作栏中 “**设备权限**” 按钮。在弹出窗口中，通过输入设备名、设备所属产品，设备所属公司来筛选设备，勾选设备前多选框，点击 **确定&#x20;**&#x6309;钮，为指定用户分配设备。
![](https://resource.helplook.net/docker_production/3648ne/article/n5GtFTcM/6881a6f24e3aa.png)

**重置密码**

用户进入 “用户管理” 页面点击用户操作栏中 “重置密码” 按钮。
![](https://resource.helplook.net/docker_production/3648ne/article/n5GtFTcM/6881a700ab927.png)


在重置确认窗口中点击 **确定&#x20;**。
![](https://resource.helplook.net/docker_production/3648ne/article/n5GtFTcM/6881a70d56fb1.png)

用户密码重置，生成并以弹窗形式显示一个8位随机的临时密码。
![](https://resource.helplook.net/docker_production/3648ne/article/n5GtFTcM/6881a716a5794.png)

**用户删除**

**指定用户删除**

进入 “用户管理” 页面点击用户操作栏中更多下拉框，点击其中的 “**删除**” 按钮。
![](https://resource.helplook.net/docker_production/3648ne/article/n5GtFTcM/6881a72b82c65.png)

在删除确认窗口中点击 **确定&#x20;**。
![](https://resource.helplook.net/docker_production/3648ne/article/n5GtFTcM/6881a7351c7ee.png)

**多选用户删除**

勾选或全选待删除用户，点击 **批量删除&#x20;**&#x6309;钮。在弹出的二次确认窗口中点击 **确定**。
![](https://resource.helplook.net/docker_production/3648ne/article/n5GtFTcM/6881a742edf47.png)

**用户启停用**

用户进入 “用户管理” 页面点击用户账号状态栏中的 “**启停用**” 状态按钮。用户启用状态，按钮为蓝色；停用状态，按钮为灰色。在确认弹窗中点击 **确定&#x20;**&#x6309;钮。
![](https://resource.helplook.net/docker_production/3648ne/article/n5GtFTcM/6881a75131aff.png)
![](https://resource.helplook.net/docker_production/3648ne/article/n5GtFTcM/6881a75137339.png)

### 用户个人信息管理

**功能概述**

用户登录系统后，可通过点击右上角个人信息并选择修改密码来进行密码重置操作。系统会弹出修改密码窗口，用户需输入现有密码、新密码和确认密码，点击保存或回车完成操作。保存成功会提示修改成功并要求重新登陆。

 **密码重置**

用户登录系统后点击左上角个人信息选择修改密码。在弹出窗口中输入现有密码、新密码、确认密码后点击 **确定&#x20;**。
![](https://resource.helplook.net/docker_production/3648ne/article/n5GtFTcM/6881a76fca7d7.png)