使用配方可同时更改或读取控制器上一组特定变量（配方定义）的配方值。

您可以在对象***配方管理器***中定义配方的基本设置，例如位置和格式。在此对象下插入一个或多个配方定义。配方定义包含所包含变量的一个或多个配方。 配方由特定的变量值组成。

您可以将配方保存到文件或直接从文件写入PLC。

可以通过MetaFacture开发界面，可视化元素或应用程序来加载配方。

---

### 在MetaFacture用户界面中使用配方​

MetaFacture开发界面提供用于生成配方以及在线模式下进行读/写的命令。

---

### 在应用程序中使用配方​

当应用程序处于运行时模式时，可以在用户程序和可视化元素中使用配方。

在用户程序中，可以使用库RecipeManagement中功能块RecipeManCommands的方法。在可视化中，您可以通过输入配置（可视化元素的内部命令）使用配方。

在初始化过程中，配方管理读取配方定义中定义的变量的值。此操作在应用程序的初始化阶段结束时进行。此时，将设置应用程序变量的所有初始值。执行此操作以正确初始化配方文件中的缺失值。

---

### 创建配方 ​

1.在设备树中选择***应用程序***对象。

2.单击***工程 ➔ 添加对象 ➔ 配方管理器***。  
⇒MetaFacture将配方管理器添加到设备树中。

3.在设备树中选***择配方管理器***对象。

4.单击***工程 ➔ 添加对象 ➔ 配方管理器***。  
⇒MetaFacture将配方定义添加到配方管理器下方。

5.双击对象打开配方定义的编辑器。

6.双击***变量***变量下面的空白字段。指定将要定义配方的变量的名称。输入助手可用于此目的：![](https://resource.helplook.net/docker_production/3648ne/article/74hebHo2/67221c591620e.png)按钮。

7.单击***配方 ➔ 添加一个新的配方***然后输入新配方的名称。  
⇒编辑器中将显示具有新配方名称的列。

8.在此字段中输入此配方的变量值。

9.根据需要插入其他字段。

10.为配方选择一个变量值，然后单击***配方 ➔ 保存配方***。选择一个位置和文件名。  
⇒MetaFacture以配方管理器中定义的格式保存配方。

---

### 从文件加载配方​

要求：应用程序中提供了配方管理器。 在配方定义中，有一个带有变量值的***myRec***配方。 一个myRec.txt配方文件位于文件系统上，并包含该配方的条目。

配方文件示例：

PLC\_PRG.bVar:=0  
PLC\_PRG.iVar:=2  
PLC\_PRG.dwVar:=35232  
PLC\_PRG.stVar:='first'  
PLC\_PRG.wstVar:='123443245'  
   
  
1.双击设备树中的***配方定义***对象以打开表格编辑器，以定义各个配方。  
⇒您会看到myRec列以及此配方的当前值。

2.在外部文本编辑器中编辑myRec.txt文件，并用其他要加载到MetaFacture中的配方定义中的值替换变量值。保存文件。

3.单击配方定义中的***myRec***列并右键单击以获取加载配方***加载配方***命令。  
⇒当再次登录时，对话框提示会通知您可能需要执行在线更改。 通过加载配方来更改配方变量的当前值时，必须进行在线更改。

4.单击***是***关闭对话框并继续。从文件资源管理器中选择myRec.txt文件进行加载。  
⇒配方定义中的配方值将根据文件中读取的值进行更新。

---

### 控制器上的配方管理； 内存使用情况​

当清除***PLC中的配方管理时***选项时，配方管理器和配方定义将不使用PLC上的任何内存。

如果选中此复选框，则将为配方管理器和所有配方定义生成代码，并且此代码存储在PLC中。所用内存的大小主要取决于配方的数量及其变量，以及变量的数据类型。 配方定义的字段是否填写也有影响。无法计算配方的内存使用量。它必须在需要的时候通过实验来确定。 下表仅提供一些指导原则。

  
**带有MetaFacture Control Win V3控制器的MetaFacture V3 SP6的内存使用情况**

|  | 代码大小（字节） | 数据大小（字节） | 总计（字节） |
|---|---|---|---|
| 具有100个INT变量的配方定义 | 194406 | 79400 | 267352 |
| 具有200个INT变量的配方定义 | 238318 | 121284 | 459344 |
| 具有300个INT变量的配方定义 | 282230 | 163084 | 543856 |
| 带有100个BOOL变量的配方定义 | 192742 | 69884 | 343168 |
| 带有200个BOOL变量的配方定义 | 235446 | 101568 | 436872 |
| 带有300个BOOL变量的配方定义 | 278146 | 133284 | 510072 |
| 带有100个字符串变量的配方定义 | 203278 | 870084 | 1154000 |
| 带有100个字符串变量的配方定义 | 255570 | 1709784 | 2973296 |
| 带有100个字符串变量的配方定义 | 307886 | 2549484 | 2964112 |

---

### 从控制器加载配方值​

您可以将控制器上的配方值应用于项目中的配方定义，即使这些定义已在项目中进行了修改。

要求：在配方管理器中选择了***PLC中的配方管理***选项。

  
1.在项目中创建一个配方定义RecDef1，其中包含变量PLC\_PRG.ivar和PLC\_PRG.bvar。插入配方***R1***：PLC\_PRG.ivar的值：33：对PLC\_PRG.bvar的值：TRUE。

2.登录到控制器并下载应用程序。  
⇒配方文件R1.RecDef1.txtrecipe保存到控制器的默认目录($PlcLogic$)。

3.注销然后将另一个变量PLC\_PRG.dwvar添加到工程中的配方定义中。

4.通过将PLC\_PRG.ivar的值从33改为34，在设备上编辑配方定义文件R1.RecDef1.txtrecipe。  
此外，在设备上添加另一个配方***R2***。为此，请复制R1.RecDef1.txtrecipe并将其重命名为R2.RecDef1.txtrecipe。然后编辑此文件并更改配方值：PLC\_PRG.ivar: 1, PLC\_PRG.bvar: FALSE。  
⇒现在设备上有两个配方***R1***和***R2***。在这个工程中，只有y ***R1***，并且它还包含设备上除R1之外的其他值。

5.通过在线更改再次登录到控制器。

6.从上下文菜单中单击***从设备上传配方***。  
⇒对话框提示通知您，下次登录时执行该命令可能会触发在线更改，并且运行系统上的配方将覆盖当前配方定义的配方。

7.确认您希望继续。⇒对话框提示通知您，设备上加载的PLC\_PRG.dwvar的配方无法从控制器产生值。

8.确认您希望继续。⇒工程中配方定义的配方***R1***中的PLC\_PRG.ivar的值更改为34。现在，配方定义中还列出了值为1和FALSE的配方***R2***。PLC\_PRG.dwvar仍保留在配方定义中。