当应用程序在控制器上运行时，变量的实际值将显示在POU的编辑器中。这就是监视变量值的方式。

  
要求：在***工具 ➔ 选项***中***文本编辑器***类别中的***监视***选项卡上激活了***启用内联监视***选项。

1.将应用程序下载到控制器并启动。

2.单击***调试 ➔ 显示模式 ➔ 十进制***。⇒设置实际值的显示格式。

3.在***设备***视图或***POUs***视图中单击一个编程对象。⇒相应的编辑器打开。对于声明和执行，变量的实际值将不断刷新。

---

### 在声明编辑器中进行监视​

![](https://resource.helplook.net/docker_production/3648ne/article/dD1dImgV/6722187b15f82.png)

表达式（1）的实际值显示在***值***列（3）中。

您可以在***准备值***（4）列中写入并强制使用值。在强制期间，实际值用红色符号(![](https://resource.helplook.net/docker_production/3648ne/article/dD1dImgV/672218b55d26c.png))标识。

接口引用的表达式可以扩展。如果接口指向全局实例，则该全局实例将显示为引用下方的第一个条目。此后，如果接口引用发生更改，则显示的引用将折叠。

---

### 执行中的监视（内联监视）

内联监视是执行中当前变量值的显示。

根据实现语言的不同，在执行部分中可能会显示以下内容：

- 变量有一个窗口，其名称后显示当前值： ![](https://resource.helplook.net/docker_production/3648ne/article/dD1dImgV/672218ea23aaf.png)  
    如果已为强制变量或写入变量准备了值，则它们将在当前值之后的在线监视视图中的尖括号中显示。  
    强制后，通过![](https://resource.helplook.net/docker_production/3648ne/article/dD1dImgV/672218f3d3ca7.png)标识相应的值。
- 网络编辑器和CFC编辑器：  
    连接线根据其实际布尔值以彩色显示（蓝色表示TRUE, 黑色表示 FALSE）。
- LD编辑器：  
    触点和线圈元件也被标记。  
    对于触点和线圈，在元素旁边的小视图中显示准备值 (TRUE或FALSE)。
- SFC编辑器：  
    值为TRUE的转换将根据其实际布尔值以彩色显示(蓝色表示TRUE，黑色表示FALSE)。  
    激活步骤显示为蓝色。  
    强制转换值在执行中显示为红色。
- 指令表编辑器：  
    当前值显示在单独的列中。

> **在结构化文本编辑器中进行监视**
> 
> ![](https://resource.helplook.net/docker_production/3648ne/article/dD1dImgV/6722193f1e0cd.png)

> **在梯形图编辑器中进行监视**
> 
> **![](https://resource.helplook.net/docker_production/3648ne/article/dD1dImgV/672219658844d.png)**

> **在顺序功能图编辑器中进行监视**
> 
> **![](https://resource.helplook.net/docker_production/3648ne/article/dD1dImgV/672219848c2e6.png)**

---

### 数组的部分监视

展开的数组显示最多1000个元素的实际值。但是，这可能会造成混淆。此外，一个数组可以包含1000个以上的元素。这样有助于限制显示元素的范围。您可以通过以下方式在在线模式下执行此操作。

**限制监视范围**

要求：应用程序正在运行。 它包含具有1000个以上元素的多维数组变量。例如：arrBig : ARRAY \[0..100, -9..10, -19..20\] OF INT;

1.单击arrBig变量的***数据类型***列字段。⇒***监视范围***对话框打开。

2.将***开始***指定为\[1, -9, -19\]。

3.将***结束***指定为\[1, 10, 20\]。⇒800个数组元素的实际值显示在声明编辑器中。该范围限于索引\[1, *, \]的元素，其中i从-9到10，j从-19到20。*

---

### 监视功能块

在在线模式下双击功能块的编辑器视图时，将打开一个对话框，您可以在其中选择查看基本实现或特定实例。

如果选择基本实现，则代码将显示在编辑器中而不显示当前值。 现在在基本实现中设置一个断点。 如果执行在此停止，则将显示首先在程序流中处理的实例的当前值。现在，您可以逐步浏览所有实例。

如果选择其中一个实例，则编辑器将打开，其中包含功能块实例的代码。当前值显示在声明中，如果适用，还显示在执行中，并不断更新。

---

### 监视一个属性​

您可以通过在在线模式下在函数中设置断点来监视属性对象![](https://resource.helplook.net/docker_production/3648ne/article/dD1dImgV/67221a1934bf1.png)中的变量。在那里暂停时，将显示当前值。

除了您自己的值之外，还会自动显示上级实例变量的值。 在属性的声明部分，指向上一级实例的THIS指针出现在第一行，其中包含当前数据类型信息和值。

> 例如
> 
> .代码
> 
>   
> FUNCTION\_BLOCK FB\_BaseAlfa  
> VAR  
>  iBaseLocal : INT;  
>  sBaseLocal :  
> STRING;  
> END\_VAR  
> iBaseLocal := iBaseLocal + 1;  
> sBaseLocal := 'Testing Text';
> 
> FB\_BaseAlfa.PorpBeta.Get  
> iBaseLocal := iBaseLocal + 1;  
> IF iBaseLocal &gt; 0 THEN  
>  PropBeta := TRUE;  
> END\_IF
> 
> FB\_BaseAlfa.PorpBeta.Set  
> IF PropBeta = TRUE THEN  
>  iBaseLocal := 0;  
>  sBaseLocal := 'Tested IF';  
> END\_IF
> 
>   
> PROGRAM PLC\_PRG  
> VAR  
>  fb\_BaseAlfa : FB\_BaseAlfa;  
> END\_VAR
> 
> fb\_BaseAlfa();
> 
> IF fb\_BaseAlfa.PropBeta = TRUE THEN  
>  xResult := TRUE;  
> END\_IF  
> IF xReset THEN  
>  fb\_BaseAlfa.PropBeta := TRUE;  
>  xReset := FALSE;  
> END\_IF
> 
>  ![](https://resource.helplook.net/docker_production/3648ne/article/dD1dImgV/67221a3ea30ab.png)

---

### 监视上级编程对象中的属性访问​

除了变量值之外，还可以监视功能块或程序中从属属性 的值。

为此，请将{attribute 'monitoring' = 'variable'}或{attribute 'monitoring' = 'call'}添加到声明中的从属属性对象。 如果在运行时打开上级程序实例或功能块实例，则除当前变量值外，当前属性值还将显示在编辑器中。

---

### 监视方法​

您可以通过在在线模式下在方法中设置断点来监视方法对象![](https://resource.helplook.net/docker_production/3648ne/article/dD1dImgV/67221a781057e.png)中的变量。在那里暂停时，将显示当前值。

除了您自己的值之外，还会自动显示上级实例变量的值。在方法的声明部分，指向上一级实例的THIS指针出现在第一行，其中包含当前数据类型信息和值。

> 例如
> 
> .代码
> 
>   
> FUNCTION\_BLOCK FB\_BaseAlfa  
> VAR  
>  iBaseLocal : INT;  
>  sBaseLocal : STRING;  
> END\_VAR  
> iBaseLocal := iBaseLocal + 1;  
> sBaseLocal := 'Testing Text';
> 
> METHOD MethBaseAlfa : BOOL // Method of FB\_BaseAlfa  
> VAR\_INPUT  
> END\_VAR  
> VAR  
>  iMethLocal : INT;   
> END\_VAR  
> iMethLocal := iMethLocal + 1;
> 
>   
> PROGRAM PLC\_PRG  
> VAR  
>  fb\_BaseAlfa : FB\_BaseAlfa;  
> END\_VAR  
> fb\_BaseAlfa();  
> fb\_BaseAlfa.MethBaseAlfa();
> 
> ![](https://resource.helplook.net/docker_production/3648ne/article/dD1dImgV/67221a9347e5b.png)

---

### 监视一个函数​

您可以通过在在线模式下在函数中设置断点来监视函数对象中的变量。在那里暂停时，将显示当前值。

---

### 监视函数调用的返回值

在POU的ST编辑器中，当前返回值在调用函数的POU位置显示为内联监视。

必须满足以下条件：

- 该值可以解释为4字节的数值。 例如：INT，SINT，或 LINT。
- 语句{attribute 'monitoring' := 'call'}被插入到函数中。