在运行时，应用程序或设备的状态可能变得敏感，破坏性行为可能危害整个机器或设备。但是，在这种状态下，您可以禁止某些命令并防止危险的操作。为此提供了PlcOperationControl功能块和组件管理器库。

可以在执行时禁止操作的MetaFacture命令示例：

- ***在线修改, 下载***
- ***使能断点***
- ***重置应用程序，停止应用程序***
- ***传输数据***
- ***强制值，写值***

为了始终使用备份解决方案，不允许您取消***初始复位***和***删除***命令。

当应用程序处于运行时模式时，MetaFacture将通知您是否需要当前禁用的运行时系统服务。然后，您可以采取适当的对策进行回应。

---

### 功能块PlcOperationControl用于操作控制​

该功能块用于启用和禁用操作。

属性 (PROPERTY)

| 名称 | 数据类型 | 初始值 | 描述 |
|---|---|---|---|
| xDisableApplicationOnlineChange | BOOL | FALSE | TRUE: 禁止在线修改 |
| xDisableApplicationDownload | BOOL | FALSE | TRUE: 下载是被禁止的 |
| xDisableApplicationStop | BOOL | FALSE | TRUE: 禁止停止应用程序 |
| xDisableApplicationBP | BOOL | FALSE | TRUE: 禁止设置断点 |
| xDisableApplicationWrite | BOOL | FALSE | TRUE: 禁止写入变量  也可以通过PLCHandler / IecVarAccess禁止它。 |
| xDisableApplicationForce | BOOL | FALSE | TRUE: 禁止强制变量 |
| xDisableApplicationReset | BOOL | FALSE | TRUE: 禁止重置应用程序（不是“重置原点”）。 |
| xDisableAll | BOOL | FALSE | TRUE: 禁止所有操作 |

---

### 实现操作控制​

要求

- 编译器版本&gt;= 3.4.3.0
- 在设备描述中，PLC操作控制由系统变量启用。

1.声明PlcOperationControl功能块的实例（例如，PlcOpCtrl\_Inst）。  
⇒PlcOpCtrl\_Inst : PlcOperationControl;

2.通过分配相应的TRUE属性来抑制命令（例如，“停止应用程序”）。  
⇒PlcOpCtrl\_Inst.xDIsableApplicationStop := TRUE;