为了对远程设备及其运行的应用程序具有读/写访问权限，可以将数据源管理器添加到具有一个或多个数据源的应用程序中。

数据源管理器的功能允许建立与远程设备的连接和通信，并通过数据源变量使其数据可用。此时，合作伙伴通过点对点连接进行通信。根据控制器所在的网络，通过不同的数据源类型和不同的连接类型建立连接。

在开发阶段，您可以通过本地符号配置文件离线创建变量列表。这样，您可以基于符号信息脱机开发本地应用程序，而无需连接到数据源。

**数据源管理器​**  
远程设备与本地设备之间的通信通过数据源类型进行通信。MetaFacture提供以下两种类型。

**MetaFacture Symbolic:**

通过符号监视访问数据。读取远程设备上的符号文件，并将存储的变量信息用于数据源变量和数据传输。优点是，当有人编辑修改了远程应用程序而不更新其符号配置时，不必在本地设备中更新应用程序。如果符号文件也位于开发环境上（文件或符号配置对象作为项目的一部分），那么也可以读取本地符号文件。然后，您可以在开发阶段脱机工作。

注意：通常，您将使用MetaFacture Symbolic。仅当没有资源可用于远程PLC中的符号配置时，才可使用MetaFacture Symbolic。

**MetaFacture ApplicationV3:**

通过地址监视访问数据。这要求远程PLC和本地设备之间的地址信息匹配。弊端：为了更改远程应用程序，将更新本地应用程序（例如HMI应用程序）。优势是在远程应用程序中不需要符号配置。

注意：如果没有可用的资源进行符号配置，则可将此通信用于嵌入式或小型PLC。

### 连接类型​

数据源管理器的功能允许建立从本地设备到一个或多个远程设备的点对点连接（甚至通过网络）。选择适当的连接类型。

当通信基于符号数据源类型**MetaFacture Symbolic**时，可以使用以下连接类型：

- ***MetaFacture V2：***  
    这些设备位于同一网络中。远程PLC上的 V2 runtime 提供了一个通讯接口。
- ***MetaFacture V2 (Via gateway)***  
    这些设备不位于同一网络。它们通过V2网关连接。  
    注意：此连接必须在运行MetaFactureV3的开发计算机上安装MetaFacture V2.3网关服务器（V2网关）。
- ***MetaFacture V3:***  
    这些设备位于同一网络中。V3 runtime在远程PLC上提供一个通讯接口。
- ***MetaFacture V3 (Via gateway):***  
    这些设备不位于同一网络。它们通过V3网关连接。

当通讯基于 MetaFacture ApplicationV3 数据源类型时，本地应用程序的 runtime 需要有效的通讯参数以建立连接。配置数据源时，网络扫描功能可以为您提供支持。

---

### 数据传输​

当本地应用程序处于运行时模式时，***变量***选项卡的数据源编辑器中显示的数据源变量将以可配置的时间间隔进行更新。此时也将执行远程应用程序。在可视化，趋势，警报或配方中组态的变量将自动传输和存储。当仅以IEC代码访问变量时，该变量不会自动更新。在这种情况下，必须激活***变量***选项卡的数据源编辑器中的***始终更新***选项。

对于以下数据类型，通信类型支持对源PLC变量的（读或写）数据访问：

- 最高级别的标量值  
    例: PLC\_PRG.hugo
- 当程序或GVL被标记为{attribute monitoring：=，call’}时，通过调用来赋予其属性。  
    例: PLC\_PRG.PropertyCall
- 映射到位地址的变量。  
    PLC\_PRG的例子: X AT %MX0.5: BOOL
- 功能块中的变量（BIT类型）  
    例: 在DUT中声明：x, y : BIT，访问：PLC\_PRG.dutInst.y
- 结构化可获得变量  
    例: PLC\_PRG.outerInst.innerInst.dwVar
- 标有{attribute monitoring：=，call’}的POU实例属性。  
    例: PLC\_PRG.instance.PropertyCall
- 最高级别的属性，并带有{属性监视：=“变量”}的实例。  
    注意：这不能通过监视或数据源来编写。
- 具有文字索引的数组访问  
    例: PLC\_PRG.arrOfInts\[3\], PLC\_PRG.inst.arrOfBool\[1\]
- 嵌套访问（例如，结构数组或数组结构）