要在发送方设备和接收方设备之间交换网络变量，必须执行以下步骤。

---

### 在发送方设备中创建网络变量列表并生成导出文件​

要求：将应用程序插入已用作发送方设备的PLC的设备树中。

  
1.选择应用程序，然后插入***网络变量列表（发送端）***对象。在添加***网络变量列表（发送端）***对话框中进行以下设置：网络类型：UDP,例：![](https://resource.helplook.net/docker_production/3648ne/article/ofEnWTaa/6721e750b14d5.png) "NVL\_Sender"。

2.双击NVL对象以打开相应的编辑器，然后键入网络变量的声明。例:  
VAR\_GLOBAL  
iglobvar:INT;  
bglobvar:BOOL;  
strglobvar:STRING;  
END\_VAR

3.右击设备树中的NVL对象以打开***属性***。在***属性***对话框中打开***网络变量***选项卡。显示以下设置：网络类型：UDP; 清单识别码：1; 打包变量； 循环传输：每50毫秒一次。

4.注意：您还可以通过配置现有GVL的网络变量属性，将其转换为网络变量列表。

5.单***击NVL\_Sender***的***属性***对话框中的***链接到文件***选项卡。为GVL的导出文件定义文件名.gvl和在文件系统中的位置。选择***编译前导入***复选框。

6.单击***编译 ➔ 编译***编译应用程序。

---

### 在接收端设备中创建关联的网络变量列表​

要求：设备树中存在发送端设备和接收端设备。具有任务配置的应用程序将插入设备下方。在发送端设备下方创建一个NVL或GVL作为要发送的网络变量列表。

  
1.在设备树中选择接收端的应用程序，然后单击***添加对象 ➔ 网络变量列表（接收器）***。  
⇒将打开***添加全局网络变量列表（接收者）***对话框。

2.在对话框中，选择先前创建的发送方设备的NVL，然后键入一个名称（例如![](https://resource.helplook.net/docker_production/3648ne/article/ofEnWTaa/6721e7f5d5a5f.png)“ NVL\_Receiver”）。MetaFacture自动使用发件人列表中的变量声明填充此收件人列表。  
注意：或者，您可以选择从***文件导入***选项，并加载先前从发件人列表生成的导出文件。

---

### 测试网络变量数据交换​

要求：发送方设备中存在网络变量列表（发送端），接收方设备中存在网络变量列表（接收者），并且两个列表具有相同的变量声明。

  
1.在发送方设备中的应用程序下方，创建一个程序以递增网络变量。例: iglobvar:=iglobvar+1;。

2.配置应用程序任务，以便该程序调用它。

3.在接收端设备中的应用程序下面，创建一个程序，将该网络变量的值写入本地变量。例: ilocalvar:=iglobvar;。

4.配置应用程序任务，以便该程序调用它。

5.将两个应用程序都下载到控制器并启动它们。（将应用程序设置为活动，登录，下载和启动。）

6.在两个程序的编辑器的联机视图中，检查iglobvar的值在接收方和发送方中是否匹配。

---

### 在V2.3和V3 PLC之间组态网络变量通讯​

要求：V2.3项目中存在一个全局变量列表，其中包含要读取到V3项目中的网络变量。在PLC下的设备树中的V3项目中，有一个带有使用变量的程序的应用程序。

  
1.在V2.3项目（发送端）中打开GVL的***属性***对话框。

2.将另一个PLC作为带有应用程序和任务的虚拟对象插入项目中。然后，在其下面创建V2.3 GVL，如下所示：

3.在虚拟应用程序下方插入一个名为“dummy23”的***网络变量列表（发送端）***对象。

4.右键单击***dummy23***以打开***属性***对话框。单击***网络变量选***项卡。在V2.3项目中键入与GVL相同的网络属性。

5.用与V2.3 GVL中相同的变量声明填充***dummy23***。

6.在***dummy23***的***属性***的***链接到文件***选项卡中，定义导出文件“ dummy23.gvl”的位置。

7.将虚拟PLC的应用程序设置为活动状态，然后按***\[ F11 \]*** 进行MetaFacture编译。 创建导出文件。

8.将物理PLC的应用程序设置为活动状态，然后单击鼠标右键以打开***添加对象***对话框。

9.选择***网络变量列表（接收端）***，然后键入一个名称（例如“ NVL\_from\_23”）。

10.选中***从文件导入***复选框，然后选择先前生成的dummy23.gvl。

11.检查刚刚创建的***NVL\_from\_23***。您必须在V2.3项目中收到与发送端GVL中相同的变量声明。