### 网络地址​​

网络地址表示网络类型（例如IP）的地址到控制网络内逻辑地址的映射。该映射由相应的块驱动器执行。IP地址的前三个字节对于以太网网络中具有“ C类” IP地址的所有网络设备都是相同的。因此，IP地址的最后8位足以用作网络地址，因为它们可以在块驱动器上的两个地址之间实现明确的映射。

一个节点的每个网络连接都有一个不同的网络地址。不同的网络连接可以具有相同的网络地址，因为每个地址仅在本地是唯一的。

术语：主网络中的网络地址通常被指定为没有网络连接规格的节点的网络地址。

网络地址的长度以位为单位指定，可以由块驱动程序根据需要选择。网络区域内的所有节点必须使用相同的长度。根据以下编码，网络地址由字节数组表示：

- 网络地址长度：n bits
- 必要的字节数：b =（n + 7）DIV 8
- 第一个字节的最低位的（n MOD 8）位以及所有其他位（n DIV 8）用于网络地址。

> 网络地址编码示例
> 
> 长度：11bit
> 
> 地址：111 1000 1100
> 
> ![](https://resource.helplook.net/docker_production/3648ne/article/1itFOPyp/6721e3a986392.png)

---

### 节点地址​

节点地址表示控制网络中节点的绝对地址，因此在整个“网络树”中是唯一的。该地址最多由15个地址组成，每个组成2个字节。节点在网络层次结构中的位置越低，其地址越长。

完整的节点地址由所有先前节点的部分地址和节点本身的部分地址组成。每个部分地址由一个或多个地址组成。因此，长度始终是2个字节的倍数。在父节点的情况下，节点的部分地址由其主网络中该节点的网络地址和主网络的子网索引组成。子索引所需的位由父节点的路由器确定。可以在子网索引和网络地址之间插入填充位，以确保部分地址的长度是2个字节的倍数。

特别案例：

- 没有主网络的节点：这意味着主网络中既没有子网索引也没有网络地址。在这种情况下，地址设置为0x0000。
- 主网络中没有父节点的节点：在这种情况下，假设子网索引的长度为0。该部分地址对应于网络地址，如果需要，可以用填充位扩展

> 节点地址举例
> 
> ![](https://resource.helplook.net/docker_production/3648ne/article/1itFOPyp/6721e3dd20ef4.png)

节点地址始终以十六进制指定。各个地址部分（每种情况下为两个字节）用冒号“：”分隔。由于这表示字节数组，而不是16位值，因此不会以Intel格式显示组件。对于手动输入的地址，地址部分中缺少的部分由前导零补足：“274” = “0274”。为了提高清晰度，显示屏还应始终包含前导零。

**绝对和相对地址**

两个节点之间的通信可以基于相对或绝对地址。绝对地址与节点地址相同。相对地址指定了从发送者到接收者的路径。它们由地址偏移量和到接收器的下降路径组成。

（负）地址偏移量描述了地址组件的数量，在此之前，数据包必须在树中向上传递，然后才能由公共父节点向下传递。由于节点可以使用由多个组件组成的部分地址，因此要传递的父组件的数量始终等于地址偏移量。这意味着父节点之间的分界不再清晰。因此，将通信伙伴地址的公共开头用作父地址。独立于当前父节点，每个地址组成部分都计为一个向上的步骤。由该假设导致的每个错误都可以由相应的父节点检测到，并且必须相应地对其进行处理。

在获得公共父节点后，相对路径（作为地址组件的数组）将照常向下遵循。正式的：接收者的节点地址是通过从发送者的节点地址中删除最后一个地址偏移分量并将相对路径附加到剩余地址而形成的。

> 节点地址形成示例
> 
> 在下面的示例中，每个地址组成部分均由字母表示； 在每种情况下，点都将节点彼此分开。由于节点可以承载多个地址组件，因此示例中的某些组件用几个字母表示。
> 
> 节点A：a.bc.d.ef.g
> 
> 节点B：a.bc.i.j.kl.m
> 
> - 最低共同父母的地址：a.bc
> - A到B的相对地址-4/i.j.kl.m（数字4由d，e，f和g这4个分量产生，它们必须沿向上的方向传递到数据包上）  
>     为了保证路由的正确操作，每次通过中间节点时，都必须修改相对地址。调整地址偏移量就足够了。这总是由父节点
> 
> 完成：如果节点从其子网之一接收到数据包，则地址偏移量将增加此子网的地址部分的长度。
> 
> - 如果新地址偏移量为
> - 如果地址偏移量&gt; = 0，则必须将数据包从地址偏移量传递到其本地地址对应于相对路径的子节点。但是，首先，必须将地址偏移量增加子节点本地地址的长度，以便子节点看到正确的地址。
> 
> 如果在确定公共父节点期间发生上述错误，则会导致特殊情况。在这种情况下，实际父节点的地址偏移为负，但该值大于数据包所源自子网部分地址的长度。为了使下一个节点在这种情况下看到正确的相对地址，有关的节点必须执行以下操作：它必须发现错误，并根据前一节点的地址和长度差来计算子节点的本地地址。 并相应地调整地址偏移量。在这种情况下，地址组件本身也保持不变，仅偏移量被更改。

---

### 广播地址​

广播有两种类型-全局和本地。全局广播将发送到网络中的所有节点。为此保留长度为0的空节点地址。

本地广播将发送到网络区域中的所有设备。为此，将网络地址的所有位设置为1。相对地址和绝对地址都允许这样做。

块驱动程序必须能够处理两种广播地址。这意味着：空的网络地址以及位都设置为1的网络地址必须被解释并发送给所有相关设备。