### 循环​

与C和ST相对，Python中的for循环不计算循环变量，而是在序列上进行迭代。这种序列可以是字典，列表，元组，字符串中的字符或文件中的行。

以下示例显示了一些for循环：以下示例显示了典型循环:

> **例如： loops.py**
> 
> from \_\_future\_\_ import print\_function
> 
> print("Enumerating over a simple list:")  
> for i in (1,2,3,4):   
>  print(i, end=", ") # end =将换行符替换为“，”  
> print() # 但是在本案例的结尾，我们仍然需要换行符。
> 
> print("Enumerating over the characters in a string:")  
> for i in "MetaFacture": # 字符表示为长度为1的字符串。  
>  print(i, end=", ")  
> print()
> 
> print("Enumerating over the integers 1 to 4:")  
> for i in range(1, 5): # 上界是唯一的。  
>  print(i, end=", ")  
> print()
> 
> print("Enumerating using xrange:")  
> for i in xrange(5): # xrange与range相似，但是大范围需要较少的内存。  
>  print(i, end=", ")  
> print()
> 
> print("Enumerating including the item number:")  
> for i, v in enumerate("MetaFacture"):   
>  print(i, v)  
>    
> 输出结果:
> 
> ![](https://resource.helplook.net/docker_production/3648ne/article/HxXBsZMP/6728999b77464.png)

如果除工程外还需要索引或数字，则应使用示例脚本的最后一种情况中所示的enumerate。以下代码被认为是较差的样式：

> **例如：Poor style**
> 
> text = "MetaFacture"
> 
> for i in range(len(text)): # BAD STYLE!   
>  v = text\[i\] # DON'T TRY THIS AT HOME!   
>  print(i, v)

除了for循环，Python还具有while循环，这与C和ST中的非常相似：

> **例如："while”循环**
> 
> i = 0  
> while i print(i)  
>  i += 1  
>    
> 注意：这个例子不是很实际。你更有可能使用带范围的for循环。

---

### IF / ELSE​

if/else构造类似于其他编程语言中的构造。这有一个简短的例子：

> **例如："if\_else.py"**
> 
> from \_\_future\_\_ import print\_function  
> i = int(system.ui.query\_string("Please enter an integral number..."))  
> if i print("Your number was negative.")  
> elif i &gt; 0:   
>  print("Your number was positive.")  
> else:   
>  print("It seems your number was zero.")

else分支是可选的，可以有零个，一个或多个elif分支。

---

### 函数，类和方法​

Python允许使用方法定义函数和类。具有方法的类基本上类似于ST中的功能块，或者类似于C ++，Java或C＃等语言的类。但是，Python不支持接口。

有关详细信息，请参阅Python文档以定义函数和类。

> **例如：函数，类和方法**
> 
> \#用名称sum和两个参数a和b定义一个函数：  
> def sum(a, b):   
>  return a + b # we return the sum of a and b.
> 
> \# 我们现在可以调用上面定义的函数：  
> print(sum(5,7))
> 
> \# 现在我们定义一个Foo类：  
> class Foo:   
>  # 该类获取方法“ bar”。  
>  # 注意：对于方法，第一个参数始终是“ self”，  
>  # 指向当前实例。这类似于# ST和其他的语言中的“ this”  
>    
>  def bar(self, a, b):   
>  print("bar(%s,%s)" % (a,b))
> 
> \# 我们创建该类的一个实例：  
> f = Foo()
> 
> 我们在实例上调用方法栏。  
> f.bar("some", "params"）

---

### 模块和标准库​

在IEC中，你可以导入库以供其他书面代码重复使用。作为插件，Python中有可能导入模块。

Python标准库包含许多用于不同目的的模块，例如：

- 字符串处理
- 日期和时间处理
- 搜集
- 通行
- 数学函数
- 文件处理
- 保持
- 压缩和归档
- 数据库访问
- 加密服务
- 网络及Internet访问
- 发送邮件

要创建自己的模块，请编写一个Python文件，该文件定义要提供的功能和类。将此文件保存到与示例脚本相同的目录中。如果将文件命名为mymodule.py，则可以使用import mymodule将其导入。

这是从math模块导入和使用余弦函数和pi常量的示例：

> **例如：导入数学函数**
> 
> from math import cos, pi
> 
> print(pi) # prints 3.14159265359
> 
> print(cos(pi)) # prints -1.0

以下包含更多示例，这些示例访问有关操作系统，Python版本和解释器的信息：

> **很重要的例子**
> 
> import os  
> print(os.environ\["OS"\])
> 
> from sys import platform, version, executable  
> print(platform)  
> print(version)  
> print(executable)
> 
>   
> ![](https://resource.helplook.net/docker_production/3648ne/article/HxXBsZMP/67289b3dbcad1.png)

有一个特殊的模块\_\_future\_\_用于激活新的语言功能。最重要的是，它在Python开发人员引入向后兼容的新功能时使用。这些功能必须通过特殊的“\_\_future\_\_导入”来激活。我们在此处的大多数示例脚本中使用的一个示例是激活print的新功能语法作为函数而不是语句。

> **例如："\_\_future\_\_"**
> 
> \# 使print（）成为函数而不是语句  
> 从\_\_future\_\_导入print\_function

Python文档提供了所有\_\_future\_\_导入的完整列表。

除了普通的Python模块之外，IronPython代码还可以像使用Python模块一样访问.NET程序集。这将打开对.NET Framework类库和第三方库的访问。这是一个示例，如何通过库Windows Forms打开对话框：

> **例如：Opening a .NET dialog box**
> 
> import clr  
> clr.AddReference("System.Windows.Forms")  
> from System.Windows.Forms import MessageBox
> 
> MessageBox.Show("Hello")