使用“ DeviceApplication”可以将全局所需的数据与纯控制器程序分开。

设备的所有控制应用程序使用的全局数据都在一个单独的***设备应用程序***对象中进行管理。它们将与此对象一起完全编译，并在调试时下载到控制器。***设备应用程序***不包括用户开发的任何控制器程序。因此，该设备的独占控制应用程序较小，下载所需的时间更少。这是因为不必在每次下载或在线更改中都包含全局数据。但是，与仅使用单个应用程序一样，加载全局数据需要更多的内存和下载时间。这是因为所有引用的数据和整个代码都随设备应用程序一起下载到控制器，因为尚不清楚以后将要使用和将不会使用什么。

因此，在以下情况下，使用设备应用程序而不是单个应用程序更有意义

- 使用中的设备有足够的内存（例如没有嵌入式系统），
- 是否应将控制任务分配给多个应用程序以改善逻辑映射。

设备树中的组织结构：

- 根据设备的不同，您可以在设备的 ***PLC Logic***节点下方的设备树中插入***设备应用程序***对象。通过使用不同类型的子对象，这可以管理设备的所有独占控制应用程序所使用的全局数据和代码段。例如：库管理器，GVL，网络变量列表。将设备应用程序插入设备树后，***PLC逻辑***节点将隐藏。
- 专有的控制器程序代码包含在一个或多个“常规”应用程序对象中，这些对象在与 ***设备应用***并行的设备树中显示。但是，在层次结构中，它们位于***设备应用程序***之下，并且可以访问设备应用程序的全局数据和变量。他们彼此之间没有相互访问权，也不能拥有任何子应用程序。但是，可以通过设备应用程序的全局数据进行数据交换。

控制和行为：

- 设备应用程序无法进行在线更改。因此，对设备应用程序的更改导致设备应用程序和子应用程序的重新下载（在同一级别的设备树中）。
- 下载或重置（热或冷）之后，设备应用程序将处于“停止”状态。您可以通过相应的上下文菜单命令分别或集体登录，退出，启动，停止和重置设备应用程序的所有应用程序。
- 首次登录和下载应用程序时，设备应用程序也会自动下载。
- 调试设备时，可以使用在线配置模式来测试I/O。调试完成后，您必须为应用程序和设备应用程序执行新下载。
- 如果从设备删除设备应用程序，则其子应用程序也会从设备中删除。
- 当为设备的应用程序生成启动应用程序时，也会为设备应用程序自动生成启动应用程序。
- 默认情况下，每个应用程序都具有设备应用程序以及所有其他应用程序在异常情况下停止的属性。
- 有关任务配置的注意事项：

无法在设备应用程序的任务配置中调用POU。总线主站在现场使用此任务配置，以便在执行程序时达到总线循环任务的计时的近似值。根据设备的不同，有两种可能性：

- - 您可以在应用程序的任务配置中定义“外部”类型的任务。作为触发任务的外部事件，您可以指定隐式提供的总线主事件的调用。这允许与总线主控器达成异步时序补偿。
    - 您可以在应用程序的任务配置中定义“父任务”类型的任务。对于父任务，请从设备应用程序提供的任务中选择总线主站的循环任务。这允许与总线主设备达成同步时序补偿。  
        请注意以下限制：是否执行同步调用仅取决于设备应用程序的状态。如果正在运行并且子应用程序未在运行，则无论如何都将调用该代码。
- 关保持变量列表的注释：  
    如果设备支持用于保持变量和保持变量的静态内存区域，则可以使用***保持变量配置***对象将内存也映射到全局数据和特定于应用程序的剩余数据。这很有意义，因此在修改保持变量列表后，您不必将设备应用程序和所有应用程序再次下载到控制器。默认情况下，对于具有静态内存管理的设备，整个内存在设备应用程序中保留，以保留剩余数据。但是，在应用程序中创建保持变量列表后，还必须在其中为其提供一个存储区。即使是一个空列表，也至少需要几个字节的内存。对于没有静态内存分配的设备，将自动为每个应用程序的保持数据分配一个单独的内存段。
- 符号配置注意事项：  
    
    - 不支持将***符号配置***作为***设备应用程序***的子应用程序使用。
    - 您还可以在设备应用程序的库管理器中将引用应用于应用程序的符号配置库。这样做的好处是不必随应用程序一起下载库，因此应用程序“较小”。添加***符号配置***对象时，请参见***在设备应用程序中在设备应用程序中添加库占位符***，或在符号配置编辑器的工具菜单中查看相同名称的命令。