### 有关写保护和访问保护的一般信息​

您可以通过访问保护和写保护的方式来防止无意的更改。您还可以为它提供读保护(知识产权保护)。

写保护

以下选项可以为整个工程提供简单的写保护:

打开工程时，选择***Open Read-Only***选项。  
在***工程信息***中设置***发布***状态。  
在本地文件系统中的工程文件属性中选择“只读”选项。

为了只保护工程中的某些对象不受更改的影响，或者只允许对某些用户进行访问，您可以使用用户和访问权限管理(见下面)。一些目标设备同样支持用户和权限管理。这样就可以限制MetaFacture对目标设备的对象和文件的访问。

但是，写保护和访问保护并不作为POUs专门的知识的保护。MetaFacture本身，自动化平台插件和了解项目文件格式的人员都可以查看或修改用MetaFacture创建的功能块。

知识保护:

工程的知识保护是通过对项目文件进行加密来实现的。要么使用项目密码,MetaFacture安全密钥(加密狗)，要么使用证书。我们建议使用密钥或证书进行保护，因为在这种情况下，授权用户之间不需要共享任何秘密。在工程设置中启用所需的工程加密类型。

通过将库作为与目标系统无关的“受保护的库”(\*.compiled-library, \*.compiled-library-v3)提供，可以实现对库的知识保护。库文件不再包含这种格式的源代码，而是只加密预编译上下文。编译器仍然能够解释这些数据.是否可以由其他MetaFacture组件或其他插件访问取决于它们的功能，并将在个别情况下进行观察。签名更能增加保护。

启动应用程序的知识保护和副本保护可以通过runtime系统加密(简单或授权)或使用证书加密的方式实现。其中一个选项在应用程序的对象属性中启用。

### 使用证书进行加密​

在MetaFacture内，可以使用证书对工程和应用程序进行加密和签名，以保护它们免受未经授权的访问。

为此，您可以为每个用户文件配置特定的安全设置。当用户使用MetaFacture工程时，会自动使用这些设置。因此，它们不必为每个工程重做。用户配置文件的安全特性的一般配置是在MetaFacture的***安全栅栏***视图中完成的。参见下面的个别说明。

你亦可直接用证书加密计划文件或申请下载或网上更改:

当前工程的独立用户加密是在工程设置中的安全类别中配置的。  
应用程序的独立用户加密是在应用程序对象的属性对话框中配置的。

提示！

当您使用证书加密工程、应用程序或在线代码时，为了再次打开该对象，您将需要带有私钥的证书。

注意：如果安装了MetaFacture Security Agent安全代理插件产品，则***安全栅栏***视图提供一个附加选项卡: ***设备***.这允许为与控制器的加密通信配置证书。

  
证书，Windows证书存储

所有可用的证书都位于您计算机上的Windows证书存储***(证书管理器)***中。有两种类型的密钥:

带有私钥的证书

对文件解密  
对数字签名

  
带有私钥的证书

对文件加密  
对数字签名验证

本地Windows证书存储区通常由计算机的IT管理员填写证书。证书可以使用特殊工具创建，也可以由受信任的证书颁发机构(CA)请求创建。

如果您收到一个证书文件，您需要将其安装到Windows证书存储中，然后双击存储目录中的文件。根据类型(仅包含私钥或公钥的证书)，将出现相应的导入向导。

---

### 用户管理和密码管理器​

可以在MetaFacture中管理具有不同权限的用户帐户。对于每个帐户，您可以定义用户可以操作哪些工程对象。

用户管理是在***工程设置***中的***用户和组类别***中配置的。

在创建用户和组之前，请注意以下事项:

1.权限只能分配给用户组。因此，必须将每个用户分配到一个组。

2.默认总是有一个Everyone组，默认情况下，每个用户和每个其他组最初都是这个组的成员。因此，每个用户帐户都默认配置了定义的标准权限。  
不可以删除Everyone组，只能对它进行重命名，并且不能将此组内的成员删除。  
注意:默认情况下，Everyone用户组没有更改当前用户、组和权限配置的权利!

3.默认有一个Owner用户组总是包含一个Owner用户。从V1.0开始，只有Owner最初有权更改新项目中的当前用户、组和权限配置! 因此，只有Owner可以将此权利分配给另一个组。  
最初，Owner可以使用Owner用户名和空密码登录。  
您可以将更多用户添加到组Owner中，或将用户从组中删除，但必须保留至少一个成员。像Everyone一样，您不能删除组Owner，它拥有所有访问权限。这可以通过拒绝所有组的所有访问权限来防止项目变得不可用。  
可以对用户组Owner和用户Owner都可以重命名。

4.如果重新启动编程系统或工程，则最初没有用户登录到该工程。但是，用户可以使用用户名和密码通过某个用户帐户登录，以获得为该帐户定义的访问权限。

5.每个项目都有自己的用户管理! 因此，为了获得集成到项目中的库的某些访问权限，例如，用户必须显式地登录到库项目。  
在不同的项目中定义的用户和组并不相同，即使它们有相同的名称。

6.工程中的用户管理只有在与对工程和对象的访问的相应权限分配相连接时才有意义。工程权限通常在***用户管理***的对话框***权限***中管理。您还可以在对象***属性***的***访问控制***选项卡上更改对单个工程对象的访问权限。

8.在标准菜单***项目*** ➔ ***用户管理***菜单下可以登录或注销工程中定义的用户。密码管理器允许管理计算机上的登录数据。

注意：从V1.0开始，只有Owner最初有权更改新项目中的当前用户、组和权限配置! 因此，只有Owner可以将此权利分配给另一个组。  
   
提示！

MetaFacture很难存储用户密码。如果忘记密码，用户帐户将无法使用。如果忘记了Owner密码，整个工程可能无法使用！

---

### 密码管理器

密码管理器允许保存在工程登录过程中输入的登录数据记录。它可以通过登录对话框中的一个按钮访问，并提供对当前所需的登录数据的快速访问。这可能很有帮助，例如，如果您正在并行处理由不同密码保护的几个库项目。

密码管理器本身由单独的主密码保护。如果第一次使用密码管理器，MetaFacture要求在密码管理器配置对话框中定义此密码。MetaFacture将记录主密码，直到您终止当前MetaFacture会话。当在新会话期间首次登录密码管理器时，或在更改密码管理器密码后，必须都要输入密码。

### 权限管理​

为了使用户管理有意义，对工程和工程中的对象的访问进行权限管理是必要的。

工程的权限通常在***用户管理***的***权限***编辑器中管理。您还可以在对象***属性***的***访问控制***选项卡上更改对单个工程对象的访问权限。

在设定权利前，请遵守以下规定:

1.在一个新工程中，MetaFacture会使用默认值“allowed”(标准权利)设置对象上执行操作的所有权利。惟一的例外是更改当前用户、组和权限配置的权利。最初只有“Owner”组有这个权利。  
2.如果您是具有更改权限组的成员，则可以在项目的后续工作中随时更改每个权限。您可以通过在“允许”和“禁止”之间切换，或者通过重置为默认值来更改权限。

文件，保存​  
在将项目文件保存到文件系统之前，为项目文件提供所需的保护;如上所述。对于只读工程文件，根据写保护的类型，可以提供各种选项，以便仍然可以保存文件。

如果项目稍后将在较旧的MetaFacture版本中打开，那么为该版本(文件类型)保存项目是有意义的，因为MetaFacture还将立即通知您在保存过程中可能出现的数据丢失。

如果保存库为项目，请遵守库创建规则。还要考虑直接在库存储库中安装库的可能性。

如果您希望继续在另一台计算机上使用项目，那么不仅要保存项目文件，还要从所有相关的辅助文件创建项目存档。

您可以进行设置，以便在每次保存项目时创建该项目的备份副本。另外，您可以配置MetaFacture，这样项目通常会在特定的时间间隔自动保存。

如果希望将工程保存在源代码控制系统中，请观察相应的MetaFacture附加组件。例如，支持到SVN的链接。