以下是有关安全措施的一些基本信息。此信息适用于MetaFacture中连接到的MetaFacture或控制器中。

---

### 通过用户管理进行访问保护

作为防止未经授权访问数据的一种方法，有必要为用户帐户配置特定的访问权限。只有具有凭据的用户才能访问数据或功能。

大致区分以下类型的用户管理：

- 简单的用户管理:  
    要访问数据，只需输入密码或用户名和密码的有效组合。这意味着只能授予或拒绝访问权限。无法配置分级权限。
- 基于组的用户管理：  
    访问权限已分配给用户组。完全按照这些分配的和不同的权限输入凭据后，属于组的用户可以访问数据或功能。

---

### 加密，签名​

加密：

数据加密意味着：数据将转换为无法读取的形式，并且只能使用匹配的密钥再次使其可读。在最简单的情况下，密钥是密码或密钥对。

加密方法有两种：

- 对称方法：（直到1970年代中期的唯一加密类型）  
    特性：密钥的使用  
    优势：快速、简单的编码  
    劣势：密钥必须秘密共享。
- 不对称方法：  
    特性：密钥对的使用（私有/秘密密钥和公共密钥）  
    优势：公开密钥可以被任何人访问，并可以进行身份验证。  
    劣势：慢（比对称方法慢约1,000至10,000倍）；复杂编码；密钥长度长

密钥交换通常通过非对称方法进行；通过对称方法进行加密和解密。

签名：

为了验证消息的无可辩驳的所有权和完整性，应为其提供签名。常见以下步骤：

- 发送方：确定数据的唯一哈希值（H）
- 发送方：用私钥（He）加密哈希值
- 接受方还计算哈希值，并用公共密钥解密He并比较这两个值。这样就可以唯一标识发送者，并验证发送者拥有私钥。

在非对称加密的情况下，首先要在发送方和接收方之间交换证书中包含的公钥。此外，每个参与者都需要一个私钥，如果他们具有证书，就可以使用私钥解密数据。因此，如果要访问证书，则需要证书和私钥。

为此，必须使用哈希方法：

- 哈希方法：  
    特性：数据的唯一指纹（例如，数据的校验和）  
    尽可能低的冲突（对于单个哈希值很难找到/构造两个不同的数据）

---

### 证书​

为了将公共密钥分配给身份，通常将其嵌入证书中。

在基于证书的系统中，每个用户都会收到一个数字证书。该证书用于数字标识。它包含有关用户身份和公共密钥的信息。每个证书都由发行机构进行认证，而发行机构又可以由上级机构进行认证。此PKI（公钥基础结构）的信任系统严格分层。通用信任锚是一个根证书。

证书内容：

- 版本
- 序列号
- 算法ID
- 发行人（主管部门或公司）
- 有效期从（之前）到（之后）
- 证书所有者（主题）
- 证书所有者密钥信息（主题公用密钥）  
    
    - 公钥算法
    - 证书所有者的公钥
- 发行人的唯一ID（可选）
- 所有者的唯一ID（可选）。所有者拥有与公钥匹配的私钥。
- 扩展名  
    
    - 目的（扩展密钥用法）
    - ...

证书由2个部分/文件组成：

- 公开的X.509证书（可以颁发给任何人）
- 仅与证书匹配的私钥或其公钥（必须保密）。