### 数据安全建议

为了将数据安全违规的风险降到最低，我们建议对运行应用程序的系统执行以下安排和技术操作。 尽可能避免将PLC和控制网络暴露于开放网络和Internet中。使用附加的数据链路层进行保护，例如用于远程访问的VPN。 安装防火墙机制。 限制对授权人员的访问。 在调试前后，请定期更改任何默认密码。

使用MetaFacture和相应控制器支持的安全功能，例如与控制器通信的加密和限制的用户访问。

对于支持设备用户管理的设备，设备编辑器包括***用户和组*** 选项卡和***访问权限***。当设备提供时，您可以在这里查看设备的用户管理，并在同步模式(非在线模式)下编辑。在这里，你可以授予或拒绝定义的用户组控制器上的特定权限。

设备用户管理可以在设备描述中设置。

注意***在线 ➔ 安全***菜单中的命令。您可以在当前登录的控制器上轻松添加、编辑或删除用户帐户。

为了使***访问权限***选项卡在设备编辑器中可用，必须在设备编辑器中选择相应的MetaFacture选项，并在设备描述中将其解锁。如果设备编辑器不可用，请与控制器的制造商联系。

为了向用户组授予访问权限，必须首先在设备编辑器的***用户和组***选项卡上配置用户和用户组。必须先在控制器上设置用户管理，然后才能在其上配置访问权限。当设备的用户管理还未启用时，可以通过以下方式启用：通过切换到***用户和组***选项卡上的同步模式，或者通过命令***在线 ➔ 安全 ➔ 添加设备用户***添加一个新用户。

---

### 设备用户管理的一般信息​

请注意，访问权限只能授与组，而不能授与单个用户。因此，每个用户都必须是一个组的成员。

可以为在控制器的各个对象上执行的以下操作授与访问权限：

- 视图
- 修改
- 添加/移除
- 执行

控制器上的每个对象通常只分配给一个组件。并且对象可以使用以上所有访问权限。但是，在大多数情况下，一个对象仅需要以下两个权限：

- ***查看***
- ***修改***

对象以树形结构组织。对于两个单独的对象类型，存在两个根对象：***Runtime对象 ➔ 设备***和 文件系统对象 ***➔ /***。

在文件系统对象中，可以将权限授与控制器当前执行目录的文件夹。

在runtime对象中，所有在控制器中具有在线访问权限的对象都将受到管理，因此必须控制访问权限。

通常，访问权限是从根对象（也包括***设备***或/继承到子对象的。这意味着，如果拒绝或显式向父对象上的用户组授与权限，则这首先影响所有子对象。

就权限而言，还必须区分一项权限是明确授与的、拒绝的还是中立的。中立意味着既不明确授与也不拒绝它。在这种情况下，将应用父对象的权限。但是，如果在对象的整个层次结构中没有显式地授与或拒绝任何权限，那么根据定义，它最初是被拒绝的。这意味着所有的权限首先被拒绝。

唯一的例外是***查看***操作的访问权限。对于***设备***runtime对象和“/”文件系统对象上的每个用户组，最初都会显式地授予此权限。除非在子对象中明确拒绝，否则这将允许首先对所有对象进行读取访问。

“Everyone”用户组在这里有一个特殊的位置：如果没有其他级别的用户组明确授与或拒绝访问权限，则此权限仅在权限检查的最后才适用。

有关对象的概述表，请参见“选项卡‘访问权限’”一章。

---

### 首次登录控制器以编辑或查看其用户管理​

要求：控制器支持设备用户管理，但还没有激活。

1.双击设备树中的控制器设备对象。⇒设备编辑器打开。

2.点击***用户和组***选项卡。

3.点击![](https://resource.helplook.net/docker_production/3648ne/article/QL6S9vuY/6721ff1d4577d.png)。⇒将打开一个对话框，提示是否应激活设备用户管理。

4.点击***确定***以确认提示。⇒***添加设备用户*** 对话框打开。

5.现在创建一个设备用户，以便作为该用户编辑用户管理。此时只有***管理员***组可用。为用户指定***名称*** 和 ***密码***。显示密码强度。也可以设置修改密码的选项。默认用户可以随时修改密码。点击***确定***进行确认。  
⇒将打开***设备用户登录*** 对话框。

6.为刚刚定义的用户指定***用户名***和***密码***。  
⇒点击***确定***确认后，设备用户管理将显示在编辑器视图中。它包含刚刚定义的管理员组的用户。该用户的名称也以***设备用户***的形式显示在窗口的任务栏中。

---

### 在控制器的用户管理中设置新用户

要求：控制器具有设备用户管理功能。您具有相应的访问数据。

  
1.双击设备树中的控制器设备对象。⇒设备编辑器打开。

2.点击***用户和组***选项卡。

3.点击![](https://resource.helplook.net/docker_production/3648ne/article/QL6S9vuY/6721ff9e89b91.png)（同步）将用户管理配置从控制器加载到编辑器。如果尚未登录到设备，则会打开***设备用户登录***对话框，输入用户名和密码。⇒设备的用户管理配置显示在编辑器中。

4.在***用户***视图中，点击***添加***。⇒将打开***添加用户***对话框。

5.指定新用户的名称并将该用户分配给组。这将作为用户最小所需的默认组。以后可以将用户分配给其他组。为用户定义并确认***密码***。定义用户是否可以更改密码以及用户是否必须在首次登录时更改密码。点击确定进行确认。  
⇒新用户在***用户***视图中显示为新节点，在***组***视图中显示为选定默认组的新子项。

---

### 在控制器的用户管理中更改对控制器对象的访问权限​

要求：控制器具有设备用户管理功能。您具有相应的访问数据。

1.双击设备树中的控制器设备对象。⇒设备编辑器打开。

2.点击***访问权限***选项卡。

3.点击![](https://resource.helplook.net/docker_production/3648ne/article/QL6S9vuY/6722033c14809.png)（同步）将权限管理配置从控制器加载到编辑器。如果尚未登录到设备，则会打开***设备用户登录***对话框以输入访问数据。⇒设备的访问权限管理配置显示在编辑器中。

![](https://resource.helplook.net/docker_production/3648ne/article/QL6S9vuY/672203544e1ae.png)

4.选择要将其访问权限更改为对象树中的左侧的对象。  
⇒在***权限***视图中，有一个表显示了所有配置的用户组对此对象的访问权限。

5.双击表中要更改的位置。⇒如果对象具有子对象，则对话框将提示您是否要修改子对象的权限。

6.点击***是***或***否***关闭提示。  
⇒权限从“允许” ![](https://resource.helplook.net/docker_production/3648ne/article/QL6S9vuY/6722038f24a55.png)切换为 “不允许”![](https://resource.helplook.net/docker_production/3648ne/article/QL6S9vuY/672203932c129.png)，或者反之。表格单元格中的符号会相应更改。显式设置权限在表中显示为绿色或红色符号。从父对象继承的权限显示为灰色符号。

---

### 将DUM2文件以离线方式传输并使能保存用户管理功能​

1.双击设备树中的控制器设备对象。⇒设备编辑器打开。

2.点击***用户和组***选项卡。

3.点击![](https://resource.helplook.net/docker_production/3648ne/article/QL6S9vuY/672203d4cf9bd.png)⇒打开从本地文件系统选择文件的对话框。

4.从本地文件系统中选择具有所需用户管理的文件(.dum2)，并点击***打开***进行确认。⇒***输入密码***对话框打开。

5.指定导出用户管理文件时分配的密码(可以通过![](https://resource.helplook.net/docker_production/3648ne/article/QL6S9vuY/672203fadc905.png)按钮)。  
警告：通过\*.dum2文件导入设备用户管理将完全覆盖设备上的现有用户管理。为了保证后续再次登录设备，您需要从最近导入的用户管理中获取认证数据。  
⇒正确输入密码后，下载的用户管理文件中的配置将显示在编辑器视图中。

6.根据需要编辑配置。例如，更改用户密码或添加新用户。  
⇒每个修改都会立即下载到设备上。