### MetaFacture中的编译附注

编译附注是应用程序源代码中包含在花括号中的文本。编译附注用于在代码中插入特殊语句，编译器可以对其进行计算。这允许编译附注在预编译或编译（代码生成）方面影响一个或多个变量的属性。编译器无法识别的编译附注将作为注释传递。

编译附注的语句字符串也可以跨多行。 有关语法的更多细节请参阅各个MetaFacture编译附注的说明。

有不同的编译附注用于不同的目的（例如：初始化变量、监视变量、将变量添加到符号配置、在编译过程中强制显示消息以及变量在特定条件下的行为）。

注意：必须保留大小写字符。

> 示例
> 
> {warning 'This is not allowed'}
> 
> {attribute 'obsolete' := 'datatype fb1 not valid!'}
> 
> {attribute 'Test':='TestValue1;  
>  TestValue2;  
>  TestValue3'}

---

### 可能的插入位置​

注意：MetaFacture中的编译附注不是C预处理程序指令的一对一实现。必须像普通语句一样定位编译附注。不能在编译附注中使用表达式。

MetaFacture编译器应评估的编译附注可以插入到以下位置：

- 在POU的声明部分：  
    
    - 在文本声明编辑器中，直接将编译附注指定为行，可在POU开头或变量声明之前。
    - 在表格编辑器中，指定的编译附注应在在对话框***编辑声明部分/属性***中第一条声明行之前。
- 在全局变量列表中
- 在POU的实现部分：  
    
    - 编译附注必须位于“语句位置”，即在单独一行的POU开头，或在“;“或 END\_IF、END\_WHILE等之后。
    - FBD/LD/IL编辑器：在FBD/LD/IL编辑器网络中，可以通过命令 FBD/LD/IL ➔ Insert Label 插入像标签一样的编译附注。然后，在带有相应编译辅助语句的标签文本字段中，替换默认文本标号：。要在标号上使用编译附注，请先指定编译附注，然后再指定标号。

> 条件编译附注不正确和正确的位置
> 
> .INCORRECT:
> 
> {IF defined(abc)}  
> IF x = abc THEN  
> {ELSE}  
> IF x = 12 THEN  
> {END\_IF}  
> y := {IF defined(cde)} 12; {ELSE} 13; {END\_IF}  
> END\_IF   
>    
> .CORRECT:
> 
> {IF defined(abc)}  
> IF x = abc THEN  
> {IF defined(cde)}  
>  y := 12;  
> {ELSE}  
>  y := 13;  
> {END\_IF}  
> END\_IF  
> {ELSE}  
> IF x = 12 THEN  
> {IF defined(cde)}  
>  y := 12;  
> {ELSE}  
>  y := 13;  
> {END\_IF}  
> END\_IF  
> {END\_IF}

范围：

根据编译附注的类型和内容，它可能会影响以下内容：

- 后续声明
- 仅下一条语句
- 所有后续语句，直到被相应的编译附注取消为止
- 所有后续语句，直到使用其他参数执行相同的编译附注或到达代码末尾为止。在这种情况下，“代码”表示声明部分，实现部分，全局变量列表和类型声明。因此，当某个编译附注仅在声明部分的第一行上并且未被其他编译附注所替代或取消时，编译附注会影响整个对象。

###  

---

### MetaFacture中的编译附注类别​

MetaFacture编译附注分为以下几类：

- 属性编译附注（影响编译和预编译）
- 消息编译附注（编译时打印用户定义的消息）
- 条件编译附注（影响代码生成）
- 用户定义的编译附注