您要转换另一个单位制的数据时，可以定义一个转换规则。以特定的数量级和度量单位执行此数据。

转换规则在***单位转换***对象中定义。MetaFacture自动将每个转换规则实现为功能块\_Impl，并将其实例化为。每个转换规则包括用作功能块的Convert和Reverse方法。您可以在访问变量的位置将变量链接到转换规则。输入助手在功能块和实例调用类别中提供转换规则。执行后，结果是根据转换规则的转换值。

在可视化中，在元素属性中配置的IEC变量也可以链接到转换规则。

---

### 定义单位转换​

1.双击设备树中的***单位转换***对象。  
⇒相应的编辑器将打开，其中包含已定义的转换规则的表。您可以在***类型设置***中编辑规则，并在***条件设置***中编辑相应的条件。

2.双击***添加新条目***字段，然后输入名称。⇒MetaFacture实现\_Impl功能块并将其实例化为。

3.双击***类型***字段，然后从下拉列表中单击类型。  
⇒输入字段显示在表格下方，用于编辑转换规则。输入字段根据所选类型而有所不同。

4.在输入字段中更改转换规则。⇒所做的更改显示在表的***设置***类别中。

5.双击***条件***字段，然后从下拉列表中单击条件类型。  
⇒输入字段显示在表的***条件设置***类别下方，以编辑条件。输入字段根据所选类型而有所不同。

6.编辑条件。⇒更改显示在表的***条件设置***类别中。

---

### 定义可转换的单位转换​

您可以定义将哪种转换规则应用于特定的语言或条件。

  
1.双击设备树中的***单位转换***对象。  
⇒相应的编辑器将打开，其中包含已定义的转换规则的表。

2.双击***添加新条目***字段，然后输入名称。  
⇒例如：Conv\_A\_LanguageDependent

3.双击***类型***字段，然后单击***可转换转换***。双击***条件***字段，然后单击***语言***。  
⇒在主表下方，显示带有***条件设置***的***可切换转换***表。

4.在***可转换转换***表中，从***可转换转换名称***列的下拉列表中双击预定义的转换规则，例如Conv\_AInInch。  
在“***环境设置***”的***环境语言***输入字段中，输入一个值，例如en。  
⇒仅当可视化管理器中设置的语言为***en***时，MetaFacture才执行Conv\_AInInch转换规则。

5.在***可转换转换***表中，从***可转换转换名称***列的下拉列表中双击预定义的转换规则，例如Conv\_AInMM。  
在“***环境设置***”的***环境语言***输入字段中，输入一个值，例如de。  
⇒仅当可视化管理器中设置的语言为***de***时，MetaFacture才执行Conv\_AInMM转换规则。

6.在应用程序或可视化文件中应用Conv\_A\_LanguageDependent转换规则。  
⇒如果可视化中的设置语言是英语，则应用程序可视化将应用Conv\_AInInch转换规则。如果可视化中的设置语言是德语，则应用程序可视化将应用Conv\_AInMM转换规则。当前的可视化语言位于VisuElems.CurrentLanguage变量中。

###  

---

### 应用转换规则​

向访问IEC变量的对象添加转换规则。

  
1.在设备树中，双击访问IEC变量的对象，以将IEC变量链接到该位置的转换规则。

2.为IEC变量的转换结果声明一个变量。⇒ST示例代码：rConvertedA：REAL;

3.使用输入助手通过Convert方法应用转换规则，然后将结果分配给变量。  
⇒ST示例代码，用于将IEC变量链接到转换规则：rConvertedA：= ConvRule\_A.Convert（rA）;

---

### 应用反向转换规则​

1.在设备树中，双击访问IEC变量的对象。

2.为转换规则的结果声明一个变量。⇒ST示例代码：rReverseA：REAL;

3.使用Reverse方法应用反向转换规则，然后将结果分配给变量。  
⇒rReverseA := ConvRule\_A.Reverse(rConvertedA);

---

### 例如​

要求; 转换规则为Conv\_XtoY。

> ST call
> 
>   
> PROGRAM A\_PRG  
> VAR  
>  rA : REAL;  
>  rConvertedA : REAL;  
>  rReverseToA : REAL;  
> END\_VAR
> 
> rConvertedA := Conv\_XtoY.Convert(rA);  
> rReverseToA := Conv\_XtoY.Reverse(rConvertedA);

> CFC call
> 
> 在CFC编辑器中，通过块定义转换规则的实例名称。在块中选择方法。在块中选择方法。
> 
> ![](https://resource.helplook.net/docker_production/3648ne/article/y5L3hYP6/6721d2a8247a1.png)
> 
> ![](https://resource.helplook.net/docker_production/3648ne/article/y5L3hYP6/6721d2b6c6ecf.png)