组合的编辑器可以使用FBD（功能框图），LD（梯形图）和IL（指令列表）进行编程。

FBD和LD编程的基本单元是网络。每个网络都包含一个可以表示以下内容的结构：逻辑或算术表达式，POU（功能，功能块，程序等）的调用，跳转或返回指令。IL实际上不需要任何网络。但是，在MetaFactureIL程序中，IL程序也至少包含一个网络，以支持转换为FBD或LD。有鉴于此，您还应该将IL程序有意义地划分为网络。

---

### 功能框图（FBD）​

该功能块图是面向图形的IEC 61131编程语言。它与网络列表配合使用，其中每个网络都包含一个结构，该结构可以包含逻辑和算术表达式，功能块的调用，跳转或返回指令。

这里使用布尔代数熟悉的框。块和变量通过连接线连接。网络中的信号从左到右向右执行。编辑器中的信号流从网络1开始，从上到下运行。

> 例
> 
> ![](https://resource.helplook.net/docker_production/3648ne/article/GNKF1wbh/67208e2c46eb2.png)

CFC还是一种基于与FBD相同的原理的编程语言，但具有以下差异：

- CFC编辑器不是面向网络的。
- 您可以将元素自由放置在CFC编辑器中。
- 可以直接插入反馈。
- 执行顺序由当前插入的元素列表决定，您也可以更改这些列表。

---

### 梯形图(LD)​

梯形图（LD）是一种近似于电路图的图形化编程语言。一方面，梯形图适用于设计逻辑开关单元，但另一方面，您也可以像在FBD中一样创建网络。因此，您可以很好地使用LD来控制其他程序块的调用。

梯形图由一系列网络组成。网络在左侧以垂直线（母线）为边界。网络包含触点，线圈，运算块（POU）和连接线的电路图。在网络的左侧，有一个或多个触点，这些继电器从左到右中继开或关状态，这对应于布尔值TRUE和FALSE。布尔变量与每个联系人关联。如果此变量为TRUE，则状态通过连接线从左到右传递。否则，继电器为OFF。因此，网络右侧的线圈接收来自左侧的值ON和OFF，并且将值TRUE或FALSE相应地写入分配给它们的布尔变量中。

如果元件串联连接，则表示“与”运算。如果它们并联连接，则表示“或”运算。穿过元素的线表示元素的取反。输入或输出的取反由圆圈符号表示。

> 例
> 
> ![](https://resource.helplook.net/docker_production/3648ne/article/GNKF1wbh/67208e6c9ca18.png)

IEC 61131-3定义了一个完整的LD命令集，该命令集由不同类型的触点和线圈组成。触点从左到右传导电流（根据其类型）。线圈存储输入值。触点和线圈分配给布尔变量。您可以通过跳转，返回，标签和注释来补充LD网络

---

### 指令表（IL）​

指令列表是类似于IEC 61131的汇编程序编程语言。它支持基于累加器的编程。

指令列表（IL）由一系列指令组成。每条指令均以新行开头，并包含一个运算符，并根据操作类型，以逗号分隔一个或多个操作数。可以在指令前面放置一个标签，后跟一个冒号。它用于标识指令，您可以将标签用作跳转目标。注释必须是一行中的最后一个元素。指令之间可以插入空行。

支持所有IEC 61131-3操作指令，以及多个输入，多个输出，取反，注释，输出的设置/重置以及有条件/无条件跳转。

每个指令主要基于将值加载到累加器（LD指令）中。之后，使用来自累加器的参数执行相应的操作。将运算结果再次写入累加器，您应在该处通过ST指令有目的地存储该运算结果。

指令列表支持比较运算符（EQ，GT，LT，GE，LE，NE），并跳转用于条件执行或循环的编程。跳转可以是无条件的（JMP）或有条件的（JMPC / JMPCN）。在条件跳转的情况下，将检查累加器中的值是TRUE还是FALSE。

> 例
> 
> ![](https://resource.helplook.net/docker_production/3648ne/article/GNKF1wbh/67208ea81cfce.png)