persistent变量在重新加载应用程序之后以及下载，热启动或冷启动之后会保留其值。

控制器上需要特殊的非易失性存储区，例如NVRAM或UPS，以延长使用寿命。将数据保护在这样的内存中不需要额外的时间，这与使用Persistence Manager保留数据相比是一个优势。如果控制器不提供硬件支持，则数据通常存储在文件中。如果正确关闭控制器，数据将被保留。但是，如果发生电源故障或拔出插头，数据将会丢失。

---

### 行为

保留的价值

- 不受控制的出口
- 通过调用***热复位***命令进行热启动
- 通过调用***冷复位***命令进行热启动
- 重复下载应用程序

重新初始化

- 调用***初始复位***命令

因此，仅当将控制器重置为出厂设置时（例如，当您单击***在线 ➔ 初始复位***时），才会重新初始化持久变量。

另一方面，如果您再次下载该应用程序，则在可能的情况下将保留持久数据。那取决于导致下载的变化有多深。更改应用程序名称始终会导致完全重新初始化。对实现的更改永远不会导致重新初始化：数据持久性被完全保留。更改声明时，只有在现有变量是持久性的情况下，声明的更改才会导致新变量的初始化，以便持久性变量列表保持一致。当您添加新变量或删除现有变量时，就是这种情况。如果您编辑和更改先前声明的持久变量的标识符或数据类型，则可能会发生不一致。

---

### 下载机制

在持久性编辑器中编辑变量列表会导致变量列表在保存之前自动进行编辑，而不是按照编辑器中显示的那样进行保存。

在后处理期间，已删除的变量将被具有相同内存要求的占位符变量替换。结果，后续变量将其地址保留在过程映像中。此外，您添加的变量将移动到列表的末尾。后处理可以抵消将导致持久性损失的更改。但是，您会创建使用额外内存的间隙。

下载时，变量列表的CRC值和列表的长度（变量数）存储在控制器上。再次下载时，会将新测试值与控制器上当前的测试值进行比较。然后依次比较变量列表直到指定的长度。如果您编辑了声明（例如，名称或数据类型），则该变量将重新初始化。否则，将保留其值。重复下载时，MetaFacture检查在持久性编辑器中声明的变量列表是否仍与控制器上已存在的变量列表一致。

当变量本身没有显着修改时，该机制会很好地工作。标识符和数据类型的太大更改将继续导致重新初始化和持久性的损失。如果您预计会因应用程序需求而频繁更改，则不建议使用此类列表。此外，在数据类型更改后的在线更改中，持久变量的健壮性不及具有正常寿命的变量。

一段时间后，最好清除变量列表中的所有空白（命令***重新排序列表和清除空白***）。但是，清理后，该列表不再与控制器上的列表匹配，并且您已触发所有持久变量的初始化。 所有变量的持久性都会丢失。

---

### 使用配方管理器恢复数据

要在不丢失持久性的情况下清理全局持久性变量列表，可以使用“配方管理器”将数据保存在配方中。这将在配方管理器中为持久变量列表的所有变量创建一个列表，同时控制器的当前值将作为配方存储。然后执行命令重新排序列表和清除间隙，然后再次执行下载。现在，当您执行命令***从配方还原值***时，将还原配方中保存的值。

---

### 更改持久变量列表中的现有声明​

如果更改变量的名称或数据类型，则将其解释为新的声明，并在下次在线更改或下载时导致变量的重新初始化。对于复杂的数据类型，例如，当添加新组件时，或者在使用的所用结构的深度中将变量的类型从INT更改为UINT时，都会发生更改。

基本上，复杂的用户定义数据类型不适合在持久变量列表中进行管理，因为即使很小的更改也会导致使用所有组件初始化变量。

---

### 在实例路径的情况下双重分配内存​

您可以保留全局变量或在功能块或程序中本地声明的变量。为此，将关键字PERSISTENT添加到声明中。此外，您在持久性全局变量列表中将此变量的实例路径插入。为此，请在持久性编辑器中执行***添加所有实例路径***命令。

持久性由以下机制保证：

- 确定要访问变量的循环任务。
- 在第一个循环任务结束时（在每个循环中），变量将被复制到持久性全局变量列表中。
- 重启控制器后，将持久变量的值复制到普通变量。

这种机制的缺点是在声明位置和实例路径位置都分配了内存。该持久变量具有双倍的内存分配。此外，数据在每个循环中都复制到两个位置。这可能很耗时，尤其是在涉及较大的结构化值时。

---

### 持久功能块实例的内存位置​

功能块实例始终完全存储在内存中。这是必需的，以便相同的代码可以在不同的实例上工作。如果功能块中只有一个变量标有PERSISTENT，则功能块实例将所有变量完全存储在剩余的存储器中，尽管只有一个变量被视为持久性的。但是，非易失性存储器的可用程度与主存储器不同。

具有指向SRAM中的实例作为变量的指针的功能块未存储在受保护的存储器中。

---

### 从MetaFacture V2.3项目导入​

当您打开MetaFacture V2.3项目以将其导入MetaFacture V3时，将不保留持久变量的声明。您必须修改声明，然后在单独的持久性全局变量列表中再次创建。