变量及其数据的生命周期从创建变量时开始，直到变量被删除并释放其内存时结束。创建，初始化或实例化变量的时间取决于声明的范围。释放内存的时间通常也取决于范围。例如，通过退出应用程序来释放全局变量的内存。

它们可以将数据保留的时间比平常更长。为此提供了以下机制。

数据保持机制

- (A): 带有关键字PERSISTENT RETAIN的持久性全局变量列表![](https://resource.helplook.net/docker_production/3648ne/article/2XHfMvnA/6721d30219848.png)  
    重新加载应用程序时，持久变量将保留其值。此外，在下载，热启动或冷启动之后，将还原这些值。
- (B): 使用关键字RETAIN保留变量  
    保留变量在热启动之后会保留其值，但在重新加载应用程序，下载或冷启动后不会保留。
- (C): MetaFacture Application Composer的Persistentce管理器的变量  
    Persistence 管理器的变量存储在外部文件中。
- (D): 配方变量  
    配方变量及其值存储在配方文件中。

---

### 机制比较​

哪种机制适合哪种应用？表中考虑了一些常见的用例。具体示例涉及编译控制系统。

**机制和用例的比较**

|  | 用例 | （A） Persistent变量 | （B） Retain变量 | （C）Persistent管理器的变量 | （D）配方变量 |
|---|---|---|---|---|---|
| 1 | **应用程序必须维护设备设置。**  例如：停电后，建筑控制系统必须具有有关需要将百叶窗升高多长时间的信息。 | 适合1  首选用例  在这种情况下，您也可以使用保留变量代替持久变量。这对于声明经常更改的变量是有利的。 | 适合  首选用例  当声明经常更改时，保留变量是一个优势。 | 适合2  这对于没有任何硬件支持的控制器是有利的。特殊功能使之成为可能，例如双文件缓冲。 | 可以，但是非常复杂，因此不建议使用。 |
| 2 | **程序更改或扩展后，**  **应用程序还必须保持值。** |  |  |  |  |
| 2a: 罕见的扩展  例如：应用程序程序员使用新的开关扩展程序并安装新的指示灯。在此之前，构建控件必须仍然具有可用的保存值。 | 适合1  首选用例 | 适合 | 适合2 | 可能，但是很复杂。 |
| 2b: 无限制的更改，包括删除或更改变量的数据类型  构建控件正在运行并且是保持的。当应用程序程序员向控制器添加新功能并因此向功能块添加另一个持久变量时，必须保留到那时为止保存的值。例如，FB中的程序扩展了一个变量，该变量控制在一定时间后自动关闭先前不受控制的灯。扩展后，构建控件必须具有所有可控灯的可用时间。 | 不合适 | 适合  在线更改后，将保留来自保留变量的数据。 | 尽可能适合2  首选用例 | 如果是文本的，那是可能的，但是比较复杂 |
| 2c: 应用程序必须在下载后保持值。 | 适合 | 不合适 | 适合 | 适合 |
| 3 | **该应用程序必须能够使用不同的值集。**  例如：夏季，冬季和假期的操作设置必须保存并在需要时导入。 | 不合适 | 不合适 | 不合适 | 适合  首选用例 |
| 4 | **该应用程序必须能够使用其他系统的设置。**  必须可以使用类似的变量将设置传输到另一台设备。 | 不合适 | 不合适 | 适合2 | 适合3 |
| 5 | **该应用程序必须提供人类可读的数据。**  用户必须能够读取，比较和编辑数据。 | 不合适 | 不合适 | 适合2 | 适合3 |

1缺点：仅当运行时系统支持此机制并且可用NVRAM内存或UPS时，才有可能。优点：速度快；推荐应用：1和2a

2缺点：如果变量集较大（&gt;10000），则在初始化和关闭期间会出现较长的延迟。优点：不需要特殊的内存；即使更改，扩展或删除，价值保留也存在。

3优点：可远程编辑，传输。缺点：复杂

---

### 调用在线命令时变量的使用期限​

| 用户在***在线***菜单中输入 | 带使用期限的变量  不是RETAIN也不是PERSISTENT | RETAIN | PERSISTENT  RETAIN PERSISTENT  PERSISTENT RETAIN |
|---|---|---|---|
| ***在线更改***命令 | x | x | x |
| ***热复位***命令 | i | x | x |
| ***冷复位***命令 | i | i | x |
| ***下载***命令 | i | i | x1 |
| ***初始复位***命令 | i | i | i |

x : 变量保留其值。

i : 变量被初始化。

1 注意: 有关保持数据的结构，请参阅“下载机制”中的信息。

---

### 下载启动项目时变量的保持性​

普通变量的值会丢失其值，并会重新初始化。

在以下情况下，持久变量的值受到保护：

- 内存中持久变量的结构与持久数据列表中的结构匹配。

  
在以下情况下，保留变量的值受到保护：

- 内存中持久变量的结构与持久数据列表中的结构匹配。
- persistent持久变量与应用程序匹配（GUID必须同意）

当启动应用程序时，不满足恢复保留变量和持久变量的值的要求时，将发生“保留不匹配”。硬件制造商的文档中描述了对此差异的响应。

注意：有关持久数据的结构，请参阅“下载机制”中的信息。