在代码生成期间，您还可以对源代码进行静态分析(lint)。这将决定您的源代码是否符合您定义的编码准则——根据lint分析工具背后的思想。

- 在***项目设置***中的***静态分析***分类对话框中激活已选中的规则。每次生成代码时，检查本身都会自动执行，例如单击***编译 ➔ 生成代码***时。如果确定与规则不符，则在消息视图的***编译***类别中将其报告为错误消息。报告的错误前缀为SA。

提示！

对于带有***静态分析***的静态代码分析，只检查项目的应用程序代码。库被排除在检查之外。

***POUs***视图中的GVL变量不一定要检查: 如果您的项目有多个应用程序，那么只检查活动应用程序中的对象。如果只有一个应用程序，那么也会检查公共POU池中的对象。

注意：

在默认的开发系统中，***XX***只包含一组简化的规则。在安装MetaFacture Static Analysisadd-on附加组件时，可以使用一组更大的规则、附加的命名约定和指标。

---

### 使用来自静态分析的pragmas停用实现中的代码行​

借助于pragma {analysis ...}，您可以标记代码，这样指定的规则就不会被检查。因此，标记的代码行不需要进行静态分析。标记的代码在检查期间被忽略。

语法：

{analysis |,}

-: 取消SA规则。

-: 激活SA规则。

  
**不包括实现代码**

要求：规则在***工程设置***对话框里激活。

1.在代码行上面添加pragma {analysis -}，其中包含的代码首先不需要检查。例如，对于规则SA0024  
⇒这行代码是没有被规则24检查的代码片段的第一行。

2.在代码行下面添加pragma {analysis -}，其中包含的代码首先不需要检查。例如，对于规则SA0024  
⇒上面的代码行是代码片段中未被规则24检查的最后一行。

> 例如：忽略无类型的文字
> 
>   
> {analysis -24}  
> nTest := 99;  
> iVar := INT#2;  
> {analysis +24}
> 
>    
> 规则***SA0024: 无类型字面值***被停用了两行。虽然代码没有正确到: nTest := DINT#99;

> 例如：忽略几个规则
> 
>   
> {analysis -10, -24, -18}  
> ...  
> {analysis +10, +24, +18}  
>    
> ***SA0010: 只有一个组件的数组***
> 
> ***SA0018: 不寻常的一些访问***
> 
> ***SA0024: 只是未知类型的字面值***
> 
> 但是，您不能禁用规则SA0004：使用pragma对输出进行多写访问。

---

### 从静态分析中排除使用杂注的编程对象

​语法：

{attribute 'analysis' := '-\[,\]'}

在编程对象的声明部分插入属性pragma时，整个编程对象将排除指定的规则。如果排除了多个规则，则每个规则由逗号和数字分隔。激活不需要pragma语句。

> 例如
> 
>   
> {attribute 'analysis' := '-33, -31'}  
> TYPE LocalData :   
> STRUCT  
>  iLocal : INT;  
>  uiLocal : UINT;  
>  udiLocal : UDINT;  
> END\_STRUCT  
> END\_TYPE
> 
>    
> 对于结构LocalData，将忽略SA0033和SA0031规则。
> 
>   
> {attribute 'analysis' := '-100'}  
> big: ARRAY\[1..10000\] OF DWORD;  
>    
> 对于较大的数组，则忽略SA0100规则。