通常，重构是一种改进现有软件代码设计而不改变其工作方式的技术。

在MetaFacture中，重构为重命名对象和变量以及更新引用的插脚提供了功能。您可以显示所有已重命名的对象和变量，然后一次或单独重命名它们。在***工具 ➔ 选项***中，您还可以配置哪里MetaFacture将提示您进行重构。

---

### 全局变量重命名​

要求; 打开的项目至少包含一个功能块***FB***和一个全局变量列表。全局变量列表***GVL***在编辑器中打开，并包含一个变量声明(例如:iGlobal)。***FB***使用iGlobal.

  
**在整个项目中重命名全局变量**

1.选择变量名为iGlobal的全局变量。

2.右键单击该变量并单击***重构 ➔ 重命名iGlobal***。

3.在重命名对话框中，在***新的名称***输入字段中输入一个名称，例如iGlobalOK，然后单击***确定***。  
⇒打开***重构***对话框。在左侧的设备树视图中，***GVL***和***FB***对象以红色和黄色突出显示。在右侧的视图中，***FB***在其编辑器中是打开的，并且iGlobal已经被重命名为iGlobalOK。

4.点击***确定***。

5.⇒在您的项目中再没有全局变量iGlobal。现在iGlobalOK全部替换。

  
  
**在整个项目中重命名全局变量(POU除外)**

1.选择变量名为iGlobal的全局变量。

2.右键单击该变量并单击***重构 ➔ 重命名iGlobal***。

3.在***重命名***对话框中，在***新的名称***输入字段中输入一个名称，例如iGlobalTest，然后单击***确定***。  
⇒打开***重构***对话框。在左侧的设备树视图中，***GVL***和***FB***对象以红色和黄色突出显示。在右侧的窗口中，函数块***FB*** 在其编辑器中打开。iGlobalTest列出来替换了iGlobal。

4.右键单击右侧视图。

5.单击***拒绝此对象***，然后单击***确定***。  
⇒全局变量iGlobal在项目中的FB中可用。变量iGlobalTest现在在前一个变量所在的对象中指定。  
   
消息视图中的错误消息报告没有定义iGlobal标识符。

---

### 添加和删除输入变量​

在块的声明部分，您可以使用重构命令添加和删除输入和输出变量。MetaFacture在块的发生位置和调用位置执行更新。您可以单独接受或拒绝这些更新。***重构***对话框也会为此打开。

要求：在编辑器中打开FCT(函数类型)POU。该函数已经包含了输入变量input1、input2和inputx。它们在PLC\_PRG和POU程序中被调用。

  
1.在FCT函数的声明部分设置焦点。

2.点***击重构 ➔ 添加变量***。⇒将打开用于声明变量的默认对话框。

3.使用VAR\_INPUT和数据类型INT声明变量input\_3。点击***确定***并关闭对话框⇒***重构***对话框打开(参见下图)。受影响的位置用黄色标记。(1)+(2)

4.在右上角，从下拉列表中选择***使用占位符文本添加输入***。(3)。

5.在窗口的左侧，单击突出显示的对象之一(例如，PLC\_PRG)。右键单击并选择***接受全部工程***命令，在FCT中用于整个项目的新位置添加新变量。  
⇒在右侧的视图中可以看到PLC\_PRG实现部分的变化: 占位符\_REFACTOR\_出现在添加新变量的位置。

6.点击***确定***并关闭***重构***对话框。

7.点击***编辑 ➔ 查找***。在项目中搜索“\_REFACTOR\_”以检查和编辑受影响的位置。

8.注意：作为一种替代方法，您可以使用另一个初始化值插入新变量，而无需首先使用占位符。在本例中，在步骤4中选择“使用以下值添加输入”，并在下拉列表右侧的字段中键入值。

![](https://resource.helplook.net/docker_production/3648ne/article/AAt6sBGi/6721a978608aa.png)

一个新变量的例子与占位符文本在一个CFC块:

![](https://resource.helplook.net/docker_production/3648ne/article/AAt6sBGi/6721a98eb5317.png)

请注意，您还可以通过重构删除变量。

---

### 重新排序声明中的变量​

在函数块的声明部分中，可以通过重构来更改声明的顺序，对于具有作用域VAR\_INPUT、VAR\_OUTPUT或VAR\_IN\_OUT的声明，可以更改此顺序。

要求; POU的声明部分是开放的，包括声明，例如:

  
VAR\_INPUT  
 invar2 : INT;  
 invar1 : INT;  
 in : DUT;  
 bvar : BOOL;  
 invar3 : INT;  
END\_VAR

   
  
1.右击此声明块以访问右键菜单。

2.点击***重构 ➔ 重命名变量***。  
⇒***重命名***对话框将打开，其中有一个VAR\_INPUT变量列表。

3.拖拽变量***invar1 : INT***;进入***invar2***之前的位置条目。  
⇒invar1声明现在位于顶部。

4.点击***确定***并关闭对话框。  
⇒打开***重构***对话框。受影响的位置用黄色标记(见上图)。

5.单击***确定***接受功能块的新命令。

---

### 更改变量声明并自动应用重构​

重构可以帮助您在重命名变量时进行声明(通过“自动声明”的方式)。

  
要求; 功能块fb\_A。

1.点击***工具 ➔ 选项***。  
⇒打开***选项***对话框。

2.选择***重构***类别。

3.在***自动声明***中，激活***重命名变量、添加或删除变量或更改命名空间***的选项。

4.双击功能块fb\_A。

5.在fb\_A声明中选择一个变量，例如iA。另一种方法是，您可以在变量之前或在变量中设置光标。

6.指定***编辑 ➔ 声明变量(\[ Shift \] +\[ F2 \] )***。  
⇒***声明变量***对话框打开。对话框中包含了iA的设置。

7.将iA的名称更改为iCounter\_A。

8.***通过重构改变***的选项出现并被激活

9.点击***确定***。  
⇒将打开***重构***对话框***从iA重命名为iCounterA***。所有受变量重命名影响的位置都标记在那里。

10.点击***确定***并关闭对话框。⇒应用更改。