功能块的扩展基于面向对象编程中的继承概念。扩展功能块由此扩展了基础功能块，并且在这样做时除了基础功能块自身的属性外，还赋予了基本功能块属性。

功能块的扩展意味着：

- 继承功能块包含基本功能块定义的所有数据和方法。您可以在MetaFacture每个需要基本功能块类型的功能块程序中使用基础功能块的实例。
- 扩展功能块可以覆盖您在基础功能块中定义的方法。这意味着继承的功能块可以定义与基本功能块所定义的名称，输入和输出相同的方法。  
    技巧：覆盖基础功能块继承的方法，操作，属性和转换时，具有以下支持：在继承的块下面插入方法，操作等时，***添加对象***对话框将包含一个组合框，其中包含在基础块中使用的方法，操作等的列表。您可以使用这些并进行相应调整。
- 扩展功能块可能不包含名称与基本功能块相同的功能块变量。编译器将此报告为错误。  
    唯一的例外：如果已在基础功能块中将变量声明为VAR\_TEMP，则继承的功能块可以定义一个具有相同名称的变量。在这种情况下，继承的功能块将无法再访问基本功能块的变量。
- 您可以使用SUPER指针在继承的函数块范围内直接寻址基本函数块的变量和方法。

---

### 通过新功能块扩展基本功能块​

要求：当前打开的项目具有一个基本功能块，例如***POU\_1（FB）***，该功能块将由新的功能块扩展。

  
1.右键单击设备树中的***Application***对象，然后选择***工程 ➔ 添加对象 ➔ POU***。  
⇒将打开***添加POU***对话框。

2.在***名称***输入部分中输入新POU的名称，例如***POU\_Ex***。

3.选择***功能块***。

4.点击***扩展***，然后点击更多按钮（![](https://resource.helplook.net/docker_production/3648ne/article/ufFD5UHc/6721dfee4da77.png)）。

5.在输入助手中***Application***下的***功能块***类别中，选择要用作基础功能块的POU（FB），例如POU\_1，然后单击***确定***。

6.另外，您可以从下拉列表中为新功能块选择一个***访问修饰符***。

7.从***实现语言***组合框中选择（例如：***编程结构化文本（ST）***

8.单击***添加***。  
⇒MetaFacture在设备树中添加一个POU\_Ex，同时在编辑器中被打开。第一行包含以下文本：  
   
FUNCTION\_BLOCK POU\_Ex EXTENDS POU\_1  
   
功能块POU\_Ex扩展了基本功能块POU\_1。

---

### 通过新功能块扩展基本功能块

要求：打开的工程具有一个基本功能块（例如：POU\_1(FB)和另一个功能块（示例： POU\_Ex(FB)）。功能块POU\_Ex（FB）也应具有基本功能块的属性。这意味着POU\_Ex（FB）应该扩展POU\_1（FB）。

  
1.在设备树中双击功能块POU\_Ex（FB）。  
⇒将打开功能块编辑器。

2.将第一行FUNCTION\_BLOCK POU\_Ex中的现有条目扩展为EXTENDS POU\_1。  
⇒功能块POU\_Ex扩展了基本功能块POU\_1。