实现接口基于面向对象编程的概念。使用通用接口，可以以相同方式，使用不同但相似的功能块。

实现接口的功能块必须包括该接口中定义的所有方法和属性（接口方法和接口属性）。这意味着名称或方法或属性的输入和输出必须完全相同。当创建实现接口的新功能块时，MetaFacture将接口的所有方法和属性自动添加到新功能块下方的树中。

提示！

如果之后添加更多接口方法，MetaFacture则不会自动将这些方法添加到受影响的功能块中。要执行此更新，必须明确的执行***实现接口***命令。

对于继承的功能块，必须确保通过接口的继承来派生的任何方法或属性也将获得适当的实现。另外，应该使用基础中提供的实现，否则应将其删除。显示相应的编译错误消息或报警，并通过添加的编译指示属性自动提示。有关更多信息，请参阅实现接口命令的帮助页面。  
   
提示！

- 必须先将功能块的接口分配给接口类型的变量，然后才能通过该变量调用方法。
- 接口类型的变量总是指定的函数块实例的引用。

> 例
> 
> I1接口包含GetName方法。
> 
> 方法GetName：STRING
> 
>    
> 功能块A和B实现接口I1：
> 
> FUNCTION\_BLOCK A IMPLEMENTS I1  
> FUNCTION\_BLOCK B IMPLEMENTS I1  
>    
> 因此，两个功能块都必须包含一个名为GetName的方法和返回类型STRING。否则，编译器将报告错误。
> 
> 函数包含接口I1类型变量的声明。
> 
> FUNCTION DeliverName : STRING  
> VAR\_INPUT  
>  l\_i : I1;  
> END\_VAR  
>    
>    
> 可以将实现I1接口的功能块分配给这些输入变量。
> 
> 函数调用举例：
> 
> DeliverName(l\_i := A\_instance); // 使用类型A的实例调用  
> DeliverName(l\_i := B\_instance); // 使用类型B的实例调用
> 
>    
> 调用接口方法：
> 
> 在这种情况下，应用程序调用A.GetName还是B.GetName取决于l\_i的实际类型。
> 
> DeliverName := l\_i.GetName();

###  

---

### 在新功能块中实现接口​

要求：打开的项目至少具有一个接口对象。

1.右键单击设备树中的***Application***对象，然后选择***工程 ➔ 添加对象 ➔ POU***。  
⇒将打开***添加动作***对话框。

2.在***名称***输入部分中输入新POU的名称，例如***POU\_Ex***。

3.选择***功能块***。

4.点击***实现***，然后点击更多按钮（![](https://resource.helplook.net/docker_production/3648ne/article/72g8GBbX/6721e12984518.png)）。

5.在输入助手中，从类别接口中选择***界面***，例如ITF1，然后单击***确定***。

6.要插入更多接口，请单击![](https://resource.helplook.net/docker_production/3648ne/article/72g8GBbX/6721e12b002be.png)并选择另一个接口。

7.作为一种选择，您可以从下拉列表中为新功能块选择一个***访问说明符***。

8.从***实现语言***组合框中选择（例如：***编程结构化文本（ST）***

9.单击***打开***。  
⇒MetaFacture在设备树中添加一个***POU\_Ex***，同时在编辑器中被打开。第一行包含以下文本：  
 FUNCTION\_BLOCK POU\_Im IMPLEMENTS ITF1  
 现在将接口及其方法和属性插入设备树中功能块的下方。现在，您可以在接口及其方法的实现部分中键入程序代码。

---

### 在新功能块中实现接口​

要求：当前打开的工程具有一个功能块（例如：***POU\_Im***）和至少一个接口对象（例如：***ITF1***）。

1.在设备树中双击功能块***POU\_Ex（FB）***。  
⇒编辑器被打开。

2.将第一行FUNCTION\_BLOCK POU\_Ex中的现有条目扩展为EXTENDS ITF1  
⇒***POU\_Im***功能块实现***ITF1***接口。