**在你开始之前​**
-----------

  
***数据安全***：为了最大程度地降低数据安全漏洞的风险，我们建议采取以下组织措施和技术措施：

避免从开放网络和互联网访问可编程逻辑控制器和控制网络。  
使用VPN进行远程访问。  
安装防火墙。  
如果要在网络上发布可视化信息，请设置密码以防止未经授权的访问。  
使用最新版本的网关服务器和Web服务器。

***安装MetaFacture***

注意：安装包括开发系统和MetaFacture网关和MetaFacture Control Win V3，它们的服务可以在Windows任务栏中访问。为了在计算机上模拟控制器，这三个程序是必需的。

---

第一个工程的内容​
---------

在本教程中，您将编写一个简单的冰箱控制器。已经完成的工程RefrigeratorControl.project\_archive可以在 MetaFacture的工程目录中找到安装目录。除了您将在这里逐步创建的示例工程之外，完成的工程还包含一个完整的可视化操作和诊断。

与传统的冰箱一样，温度由用户通过旋转控制来指定。  
冰箱使用传感器确定实际温度。当它太高时，冰箱以可调节的延迟启动压缩机。  
压缩机冷却，直到达到预期的温度，减去一个1度的滞后。滞后是为了防止实际温度在设定的温度附近波动过大，这将导致压缩机不断关闭和打开。  
当门打开时，冰箱内部的灯点亮。当门开得太久时，会发出哔哔声信号。  
如果压缩机在很长一段时间内没有达到设定的温度，尽管电机一直在工作，蜂鸣器仍会发出稳定的声音信号。

  
工程：

冷却控制在应用程序的主程序中。信号管理在另一个POU中进行控制。在Standard库中提供了所需的标准功能块。 由于在这个示例工程中没有物理温度传感器和物理执行器连接，您还将编写一个程序来模拟温度的升高和降低。 这将允许您在联机模式下监视冰箱控制器的操作。

所有POU使用的变量都需要在全局变量列表中定义。

---

**准备工作​**
---------

您已经安装了MetaFacture Development System并使用默认配置文件“MetaFactureV”启动它。将使用标准菜单栏打开开发系统的框架窗口：尚未打开任何工程。

### 创建工程并选择PLC设备​

1.单击***文件*** ➔ ***新工程***。

  
2.在***模板***视图中，选择***标准工程模板***。

  
3.指定工程的名称和存储位置并且单击***确定***⇒打开***标准工程***对话框，用于输入设备类型和主程序的实现语言。

  
4.在***设备***列表框中，选择***MetaFacture Control Win V3***。

  
5.在***PLC\_PRG***列表框中，选择***连续功能图 (CFC)***并且单击***确定***。⇒工程在MetaFacture框架窗口中打开。

在框架窗口的左侧，在***设备***视图中，您将会看到设备树的***(设备视图)***。之前选择的PLC设备以默认名称***设备***显示。

对于将要编程的应用程序的***Application***对象，已经存在于 ***PLC Logic***对象下。

***Application*** 已经包含主程序PLC\_PRG和 ***库管理器对象***。

***库管理器***已经包含库IoStandard和Standard。库IoStandard是I/O配置所必须的。库Standard包含IEC61131-3标准描述的所有函数和功能块。

***任务配置***对象位于具有MainTask的设备树的底部，该对象控制PLC\_PRG的处理。例如，可以稍后将可视化对象插入***任务配置***下面。

除了库IoStandard和Standard之外，您还需要这个示例项目的库Util：

  
1.在设备树中双击***库管理器***对象。⇒库管理器在其编辑器中打开。

  
2.在编辑器的标题栏中，单击***添加库***。 在***添加库***对话框中，选择库Util。  
单击***确定***确认选择。⇒库Util添加到库管理器中，且库中的POUs可在工程中使用。

---

要在工程中对控件应用程序进行编程，请参见以下部分
------------------------

### 声明全局变量​

首先，声明要在整个应用程序中使用的变量。为此，请在***应用***下面创建全局变量列表：

  
1.选择Application然后在右键菜单中单击***添加对象*** ➔ ***全局变量列表***。将默认名称GVL更改为Glob\_Var并且单击***添加***进行确认。  
⇒![](https://resource.helplook.net/docker_production/3648ne/article/lrAhjXtU/671b0f16424a1.png)Glob\_Var对象出现在![](https://resource.helplook.net/docker_production/3648ne/article/lrAhjXtU/671b0f1d35435.png)Application之下。GVL编辑器将在设备树的右侧打开。

  
2.当文本视图打开时，它已经包含关键字VAR\_GLOBAL和END\_VAR。对于我们的示例，在编辑器的右侧栏中单击 ![](https://resource.helplook.net/docker_production/3648ne/article/lrAhjXtU/671b0efd1ad90.png)以激活表格视图⇒出现一个空行。光标在***名称***列中。

  
3.在右键菜单中，单击***插入***⇒打开一个输入字段。同时，***范围*** VAR\_GLOBAL以及***数据类型***BOOL被自动地输入到行中。

  
4.在***名称***字段中指定rTempActual。

  
5.双击***数据类型***栏的字段⇒现在可以编辑该字段并显示![](https://resource.helplook.net/docker_production/3648ne/article/lrAhjXtU/671b0f7a23e38.png)按钮。

  
6.单击![](https://resource.helplook.net/docker_production/3648ne/article/lrAhjXtU/671b0f7f81911.png)并选择***输入助手***⇒将打开***输入助手***对话框。

  
7.选择数据类型REAL并单击***确定***。

  
8.在初始化栏中输入一个数值（例如：8.0)。

以相同的方式声明以下变量：

| 名称 | 数据类型 | 初始化 | 注释 |
|:--|:--|:--|:--|
| rTempActual | REAL | 1.0 | 实际温度 |
| rTempSet | REAL | 8.0 | 设定温度 |
| xDoorOpen | BOOL | FALSE | 门的状态 |
| timAlarmThreshold | TIME | T#30S | 压缩机运行后的一段时间内，信号声响起。 |
| timDoorOpenThreshold | TIME | T#10S | 打开门一段时间后，信号声响起。 |
| xCompressor | BOOL | FALSE | 控制信号 |
| xSignal | BOOL | FALSE | 控制信号 |
| xLamp | BOOL | FALSE | 状态消息 |

---

### 在CFC编辑器中创建冷却控制的主程序​

现在，您将在默认情况下创建的主POUPLC\_PRG中描述应用程序的主要功能。当实际温度高于设定温度加上滞后时，压缩机被激活并冷却。当实际温度低于设定温度减去滞后时，压缩机关闭。

若要用CFC实现语言描述此功能，请执行以下步骤：

1.在设备树中双击PLC\_PRG⇒CFC编辑器在PLC\_PRG选项卡中打开。 声明编辑器以文本或表格形式显示在图形编辑器区域的上方。 ***工具箱***视图在右侧。

  
2.在***工具箱***视图中，选择***输入***元素并将其拖动到CFC编辑器中的某个点⇒无名条目???被插入。

  
3.在CFC编辑器中，单击???输入。然后单击![](https://resource.helplook.net/docker_production/3648ne/article/lrAhjXtU/671b106121059.png)以打开输入帮助。在***变量***类别中，在***应用*** ➔ ***Glob\_Var***下选择变量rTempActual。这就是在此处如何引用全局变量rTempActual⇒输入名称是Glob\_Var.rTempActual。

  
4.与第3步中一样，使用全局变量Glob\_Var.rTempSet的名称创建另一个输入。

  
5.创建另一个输入，然后单击???并将其替换为名称rHysteresis。⇒因为这不是已知变量的名称，所以将打开***Declare Variable*** 对话框。该名称已在对话框中使用。

  
6.在***声明变量***对话框中，将***数据类型***指定为REAL且***初始值***为1。单击***确定***⇒变量rHysteresis出现在声明编辑器中。

  
7.在***工具箱***视图中，选择***框***元素并将其拖动到CFC编辑器中的某个点⇒POU在CFC编辑器中打开。

  
8.将???替换为ADD⇒POU添加与其连接的所有输入。

  
9.将Glob\_Var.rTempSet输入连接到ADD POU。为此，请单击输入的输出引脚并将其拖动到ADDPOU的上方输入引脚。

  
10.以相同的方式，将输入rHysteresis连接到ADDPOU的下部输入⇒现在，ADD添加了两个输入rHysteresis和Glob\_Var.rTempSet。

  
11.若要在编辑器中移动元素，请单击元素中的空白区域或单击框架，以便选中该元素（红色边框、红色高亮）。 将元素拖动到所需位置。

  
12.在ADDPOU的右侧创建另一个POU。其目的是将Glob\_Var.rTempActual与Glob\_Var.rTempSet 和rHysteresis之和进行比较。将GT函数（大于）分配给POU⇒GTPOU工作方式如下：IF (upper input &gt; lower input) THEN output := TRUE;

  
13.将输入Glob\_Var.rTempActual连接到GTPOU的上部输入。

  
14.将输出Glob\_Var.rTempActual连接到GTPOU的下部输入。

  
15.现在，在GT POU的右侧创建一个功能块，根据输入条件（设置–重置）启动和停止冷却压缩机。在???字段中指定名称SR。按Enter键关闭POU(SR\_0)上方的打开的输入字段⇒***声明变量***对话框打开。

  
16.用名称SR\_0和数据类型SR声明变量。 单击***确定***⇒实例化了标准库中的SRPOU。SR用于在GT POU的输出处定义THEN。输入SET1和RESET将出现。

  
17.将GTPOU右侧的输出引脚连接到SR\_0POU的SET1输入端⇒SR可以将布尔变量从FALSE设置为TRUE，然后再次返回。当满足输入SET1的条件时，布尔变量将设置为TRUE。当满足RESET的条件时，变量将再次重置。我们示例中的布尔（全局）变量是Glob\_Var.xCompressor。

  
18.创建一个Output元素，并将其分配给全局变量Glob\_Var.xCompressor。在Glob\_Var.xCompressor和SR的输出引脚Q1之间拖动一条连接线。

  
现在指定压缩器应再次关闭的条件（在这种情况下，SR POU的RESET输入将获得TRUE信号）。为此，请制定与上述相反的条件。使用SUB（减）和LT（小于）POUs来执行此操作。

结果如下CFC图表：

![](https://resource.helplook.net/docker_production/3648ne/article/lrAhjXtU/671b14528a7eb.png)

---

### 在梯形图编辑器中创建用于信号管理的POU​

在另一个POU中，您现在将实现警报蜂鸣器以及开关灯的信号管理。梯形图（LD）实现语言适用于此。

在各自的网络中处理以下每个信号：

当压缩机因运行时间过长而温度过高时，会发出连续的声音信号。  
当门打开时间过长时，会发出间歇性信号。  
只要门是打开的，灯就一直亮着。

1.在设备树中Application下面，使用***Ladder Diagram (LD)***实现语言创建***Program***类型的POU对象。  
为程序指定名称Signals⇒Signals在PLC\_PRG旁边的设备树中列出。梯形图编辑器在Signals选项卡中打开。声明编辑器出现在上方，***工具箱***视图在右侧。 LD包含一个空网络。

  
2.在网络中创建一个程序，以便在压缩机运行时间过长而未达到温度设定点时发出声音信号。为此，插入一个TON计时器POU。仅在指定时间后，它将布尔信号切换为TRUE。在***ToolBox***视图的***功能块***下选择一个 TON，然后将其拖动到空网格和出现的***从此处开始***框。 当字段变为绿色时，释放鼠标按钮。  
⇒POU显示为一个包含输入和输出的框，并自动分配实例名TON\_0。 行编辑器打开，光标闪烁在那里。

  
3.按***\[ Enter \]*** 键⇒您已确认实例名称。声明变量对话框打开。

4.单击确定***确认***对话框⇒现在，插入的POUTON实例化为名称TON\_0。此外，默认情况下，顶部输入显示为POU之前的关联。

注意：要阅读功能块TON的帮助，请将光标放在“TON”字符串中的POU中/上，然后按***\[ F1 \]*** 。

  
5.现在您可以编程，以便在冷却压缩机开始运行时激活功能块。 为此，请在POUGlob\_Var.xCompressor的上部输入处命名关联。您已经在GVLGlob\_Var中声明了此布尔变量。

注意：当您开始在输入位置键入变量名称时，您会自动获得所有变量的列表，这些变量的名称以键入的字符开头，并且可以在此时使用。此帮助是MetaFacture选项中用于智能编码的默认设置。

  
6.插入要激活的信号。为此，将一个***线圈***从***梯形图元素***工具箱类别拖到TONPOU的输出Q上。指定线圈的名称Glob\_Var.xSignal。

  
7.定义从POUTON\_0激活到信号发出的时间段。此定义通过变量Glob\_Var.timAlarmThreshold进行，为此，您可以在TON\_0的输入PT插入该变量。 要执行此操作，请单击输入引脚右侧的细边框并输入变量名。

  
8.选择POUTON并且单击***删除上下文菜单中未使用的FB调用参数***⇒删除未使用的输出ET。

  
9.在LD的第二个网络中，当门开得太长时，程序使信号间歇地发出声音。

在编辑器窗口中，单击第一个网络下面。在上下文菜单中，单击***插入网络***⇒出现一个数字为2的空网络。

  
10.与第一个网络一样，实现一个POUTON用于信号的定时激活。这次是由输入IN上的全局变量Glob\_Var.xDoorOpen触发的。在输入PT处，添加全局变量Glob\_Var.timDoorOpenThreshold。

  
11.此外，从库Util，在该网络中POUTON的输出Q处添加一个POU BLINK并将其实例化为Blink\_0。

  
12.POUBLINK\_0为信号发送Q以及Glob\_Var.xSignal提供时钟。  
首先，将两个***Contact***元素从***工具箱***视图拖动到POU的OUT输出。在输出Q之后直接将变量TON\_1.Q分配给该触点，并将全局变量Glob\_Var.xDoorOpen分配给第二个触点。

  
13.在两个触点之后插入一个***线圈***元素，并为其分配全局变量Glob\_Var.xSignal。

  
14.为此，声明局部变量timSignalTime : TIME := T#1S;并在输入TIMELOW以及TIMEHIGH处插入此变量。对于TRUE，循环时间为1秒；对于FALSE，循环时间也为1秒。

  
15.选择POUTON并且单击***删除上下文菜单中未使用的FB调用参数***⇒删除未使用的输出ET。

  
16.在LD的第三个网络中，编程使得只要门是打开的灯就亮起来。 为此，插入另一个网络。在左侧的网络中，插入一个触点GlobVar.xDoorOpen，它直接指向插入的线圈Glob\_Var.xLamp。

  
17.MetaFacture对LD的网络进行连续处理。现在，在网络1的末尾安装一个跳转到网络3，以确保只执行网络1或网络2:  
通过单击网络或具有网络编号的字段来选择网络3。在右键菜单中，单击***插入标签***。用DoorIsOpen:替换网络左上角的文本Label:  
选择网络1。在***工具箱***视图的***公用***类别中，将***跳转***元素拖到网络中。将其放置在显示的***添加输出或跳转到此处***框中。  
⇒出现跳转元素。跳转目标仍指定为???。

  
18.选择???并且单击![](https://resource.helplook.net/docker_production/3648ne/article/lrAhjXtU/671b16a4a6c8b.png)从可能的标签标识符中选择DoorIsOpen，然后单击***确定***进行确认。  
⇒实现了网络3的标签。

LD程序现在如下所示：

![](https://resource.helplook.net/docker_production/3648ne/article/lrAhjXtU/671b16cd7eb84.png)

---

### 在主程序中调用Signals程序​

在我们的程序示例中，主程序PLC\_PRG应该调用Signals程序进行信号处理。

  
1.在设备树中，双击PLC\_PRG⇒PLC\_PRG程序在编辑器中打开。

  
2.在***工具箱***视图中，将***BOX***元素拖动到PLC\_PRG的编辑器中。

  
3.使用输入助手，将该POU从***POU调用*** 类别添加到Signals程序的调用中。

---

### 创建用于仿真的ST POU​

由于该示例工程中的应用程序未链接到物理传感器和执行器，因此您还需要编写一个用于模拟温度升高和降低的程序。这将允许您在联机模式下监视冰箱控制器的操作。

您可以使用结构化文本创建模拟程序。

程序将升高温度，直到主程序PLC\_PRG确定已超过设定温度。然后程序启动冷却压缩机。然后，模拟程序降低温度，直到主程序再次停用压缩机。

  
1.在应用程序下面，在ST实现语言中插入一个POU类型的程序。指定仿真的名称。  
2.在ST编辑器中实现以下代码：

> PROGRAM Simulation  
> VAR  
>  TON\_1: TON; //当压缩机被激活时，温度会延时下降  
>  P\_Cooling: IME:=T#500MS;   
>  xReduceTemp: BOOL; //降温信号   
>  TON\_2: TON; //当压缩机启动时，温度会随着时间延迟而升高   
>  P\_Environment: TIME:=T#2S; //关门的延迟时间  
>  P\_EnvironmentDoorOpen: TIME:=T#1S; //开门延时时间   
>  xRaiseTemp: BOOL; //温度升高信号  
>  timTemp: TIME; //延迟时间  
>  iCounter: INT;  
> END\_VAR
> 
> iCounter := iCounter + 1; // 没有功能，仅用于演示目的。
> 
> // 在压缩机因温度过高而启动后,温度降低。  
> // 延迟P\_Cooling后，每个周期温度降低0.1°C  
> IF Glob\_VAR.xCompressor THEN  
>  TON\_1(IN:= Glob\_Var.xCompressor, PT:= P\_Cooling, Q=&gt;xReduceTemp);  
>  IF xReduceTemp THEN  
>  Glob\_Var.rTempActual := Glob\_Var.rTempActual-0.1;  
>  TON\_1(IN:=FALSE);  
>  END\_IF  
> END\_IF
> 
> //如果门是开着的，升温会更快；SEL 选择 P\_EnvironmentDoorOpen  
> timTemp:=SEL(Glob\_Var.xDoorOpen, P\_Environment, P\_EnvironmentDoorOpen);
> 
> //如果压缩机未运行，则冷却室会变热。  
> //延迟tTemp后，每个周期温度升高0.1°C  
> TON\_2(IN:= TRUE, PT:= timTemp, Q=&gt;xRaiseTemp);   
> IF xRaiseTemp THEN  
>  Glob\_Var.rTempActual := Glob\_Var.rTempActual + 0.1;  
>  TON\_2(IN:=FALSE);  
> END\_IF

注意：我们建议您使用可视化来方便操作和监视整个控制程序。 使用MetaFacture创建的可视化将安装在本教程的完整示例工程中，该工程随标准MetaFacture Visualization可视化安装（工程目录提供。您可以将该工程下载到控制器，然后启动它以查看它与可视化文件一起工作。启动时，Live\_Visu以冰箱的表示形式开始，该表示形式无需输入任何数据即可复制模拟程序的操作。但是，可以通过单击开/关来打开和关闭门。 可以通过旋转控制的指针调整默认温度。 在本教程中，我们将不介绍可视化的创建。在MetaFacture Visualization可视化帮助中计划了相应的教程。

---

### 定义任务配置中要执行的程序​

默认任务配置包含对主程序PLC\_PRG的调用。对于我们的示例工程，您还需要添加对Simulation程序的调用。

  
1.在设备树中，将Simulation拖到***Task Configuration***下的MainTask⇒将Simulation程序插入到任务配置中。

  
2.要查看任务配置，请双击MainTask条目以打开编辑器⇒在编辑器下部的表中，您可以看到任务调用的POU：PLC\_PRG(默认输入)和Simulation。任务的调用类型为***Cyclic***，间隔为20毫秒。在联机模式下，任务将在每个周期一次执行两个POUs。

---

### 定义与PLC通信的"活动应用" ​

Application的名称在***设备***视图中以粗体显示。 这意味着该应用程序被设置为“活动应用”。然后，与控制器的通信将引用此应用程序。

当一个项目中只有一个应用程序时，它将自动成为主动应用。如果您的应用程序尚未激活，请按以下方式激活它：

在Application的右键菜单中，单击***设置主动应用***⇒***应用***现在以粗体显示在***设备***视图中。

---

### 调试应用程序​

当您输入代码时，MetaFacture会立即通过在相关文本下面的红色波浪下划线提醒您出现语法错误。 按\[ F11 \] 检查整个应用程序的语法。检查结果显示在消息视图中。如有必要，请单击视图 ➔ 消息以打开消息视图。然后您可以选择一条消息并按\[ F4 \] 键跳到代码中的相应点。

之后，仅将无错误应用程序下载到控制器。

---

要建立与PLC的连接，请参阅以下部分： ​
---------------------

### 启动网关服务器和PLC​

***小心：检查控制器的可访问性***

出于安全原因,在任何情况下都不应从因特网或不受信任的网络访问控制器! 特别是,TCP/IP编程端口(通常为 UDP-Ports 1740..1743和TCP-Ports 1217 + 11740或控制器特定的端口)不应在没有保护的情况下从因特网访问。如果需要因特网访问控制器,使用一个安全的机制是绝对必要的,如VPN和密码保护的控制器.

  
启动网关服务器：

程序GatewaySysTray作为MetaFacture的标准安装。 您可以通过此程序与网关服务器通信。 当系统启动时，网关服务器作为服务自动启动。 检查Windows任务栏是否包含程序图标![](https://resource.helplook.net/docker_production/3648ne/article/lrAhjXtU/671b2963c2c21.png) 。 当网关服务器未运行时，图标如下：![](https://resource.helplook.net/docker_production/3648ne/article/lrAhjXtU/671b29695a03d.png) 。在这种情况下，可以单击图标打开网关菜单，然后单击***启动网关***。

启动PLC:

程序MetaFactureControlSysTray默认与MetaFacture一起安装。您可以通过此程序与MetaFacture控制服务通信。

在MetaFactureV1.0sp2及更高版本中，控制服务在启动系统时不再自动启动。这是为了防止未经授权的访问。 按如下方式启动

PLC: 在Windows任务栏中，单击![](https://resource.helplook.net/docker_production/3648ne/article/lrAhjXtU/671b2a646ce7f.png)打开PLC菜单。 然后单击***Start PLC***。如果PLC正在运行，则图标变为![](https://resource.helplook.net/docker_production/3648ne/article/lrAhjXtU/671b2a74b5750.png)。启动时出现的对话框表明启动的PLC允许编程访问。请注意上面的安全提示。

---

### 在第一个通信配置中：添加网关​

在***设备***视图中，双击设备Device(MetaFacture Control Win V3)⇒***通讯设置***选项卡将在Device中打开。

如果这是您与MetaFacture V3的第一个***通信配置***，那么现在需要定义本地网关服务器。 如果已经定义了网关服务器，则它将显示在通讯设置选项卡上。 在这种情况下，您现在可以继续“ ***定义通信通道”***。

网关服务器随MetaFacture安装一起提供。

1.单击***网关*** ➔ ***添加新网关***⇒***网关***对话框打开。

![](https://resource.helplook.net/docker_production/3648ne/article/lrAhjXtU/671b2af36ae7a.png)

2.在***名称***输入字段中，指定网关的符号名称。

  
3.在***设备***列表框中，选择***TCP/IP***。

  
4.双击***IP地址行***的右列，并在输入字段中指定localhost。

  
5.单击***确定***⇒网关在设备编辑器的***通信设置***选项卡（1）上输入。 当网关正常运行时，网关图形上会出现一个填充的绿色圆圈：

![](https://resource.helplook.net/docker_production/3648ne/article/lrAhjXtU/671b2b518788e.png)

---

### 定义通信通道​

现在定义设备的通信通道，然后通过您设置的网关使用。 为此，双击设备树中的***设备***以打开设备编辑器的***通信设置***选项卡。

1.单击***扫描网络***以在本地网络中搜索所有可用设备。⇒此时会出现***选择设备***对话框（1），其中列出了可以与之建立连接的所有设备。  
  
![](https://resource.helplook.net/docker_production/3648ne/article/lrAhjXtU/671b2b9ec1f66.png)  
   
2.选择具有你的计算机名称的条目。

  
3.单击***确定***⇒现在，该通道处于活动状态，并且相关信息显示在***通讯设置***选项卡上的设备图形下方。

现在，所有通信操作都完全指向此通道。如果工程中有多个通信通道，请稍后记住这一点。

---

对于PLC上的应用，请参见以下部分：​
-------------------

###  

### 将应用程序下载到PLC ​

要求：该应用程序已编译，没有错误。参见" 调试应用程序"。

1.单击***在线*** ➔ ***登录***⇒将打开一个对话框提示，询问是否应将应用程序下载到控制器。

  
2.单击***确定***⇒应用程序被下载到控制器。 在设备视图中的控制器和应用程序条目以绿色突出显示。 停止出现在应用对象之后。 控制器的当前状态显示在任务栏中 ![](https://resource.helplook.net/docker_production/3648ne/article/lrAhjXtU/671b2c330cadb.png)。

---

### 启动应用程序

如果您一直严格遵循本教程，那么您可以在PLC设备***(MetaFacture Control Win V3)***上使用该***应用***。

1.在***设备***视图中，在***应用***对象的右键菜单中，单击***开始***⇒程序开始运行。在***设备***视图中的控制器和应用程序条目以绿色突出显示。运行出现在***应用***对象之后。控制器的当前状态显示在任务栏中：![](https://resource.helplook.net/docker_production/3648ne/article/lrAhjXtU/671b2c897a164.png) 。

---

### 在运行时监视和一次性写入变量值​

在以下部分中，您可以查看各个POUs中变量值的“监视”，并且只能一次从 MetaFacture在控制器上设置特定的变量值。

您可以在POU编辑器的联机视图或监视列表中看到应用程序变量的实际值。 在这里的示例中，我们将重点关注POU编辑器中的监视。

要求：应用程序正在控制器上运行。

1.在设备树中，双击对象PLC\_PRG,Signals,Simulation,和Glob\_Var 以打开编辑器的在线视图。  
⇒在每个视图的声明部分，控制器上变量（1）的实际值出现在***Value***列（3）的表达式表中（见图）。

![](https://resource.helplook.net/docker_production/3648ne/article/lrAhjXtU/671b2cd463e69.png)

实现部分的监视取决于实现语言。 对于非布尔变量，该值始终位于标识符右侧的矩形字段中。 在ST编辑器中，这也适用于布尔变量。我们将此显示称为“在线监控”。在图形编辑器中，布尔变量的值由输出连接线的颜色显示（黑色表示FALSE ，蓝色表示TRUE）：

![](https://resource.helplook.net/docker_production/3648ne/article/lrAhjXtU/671b2ce571b6e.png)

2.观察变量值在不同POU中的变化。 例如，您可以在GVLGlob\_Var中看到由于仿真程序的处理，rTempActual和xCompressor的值是如何变化的。

  
控制器上变量值的一次性设置：

1.在GVLGlob\_Var的在线视图中设置焦点。

  
2.若要设置新的指定值，请双击表达式rTempSet旁边的***Prepared Value***列（2）。  
⇒打开一个输入字段。

  
3.指定值9并退出输入字段。

  
4.若要指定打开的门，请在表达式xDoorOpen旁边的***准备值***字段中单击一次。指定值为TRUE。再单击三次，可以在TRUE, FALSE, 和空白之间切换准备值。

  
5.要将准备值TRUE仅一次写入变量，请按***\[ Ctrl \] +\[ F7 \]*** 。⇒这两个值分别传输到***Value列***（3）。现在，变量xDoorOpen不再更改其值，设置温度为9度。 变量timTemp更改为值1s ，因为现在冰箱门已“打开”，并且由于Simulation导致的加热应比以前快(2s)。

---

### 在运行时设置断点和单步执行

调试：为了排除故障，您需要检查代码中某些点的变量值。 您可以为执行定义断点，并启动语句的逐步执行。

要求：该应用程序已下载到控制器并正在运行。

  
1.双击Simulation以在编辑器中打开程序。

  
2.将光标放在代码行iCounter := iCoutner + 1; 中：然后按***\[ F9 \]*** 。⇒该符号![](https://resource.helplook.net/docker_production/3648ne/article/lrAhjXtU/671b2d92020be.png)显示在代码行之前。它表示在此行上设置了断点。 符号立即更改为![](https://resource.helplook.net/docker_production/3648ne/article/lrAhjXtU/671b2d9a347f4.png)。黄色箭头总是指向下一个要处理的语句。 ![](https://resource.helplook.net/docker_production/3648ne/article/lrAhjXtU/671b2da1f1678.png)出现在任务栏中，而不是 ![](https://resource.helplook.net/docker_production/3648ne/article/lrAhjXtU/671b2da6c75de.png)。

  
3.在内联监视或Simulation程序的声明部分中观察变量iCounter的值。  
⇒变量的值不在更改。进程在断点处停止。

  
4.按***\[ F5 \]*** 重新开始处理。⇒一个周期后，程序再次在断点处停止。iCounter增加了1。

  
5.按***\[ F8 \]*** 执行下一个处理步骤。⇒行末尾的***返回***iCounter := iCounter + 1;;语句用黄色突出显示。

  
6.再次按***\[ F8 \]*** 执行下一个处理步骤⇒进程跳到PLC\_PRG程序的编辑器。 反复按***\[ F8 \]*** 显示程序是如何逐步执行的。 要执行的语句每次都用黄色箭头再次标记。

  
7.要禁用断点并返回到正常处理，请将光标重新置于代码行中，然后按***\[ F9 \]*** 键。然后按***\[ F5 \]*** 键将应用程序设置为![](https://resource.helplook.net/docker_production/3648ne/article/lrAhjXtU/671b2e19ce5bb.png)模式。

---

### 在运行时执行一个周期​

要求：该应用程序已下载到控制器并正在运行。

  
1.如上所述在步进时，在Simulation程序中监视线iCounter := iCounter + 1;。

  
2.按***\[ Ctrl \] +\[ F5 \]*** 或者单击***调试*** ➔ ***单个周期***以运行单个周期。⇒进程将运行一个周期，并再次在断点处停止。iCounter的增量为1。

  
3.再按几次***\[ Ctrl \] +\[ F5 \]*** 键可以查看单个循环。然后再按***\[ F5 \]*** 。⇒程序将再次运行，而不会停止并且没有强制值。temp变量的值再次为1s。![](https://resource.helplook.net/docker_production/3648ne/article/lrAhjXtU/671b2e6403e3d.png)再次显示在状态栏中。