断点通常用于调试程序。MetaFacture支持所有IEC编辑器中的断点。

您可以在程序中的特定位置设置断点，以强制执行停止并监视变量值。您可以设置特殊的数据断点，以在特定变量的值更改时停止程序执行。

断点或数据断点处的暂停可以链接到其他条件。您也可以将断点和数据断点重新定义为执行特定代码的执行点，而不是停止程序。

注意：

***断点***视图提供了所有已定义断点的概览。它还包括用于处理对多个断点的批处理更改的其他命令。

在编辑器中，以下符号标识断点或执行点的状态：

- ![](https://resource.helplook.net/docker_production/3648ne/article/GYJcWcDk/67220a002ca8f.png)断点已启用
- ![](https://resource.helplook.net/docker_production/3648ne/article/GYJcWcDk/67220a03670c0.png)断点已禁用
- ![](https://resource.helplook.net/docker_production/3648ne/article/GYJcWcDk/67220a088ce48.png)断点设置在编辑器中打开的POU的另一个实例中。
- ![](https://resource.helplook.net/docker_production/3648ne/article/GYJcWcDk/67220a0d86bac.png)在断点处停止
- ![](https://resource.helplook.net/docker_production/3648ne/article/GYJcWcDk/67220a15d139e.png)启用条件断点
- ![](https://resource.helplook.net/docker_production/3648ne/article/GYJcWcDk/67220a3252177.png)禁用条件断点
- ![](https://resource.helplook.net/docker_production/3648ne/article/GYJcWcDk/67220a39bcd7a.png)执行点已启用
- ![](https://resource.helplook.net/docker_production/3648ne/article/GYJcWcDk/67220b10cc585.png)执行点已禁用
- ![](https://resource.helplook.net/docker_production/3648ne/article/GYJcWcDk/67220b17eb285.png)启用条件执行点
- ![](https://resource.helplook.net/docker_production/3648ne/article/GYJcWcDk/67220b1b68fb2.png)禁用条件执行点
- ![](https://resource.helplook.net/docker_production/3648ne/article/GYJcWcDk/67220b2461b38.png)数据断点已启用
- ![](https://resource.helplook.net/docker_production/3648ne/article/GYJcWcDk/67220b26dd1c8.png)数据断点已禁用
- ![](https://resource.helplook.net/docker_production/3648ne/article/GYJcWcDk/67220b3e15fb8.png)在数据断点处停止
- ![](https://resource.helplook.net/docker_production/3648ne/article/GYJcWcDk/67220b442eddb.png)启用数据执行点
- ![](https://resource.helplook.net/docker_production/3648ne/article/GYJcWcDk/67220b745c4e0.png)禁用数据执行点
- ![](https://resource.helplook.net/docker_production/3648ne/article/GYJcWcDk/67220b8086999.png)在数据执行点停止
- ![](https://resource.helplook.net/docker_production/3648ne/article/GYJcWcDk/67220b8408ccb.png)启用条件数据执行点
- ![](https://resource.helplook.net/docker_production/3648ne/article/GYJcWcDk/67220b8884aeb.png)启用条件数据断点

---

### 数据断点​​

当特定变量或内存地址的值更改时，程序在数据断点处停止执行。 与普通断点一样，可以将停止链接到其他条件，或者可以处理特定代码来代替停止（转换为数据执行点）。

您可以通过***调试***菜单中的***新建数据断点***命令或***断点***视图中的***新建***按钮来设置数据断点。您可以直接指定一个合格的变量名或一个内存地址，对其值的更改进行监视。

> **例如**
> 
> 在下面的示例代码中，变量iNumber的内存被无意覆盖。但是，变量iNumber的数据断点将检测其值何时更改。然后，处理在数组访问处以一条相应的消息停止，该消息将覆盖变量值：Idx = 7。另请参阅：“设置数据断点”。
> 
> PROGRAM PLC\_PRG  
> VAR  
>  Idx : INT;  
>  Ary : ARRAY\[0..3\] OF BYTE;  
>  iNumber : INT := 55;  
> END\_VAR  
> FOR idx := 0 TO 6 DO  
>  Ary\[idx\] := 0;  
> END\_FOR

---

### 具有多个任务的应用程序中的断点​

基本上，不可能同时对多个任务进行调试。使用断点或单步执行任务时，在其他任务中会忽略断点。

如果包含断点的块被多个任务使用，则只有调试任务会暂停，因为它首先到达断点。 所有其他任务继续。 ***调用堆栈***对话框显示当前暂停的任务。

如果只需要一个断点来影响一个特定任务，则可以在断点属性中定义该断点。

断点针对每个应用程序独立运行，因此“ HALT ON BP”不会影响任何其他应用程序。即使将断点设置在多个应用程序使用的块中，并且其代码在PLC上仅定位一次，这也适用于父/子应用程序。

**提示！**

即使您在PLC设置中选中了***停止时刷新I/O***复选框，调试任务所调用的I/O也不会在断点处暂停更新。

---

### 设置单个断点（ST编辑器中的示例） ​

要求：该应用程序处于在线模式并正在运行。操作模式为***调试***。

  
1.在编辑器中，打开以结构化文本（ST）编程的POU。

2.将光标放在将设置断点的行中。

3.单击***调试 ➔ 切换断点***或按***\[ F9 \]*** 。  
⇒该行用红色标记，并由“启用断点”符号(![](https://resource.helplook.net/docker_production/3648ne/article/GYJcWcDk/67220e424773d.png))标识。 如果程序在断点处暂停，则该行用“在断点处停止”符号(![](https://resource.helplook.net/docker_production/3648ne/article/GYJcWcDk/67220e4b18b88.png))标记。程序处理停止，并在状态行中以红色突出显示的HALT ON BP状态标识。

4.单击***调试 ➔ 开始***或按***\[ F5 \]*** 键。⇒该程序继续。

5.设置更多的断点，并检查中断位置的变量值。

6.将光标放在应该删除断点的行中。

7.单击***调试 ➔ 切换断点***或按***\[ F9 \]*** 。⇒标记消失。断点将被删除。

---

### 定义断点条件（ST编辑器中的示例）​

1.在编辑器中，打开以结构化文本（ST）编程的POU。

2.将光标放在将设置断点的行中。

3.单击***调试 ➔ 新断点***。⇒此时将打开***断点属性***对话框。

4.单击***条件***选项卡。

5.单击***中断当点击数是倍数***在***点击数***列表框中。  
在右侧的字段中输入值“ 5”。

6.此外，您可以为断点何时处于活动状态定义一个布尔条件。选中***中断，如果为真***复选框。在右侧的文本字段中输入一个布尔变量。

7.选择***立即启用断点***复选框。

8.关闭对话框。⇒该行用红色标记，并由“启用条件断点”符号(![](https://resource.helplook.net/docker_production/3648ne/article/GYJcWcDk/67220eebcd785.png))标识。  
监视正在运行的程序。只要条件的布尔变量为FALSE，就不会满足断点条件，程序将继续运行。如果将变量设置为TRUE，则条件将得到满足，并且程序每隔5次在断点处停止。

### 定义执行点（ST编辑器中的示例）​

1.在编辑器中，打开以结构化文本（ST）编程的POU。

2.将光标放在执行点的位置。

3.单击***调试 ➔ 新断点***.⇒此时将打开***断点属性***对话框。

4.单击***执行点设置***选项卡。

5.选择***执行点***复选框。  
在***执行以下代码***字段中，键入以下语句：iCounter：= iCounter + 1;  
在***在设备日志中打印消息***字段中，键入以下文本Execution point reached {iCounter}

6.关闭对话框。

  
当程序到达执行点时，它不会停止，而是执行上面定义的代码。 此外。将向设备日志发出消息。

### 设置数据断点

要求：该应用程序处于在线模式并正在运行。

  
1.单击***视图 ➔ 断点***。

2.单击***调试 ➔ 新数据断点***。

3.单击***新建断点***对话框（***数据***选项卡中的![](https://resource.helplook.net/docker_production/3648ne/article/GYJcWcDk/67220fb89e525.png)按钮。

4.在***输入助手***对话框（***监视变量***选项卡）中，选择更改后程序应暂停的变量。  
或者，直接在输入行的***数据***选项卡上指定变量的限定名称。例如：PLC\_PRG.iNumber。要监视的确切字节数指定为***大小***。 默认情况下，此处会自动设置与数据类型相对应的值。您还可以指定更少的要监视的字节。

5.在***断点***视图中，选择带有数据断点的行并单击![](https://resource.helplook.net/docker_production/3648ne/article/GYJcWcDk/67220fed482fb.png)按钮。  
⇒该行由“启用数据断点”符号（![](https://resource.helplook.net/docker_production/3648ne/article/GYJcWcDk/67220ff74c264.png)）标记和标识。当程序到达数据断点时（即所选变量的值更改时），程序处理将暂停。在POU的实现部分中，下一行由箭头![](https://resource.helplook.net/docker_production/3648ne/article/GYJcWcDk/672210034a7f7.png)标识。这在状态行中由以红色突出显示的HALT ON BP状态标识。

6.单击***调试*** ➔ 开始或按***\[ F5 \]*** 键。  
⇒当变量值再次改变时，程序继续运行并再次停止。