### 配置设备​

您可以将插入到设备树中的设备对象配置到相关的设备编辑器中。可能性取决于设备描述。“通用设备编辑器”提供了一个通过设备-标签必须添加的标签。

要求：您已经打开了一个标准项目，其设备树中有一个标准的PLC，其下插入了一个现场总线设备对象。

  
1.在你工程的设备树中双击标准PLC的设备对象。  
⇒编辑器出现在MetaFacture主窗口中。***通信设置***标签出现在前面。更改为其他选项卡，以便为控制器进行配置设置。请参阅通用设备编辑器的帮助页面。

2.双击项目的设备树中的现场总线设备对象。  
⇒编辑器出现在MetaFacture主窗口中。可以根据设备使用特定的选项卡。有关配置选项，请参阅相应设备编辑器的帮助页面。如果在***设备编辑器***类别的***工具 ➔ 选项***中选择了***显示通用设备配置视图***选项，则还请参阅通用设备编辑器提供的选项卡。

---

### 读取PLC参数文件进行配置​

如果另一个设备更改了PLC的配置参数，例如通过可视化，则使用配置文件IoConfig.par是在控制器上创建的。根据设备的不同，可以在设备编辑器的在线模式的参数对话框中设置一个按钮，以便将当前参数写入此类文件。为了更新工程中更改的参数，也可以在联机模式下读取参数文件。

要求：您有一个带有设备树的标准工程，其中硬件环境由设备树中的PLC和可参数化设备映射。控制器上有一个文件IoConfig.par，其中设备参数先前与当前值一起保存。

  
1.从***工具*** ➔ ***自定义***对话框中的接口菜单的***设备***类别”中添加的***读取PLC参数文件到配置***菜单。

2.在设备树中选择PLC设备对象，打开右键菜单。

3.点击读***取PLC参数文件到配置***⇒MetaFacture自动建立到控制器的连接，并从par-file中读取参数。这些在设备参数选项卡上相应地更新。

---

### 关于I/O映射的一般信息​

是否可以配置I/O映射到项目变量甚至整个功能块取决于设备的类型。配置I/O映射意味着将设备的输入和输出通道与项目的变量连接起来。我们也用“映射”这个术语。

一般而言，请注意以下内容，以便将设备的输入和输出映射到MetaFacture中的变量：

- 您没有对映射到输入的变量的写访问权。
- 您只能将现有变量映射到一个输入。
- 您可以直接在I/O映射中生成新的全局隐式变量，并将它们映射到设备通道。
- 结构的内存布局由设备指定。
- 您可以更改地址并修复I/O映射中的值。
- 对于***I/O映射***对话框中分配给I/O通道的每个变量，您可以在应用程序编译期间生成“强制变量”(参见下面的内容)。使用这些变量，例如在工厂调试期间，可以通过可视化/HMI强制输入或输出一个值。
- I/O映射中的更改可以通过在线更改转移到控制器。
- 如果使用指向设备输入的指针，则认为访问是写访问，例如pTest := ADR(input);。这将导致在生成代码时出现编译器警告："...invalid assignment target"。如果需要此类构造，则必须首先将输入值input到具有写访问权限的变量中。
- I/O地址也可以通过IEC代码中的“AT声明”与变量链接。然而，由于设备配置经常再次更改，我们建议您仅在设备编辑器中进行分配。  
    如果您使用AT声明，请注意以下事项: 
    - AT声明仅允许使用局部或全局变量，而不允许使用函数块的输入或输出变量。
    - 不能为AT声明生成I/Os的隐式“强制变量”(参见下面)。
    - 如果使用带有结构变量或函数块变量的AT声明，则所有实例将访问相同的内存位置。这就相当于在经典编程语言(如“C”)中使用“静态变量”。

**提示！**

如果使用指向设备输入的指针，则认为访问是写访问，例如pTest := ADR(input);。这将导致在生成代码时出现编译器警告："...invalid assignment target"。

如果需要此类构造，则必须首先将输入值（input）到具有写访问权限的变量中。

**注意：**

作为一种替代方法，您可以使用AT声明在编程代码中为地址分配一个变量。但是，考虑到设备配置可能发生的更改，我们建议您仅在设备编辑器中进行分配。

**注意：**

您可以将设备的I/O映射配置导出到csv文件，或者从这样的文件导入它。

---

### 将设备输入与现有的项目变量链接（“映射”）​

要求：在MetaFacture工程的设备树中插入一个支持I/O映射配置的设备。因此，在设备编辑器的I/O映射选项卡上，您可以得到设备的输入和输出通道的列表显示，其中指定了地址和数据类型。

1.例如，在一个POU中声明一个类型为BOOL的变量xBool4，您希望使用它从应用程序访问目标设备的输入。

2.要打开设备编辑器，双击设备树中的设备对象，然后单击***I/O映射***选项卡。

3.观察***变量***列，显示设备输入通道![](https://resource.helplook.net/docker_production/3648ne/article/Zv8vUyzD/672079ba1d363.png)和设备输出通道![](https://resource.helplook.net/docker_production/3648ne/article/Zv8vUyzD/672079ca5d72f.png)，根据设备仍然可以按组织节点![](https://resource.helplook.net/docker_production/3648ne/article/Zv8vUyzD/672079d6b8580.png)排序。我们假设有一个设备输入的类型是BYTE。它显示在BYTE节点下面的各个位地址(位通道)。

4.注意：当映射结构化变量时，编辑器会阻止你同时输入结构变量(例如: %QB0)及个别结构元素(例如: %QB0.1和QB0.2)。因此，如果在映射表中有一个主条目，其中包含一个子树状的位通道条目，则应用以下内容: 然后，可以将变量指定到主条目的行中，也可以指定到子元素(位通道)的行中，但不能同时指定到两个行中。  
现在，您可以使用具有适当类型的变量的整个通道，或者使用具有适当类型BOOL或BIT的变量的个别位通道地址。首先，双击***变量***列中的一个位输入通道⇒打开一个输入字段。

5.为了在通道上放置现有变量，必须输入所需的带完整路径工程变量。按下![](https://resource.helplook.net/docker_production/3648ne/article/Zv8vUyzD/67207a72c9bd5.png)以打开输入助手。例如，选择在PLC\_PRG中声明变量Application.PLC\_PRG.xBool4。  
⇒变量被插入。HMI符号(![](https://resource.helplook.net/docker_production/3648ne/article/Zv8vUyzD/67207a7d3a4c0.png) )显示在***映射***列中。这个地址现在已连接了。这并不意味着地址不再可用，因为现有变量的值是在另一个内存空间中管理的。但是:为了避免在写入值时产生歧义，您不应该使用其他变量占用地址，特别是在输出的情况下。  
   
注意：对于编译器版本V1.0SP11或更高版本，在映射到现有变量时，将自动使用变量的初始化值作为默认值。只有在映射到新创建的变量或没有指定映射时，才能编辑默认值字段。在较早的版本中，用户必须显式地指定***默认值***和初始化值相同。

![](https://resource.helplook.net/docker_production/3648ne/article/Zv8vUyzD/67207aa65ed31.png)

6.再次删除变量赋值。单击通道的根节点BYTE节点。再次使用输入助手选择变量Application.PLC\_PRG.byte\_gotodevice。  
⇒变量被插入，主通道的所有位地址都被遍历，您不应该额外占用它们。

![](https://resource.helplook.net/docker_production/3648ne/article/Zv8vUyzD/67207ac041a21.png)

---

### 将设备输入映射到最近创建的工程变量。​

在下面，您将把设备输出映射到全局隐式变量，该变量是您最近在***I/O映射***对话框中直接创建的。

**注意**：因此，I/O映射对话框是进一步声明全局变量的地方。

要求：在MetaFacture工程的设备树中插入一个支持I/O映射配置的设备。因此，在设备编辑器的***I/O映射***选项卡上，您可以得到设备的输入和输出通道的列表显示，其中指定了地址和数据类型。

  
1.要打开设备编辑器，双击设备树中的设备对象，然后单击***I/O映射***选项卡。

2.单击***变量***列中的通道条目上的映射表，以打开输入字段。

3.为一个新变量输入一个简单的名字（不能有“.”）（例如myBool）。  
⇒MetaFacture将该变量创建为项目中的隐式全局变量，并将其直接分配给通道地址。因此，在这种情况下，地址不会像在映射到现有变量![](https://resource.helplook.net/docker_production/3648ne/article/Zv8vUyzD/67207b73a1fbe.png)的情况下那样被删除。

![](https://resource.helplook.net/docker_production/3648ne/article/Zv8vUyzD/67207b5fcb8fa.png)

---

### 将设备与函数块实例链接​

如果设备支持，您可以将整个功能块映射到输入或输出通道。例如，这允许您计算信号变化的频率或为维护目的缩放通道值。

在这里，您将设备输出通道映射到一个函数块。在本例中，块缩放通道输出值。

要求：工程中链接了一个具有支持FB映射的数字输出设备。有一个带有以下实现的功能块***Scale\_Output\_Int***。函数块本身的属性和用于处理通道输出的输出参数之前的属性非常重要。

{attribute 'io\_function\_block'}  
FUNCTION\_BLOCK Scale\_Output\_Int  
VAR\_INPUT   
 iInput : INT;  
 iNumerator : INT;  
 iDenominator : INT :=1;  
 iOffset : INT := 0;  
END\_VAR  
VAR\_OUTPUT  
 {attribute 'io\_function\_block\_mapping'}  
 iOutput : INT;  
END\_VAR  
VAR  
END\_VAR  
IF iDenominator 0 THEN  
 iOutput := TO\_INT(TO\_DINT(iInput) \* TO\_DINT(iNumerator) / TO\_DINT(iDenominator)) + iOffset;  
   
  
1.打开设备编辑器的***I/O映射***标签。双击应该被连接到FB块的输出。点击![](https://resource.helplook.net/docker_production/3648ne/article/Zv8vUyzD/67207bd2c6273.png)给***IO添加通道添加FB***按钮。  
⇒打开***选择功能块***对话框。在左侧，至少可以看到***Application***节点下面的功能块***Scale\_Output\_int***。工程中链接的包含相应功能块的库也会显示出来供选择。

2.选择myScaleOutputIntPOU。  
⇒单击***确定***后，在映射对话框中输入***变量***中的功能块参数iOutput的路径。该路径包含应用程序名称、设备通道名称和选择的FB输出(例如: App1.Out\_4\_Int\_myScale\_Output\_Int\_1.iOutput)。

3.选择通道并点击![](https://resource.helplook.net/docker_production/3648ne/article/Zv8vUyzD/67207c3088d56.png)***Go to Instance***⇒焦点切换到 ***IEC Objects***选项卡和为新的IEC对象Out\_4\_Int\_myScale\_Output\_Int\_1创建的条目。在这个在线模式的视图中，您可以看到由FB缩放的通道Out\_4\_Int的参数iOutput的当前值。您还可以像在其他监控视图中那样编写和强制该值。

---

### 更改和固定I/O映射中的地址值​

您可以在***I/O映射***选项卡的映射表中更改整个通道的地址值(但不能更改通道的单个子元素的地址值!)这允许您根据指定的机器配置调整寻址，并保留地址值，即使模块的布局发生了变化。默认情况下，布局的改变会导致地址值的自动调整。

要求：您的工程有I/O映射。参见上面帮助页面的相应部分。

  
1.要打开设备编辑器，双击设备树中的设备对象，然后单击***I/O映射***选项卡。

2.单击***地址列***中的通道条目上的映射表，以打开输入字段。这只适用于通道的“根”地址，而不适用于它的特定子元素。  
因此，请更改表中某个通道的顶部地址条目，例如从QB0更改为QB1。退出输入字段。  
⇒地址值已更改。符号![](https://resource.helplook.net/docker_production/3648ne/article/Zv8vUyzD/67207c8952afc.png)显示在地址之前。它表示地址是固定的。通道的子元素的地址也随之改变。如果您现在更改设备对象在设备树中具有输入/输出通道的其他设备对象中的位置，则MetaFacture不会像不进行修复那样将这些地址调整为新顺序。  
   
![](https://resource.helplook.net/docker_production/3648ne/article/Zv8vUyzD/67207c98a747f.png)  
   
3.若要撤消手动更改或修复，请再次打开地址值的输入字段，删除地址项并按回车键。  
⇒MetaFacture将地址和相关的后续地址重置为它们在更改之前的值，并删除符号![](https://resource.helplook.net/docker_production/3648ne/article/Zv8vUyzD/67207d134a984.png)。

---

### I/O变量更新的配置​

根据您在项目中链接的设备，MetaFacture以不同的方式更新应用于其输入和输出的变量。您可以在***I/O映射***对话框中显式地更改此设置。

### 在联机模式下监视I/O映射中的变量​

要求：您已经编译了一个设备配置包含没有错误的I/O映射的应用程序。相关的硬件和总线系统正在运行。您已经通过***在线 ➔ 登录***命令连接到控制器，并且已经加载并启动了应用程序。

  
1.在设备编辑器中打开PLC的***I/O映射***选项卡。要打开编辑器，双击设备树中的设备对象⇒映射表现在还包含***当前值***和***新值***列。  
   
如果结构变量映射到地址1的“根”元素，MetaFacture则在在线模式下不会在该行中显示值。例如，如果一个DWORD变量被映射到这个地址，那么在“根”行和它下面缩进的位通道行中都将监视相应的值。  
   
原则上，如果值由几个子元素组成，那么“根”行中的字段总是空的。  
   
1'root' =映射对话框中此地址的顶部元素

  
2.在列***新值***中输入某个变量值，然后按***\[ F7 \]*** 强制或***\[ Ctrl \] +\[ F7 \]*** 写入该值。  
⇒与在声明编辑器或监视列表中进行监视的情况一样，强制变量值显示在带有红色F符号前缀的列***当前值***或写入值中。

![](https://resource.helplook.net/docker_production/3648ne/article/Zv8vUyzD/67207dd8348bc.png)

(1)在控制器上强制值  
(2)未在控制器上使用的值，值以灰色显示

---

### 为强制I/Os生成隐式变量​

在工厂或机器的调试期间，可能需要“强制”输入和输出的值。如果一个设备支持这一点，你可以生成特殊的“强制变量”，并使用它们，例如，在一个HMI可视化。

要求：设备支持该功能。您有一个项目，其中为设备配置了I/O映射，并包含一个程序对象PLC\_PRG。

  
1.通过双击设备树中的设备对象打开设备编辑器，双击***PLC设置***。

2.激活选项生成IO映射的强制变量。

3.按***\[ F11 \]*** 键编译应用程序。  
⇒按照以下语法为每个I/O通道创建两个变量，在此过程中，通道名称中的空格被下划线替换:  
 数据类型为BOOL的\_\_\_Force用于强制的激活和取消。  
通道的数据类型\_\_\_Value用于确定你希望在渠道上强制的值。  
 这些变量在上面描述中的***变量/IoConfig\_Globals\_Force\_Variables***分类中可用。您可以在MetaFacture编程对象、可视化、符号配置等中使用它们。

4.打开功能块***PLC\_PRG***，在实现部分设置焦点，按F2。  
⇒打开输入助手。如前所述，变量可以在***变量/ IoConfig\_Globals\_Force\_Variables***类别中找到。  
 在“强制变量”输入处的上升沿用“值变量”给出的值激活相应的输入或输出。下降沿取消强制。强制新值的要求是通过将变量“强制”复位为FALSEFALSE来实现的。

请注意以下限制。

- 只有在设备的I/O映射中映射到现有或最近创建的变量的通道上，才能通过隐式强制变量强制。
- 对于未使用的输入和输出，或者那些通过应用程序中的AT声明映射到变量的输入和输出，通过隐式强制变量强制是不可能的。
- 您希望通过该机制强制使用的I/O通道必须由MetaFacture在至少一个任务中使用。
- MetaFacture用红色的强制符号标识监控中的强制输入，而不是强制输入/输出! 强制值仅由I/O驱动程序隐式地用于写入设备。

---

### 一个对话框中多个设备的I/O映射​

有一个表显示设备的I/O映射和设备树中插入到它下面的所有子元素的I/O映射。在那里，您可以按照与各自设备编辑器的映射表完全相同的方式编辑I/O映射。

要求：在项目的设备树中插入了几个PLC，每个PLC都支持I/O映射配置。

  
1.选择设备树的根节点，并在右键菜单中单击***编辑I/O映射***。  
⇒编辑I/O映射对话框将打开，其中所有插入到项目中的设备的I/O映射配置将显示在一个表中。您可以使用与关联设备编辑器的I/O映射对话框相同的方式编辑条目。

2.现在，在设备树中选择一个控制对象，并在右键菜单中再次选择***编辑I/O映射***命令。  
⇒***编辑I/O映射***对话框现在只显示I/O表，用于在所选对象中或下找到的I/O映射配置。

3.在表上方的栏中设置所需的过滤器，或者在变量字段的***搜索变量***中输入变量名，以便查看该变量在映射中的使用。  
⇒在此窗口中工作的方法与***I/O映射***选项卡中描述的方法相同。