### 概述

本事例演示使用中科时代自研的工智机连接中科时代的驱动器与电机(以下简称轴)，通过功能块的方式实现轴的转动。

---

### 软硬件配置

硬件：SX5132-A01( 工 智 机 ) SV3S-ES2R8(电机驱动器)、SM3-M3H060-S40B30C-PT1N1(电机型号)

软件：MetaFacture 1.0.4.0

---

### 硬件连接示意图

![](https://resource.helplook.net/docker_production/3648ne/article/b8JVOXur/671626859406f)

---

操作步骤
----

（一）新建工程

打开 MetaFacture 软件，新建一个标准工程，设备选择 sinsegye，编程语言可选择结构化文本（ST）。

（二）查看工智机 IP 地址

1\. 将工智机连接网线、电源、显示器、鼠标、键盘，如下图。

![](https://resource.helplook.net/docker_production/3648ne/article/b8JVOXur/67162685f063b)

中科时代的工智机内置了Ubuntu 系统或 Windows 系统。

Windows 系统，在开始菜单栏输入 CMD 打开终端命令窗口，输入'ipconfig'。

Ubuntu 系统，在终端中输入'ifconfig'。可在显示器上查看对应网口的 IP 地址。

（三）添加驱动器 xml 文件

将 SV3S\_SINSEGYE\_V1.0.xml 该文件添加至 MetaFacture 中。

（四）扫描驱动器与轴

1.在 MetaFacture 1.0.4.0“设备树”中选择【device】并右键，点击【添加设备】。

2.在弹出窗口中，选择【现场总线】-【ethercat】-【主站】-【ethercat master softmotion】， 点击【添加设备】，如下图。

![](https://resource.helplook.net/docker_production/3648ne/article/b8JVOXur/671626867c9ab)

3.双击“设备树”中【Ethercat\_Master\_SoftMotion】，选择【通过名称选择网络】，在【网络名称】中输入，工智机与驱动器相连接的网口名称，在【选项】中勾选【自动重启从站】，如下图。

![](https://resource.helplook.net/docker_production/3648ne/article/b8JVOXur/671afecddf18d.png)

4.在 MetaFacture 中输入正确的 IP 地址，并点击【登录】。

5.选择“设备树”中【Ethercat\_Master\_SoftMotion】，右键选择【扫描设备】。

6.在弹出窗口中，可以看到已经将驱动与轴扫描到了，如下图，点击【复制所有设备到工程】。

![](https://resource.helplook.net/docker_production/3648ne/article/b8JVOXur/671aff142f70a.png)

7.可以看到左侧“设备树”中已添加了驱动器与轴，如下图。

![](https://resource.helplook.net/docker_production/3648ne/article/b8JVOXur/671aff3bbd609.png)

（五）工程基本配置

1.双击“设备树”中【Ethercat\_Master\_SoftMotion】，选择【Ethercat I/O 映射】，在【总线周期任务】选择【EtherCAT\_Task】。

2.右击“设备树”中的【M1\_Servo\_Drive】，选择【添加 SoftMotion CiA402 轴】。

3.右击添加的轴，点击【重构】-【重命名】，在弹出窗口中，输入 A1。

4.在弹出窗口中，点击【确定】。

![](https://resource.helplook.net/docker_production/3648ne/article/b8JVOXur/671aff5bb5022.png)

5.双击新添加的轴驱动，打开配置页面，选择【softmotion 驱动:缩放/映射】，电机类型为【旋转】比例缩放为'8388608' (2^23, 根据伺服电机的编码器位数决定 17 或 23，本案例伺服电机配置的是 23 位编码器）

![](https://resource.helplook.net/docker_production/3648ne/article/b8JVOXur/6716268779b12)

6.在【 SM\_Drive\_ETC\_Master\_GenericDSP402:I/O 映射】 将【 总线周期任务】 改为【EtherCAT\_Task】，如下图。

![](https://resource.helplook.net/docker_production/3648ne/article/b8JVOXur/671aff81e7ad6.png)

---

### 功能块实现轴的转动

1、定义变量

在“变量定义”窗口中，输入以下代码。

> PROGRAM POU VAR
> 
> power1:SM3\_Basic.MC\_Power;
> 
> //X:SM3\_Basic.AXIS\_REF\_SM3; jog1:SM3\_Basic.MC\_Jog;
> 
> p1:BOOL:=FALSE; n1:BOOL;
> 
> VEL1:REAL:=30; END\_VAR

2、代码编写

在“代码区”中输入以下代码。

> power1( Axis:=A1 ,
> 
> Enable:=bExe ,
> 
> bRegulatorOn:=bExe , bDriveStart:=bExe , Status=&gt; ,
> 
> bRegulatorRealState=&gt; , bDriveStartRealState=&gt; , Busy=&gt; ,
> 
> Error=&gt; , ErrorID=&gt; ); jog1(
> 
> Axis:=A1 ,
> 
> JogForward:=p1 ,
> 
> JogBackward:=n1 , Velocity:=VEL1 ,
> 
> Acceleration:=100000 , Deceleration:=100000 , Jerk:=100000 ,
> 
> Busy=&gt; , CommandAborted=&gt; , Error=&gt; ,
> 
> ErrorId=&gt; );

3、轴转动

1.点击【生成代码】-【登录】-【运行】。

2.当驱动器与轴的颜色均变为绿色后，表明metafacture 已识别到设备，将power1 中【enable】置为 true，如下图。

![](https://resource.helplook.net/docker_production/3648ne/article/b8JVOXur/671afff235839.png)

3.将 p1(轴正转)置为 true，VEL1 写入 100，可看到轴已转动。

![](https://resource.helplook.net/docker_production/3648ne/article/b8JVOXur/671afffd1df71.png)

4.同理将 p1 置为 false，n1(轴反转)，可看到轴选择方向改变。