### 概览

SE（全称 SINSEGYE Engineering）是中科时代推出的工程设计、编程与配置一体化工具套件，核心包含 MetaFacture 集成开发环境（IDE）及多款扩展开发环境组件，相较于传统 PLC 开发工具，凭借灵活架构与丰富功能，为工业自动化开发与运维提供全流程解决方案。

---

### 核心优势

**编程模式灵活，适配全技术层级需求**

打破单一开发模式限制，提供三种核心编程方式，让不同技术水平的开发者均能高效作业：

- **经典 PLC 专家模式**：满足资深工程师对 PLC 开发的专业需求；
- **低代码配置模式**：通过 “拖拉拽” 可视化操作完成代码开发，降低技术门槛，提速基础开发；
- **SDK 专家模式**：支持高阶定制化开发，适配复杂场景下的深度需求。

**功能模块丰富，覆盖全场景开发需求**

SE 采用模块化设计，以统一架构与开放接口，形成 8 大核心产品系列，实现 “一套硬件、一套环境、一套代码” 搞定复杂设备控制：

 

| **系列** | **定位** | **关键功能** |
|---|---|---|
| SE1 系列 | 基础开发环境 | 支持 PLC 编程与调试、C/C++ 代码编写与调试，筑牢开发基础 |
| SE2 系列 | AI 开发环境 | 适配时间序列分析、机器视觉、机器学习等算法的应用开发 |
| SE3 系列 | HMI 开发环境 | 专注上位机界面开发，实现设备交互可视化 |
| SE4 系列 | 通讯组件开发环境 | 全面支持 Modbus、TCP/IP、OPC UA 等传统通信协议，及物联网（IoT）MQTT 通信、数据库应用开发 |
| SE5 系列 | UniMotion 运动控制开发环境 | 覆盖单轴 PTP 控制、多轴电子齿轮 / 电子凸轮，及高端 CNC、机器人开发需求 |
| SE6 系列 | Safety 开发环境 | 专项支持安全 PLC 逻辑开发，保障工业场景安全合规 |
| SE8 系列 | HyperCare 工智机管理组态环境 | 提供工智机全生命周期管理与组态能力 |

**智能集成创新，大幅缩短开发周期**

MetaFacture IDE 作为核心载体，融合多项前沿技术：

- 支持通过**电气原理图自动生成硬件组态**，减少手动配置时间；
- 集成 AI 大模型，可**自动生成 PLC 及 C/C++ 代码**，降低重复开发工作量；
- 与三维软件实现信息互通，轻松落地**数字孪生与虚拟调试**；
- 对接 Gitlab 代码仓库，方便代码发布、版本回退与开发过程追溯。

**运维能力升级，提升远程管理效率**

内置 IoT 技术、Tls 加密功能、Debug 调试工具及 Log 日志功能，支持远程设备监控与故障排查，减少手动配置时间，减少现场运维成本，保障设备稳定运行。