### 模块描述

#### SRT3028 模块地址表

| 输入输出信号所占 word 大小 | 以 word 为单位划分 |
|---|---|
| 输入（CPU 模块←SRT3028 模块）（9word） | 0 | 1~8 |
| 状态字 | 数据字 |
| 输出（CPU 模块→SRT3028 模块）（2word） | 0~1 |
| 控制字 |

#### 状态字详细说明

|  | Bit15-Bit2 | Bit1 | Bit0 |
|---|---|---|---|
| Word0 | 保留 | 模块参数配置位\[2\] | 模块通讯状态位\[1\] |

\[1\]通讯状态位

0：通讯状态正常；1：通讯状态故障。\[2\]参数配置位

0：未配置参数；1：配置参数有效。

数据字详细说明

|  | Bit15-Bit0 |
|---|---|
| Word1 | 0 通道数据输入值\[3\] |
| Word2 | 1 通道数据输入值 |
| Word3 | 2 通道数据输入值 |
| Word4 | 3 通道数据输入值 |
| Word5 | 4 通道数据输入值 |
| Word6 | 5 通道数据输入值 |
| Word7 | 6 通道数据输入值 |
| Word8 | 7 通道数据输入值 |

根据不同量程，SRT3028 的输入规则如下

① 0~10V：0V 为 0x0000，10V 为 0xFFFF（输入 10V 时，显示值为 0xFFFF）；

② 0~5V：0V 为 0x0000，5V 为 0xFFFF；

③ 1~5V：1V 为 0x3333，5V 为 0xFFFF（若输入 0~1V，则显示值都为 0x3333）；

④ -10~10V：-10V 为 0x0000，0V 为 0x8000，10V 为 0xFFFF；

⑤ 0~20mA：0mA 为 0x0000，20mA 为 0xFFFF；

⑥ 4~20mA： 4mA 为 0x3333，20mA 为 0xFFFF（若输入 0~4mA，则显示值都为 0x3333）；

⑦ -20~20mA：-20mA 为 0x0000，0V 为 0x8000，20mA 为 0xFFFF。

#### 控制字详细说明

|  | Bit15-Bit14 | Bit13-Bit12 | Bit11 | Bit10-Bit8 | Bit7-Bit6 | Bit5-Bit4 | Bit3 | Bit2-Bit0 |
|---|---|---|---|---|---|---|---|---|
| Word0 | 保留 | CH2、CH3 滤波配置 | CH2、CH3 使能 | CH2、CH3 输入量程设置 | 保留 | CH0、CH1滤波配置\[6\] | CH0、CH1使能\[5\] | CH0、CH1 输入量程设置\[4\] |
| Word1 | 保留 | CH6、CH7 滤波配置 | CH6、CH7 使能 | CH6、CH7 输入量程设置 | 保留 | CH4、CH5滤波配置 | CH4、CH5使能 | CH4 、 CH5输入量程设置 |

\[4\]：SRT3028 支持 7 种输入量程设置，参数配置值高低位说明：左边为高位，右边为低位。（例 001： 最左边第一个‘0’为最高位 Bit2，最右边的‘1’则为最低位 Bit0，\[5\] \[6\]同理）

① 000：0~10V（默认）；

② 001：0~5V；

③ 010：1~5V；

④ 011：-10~10V；

⑤ 100：0~20mA；

⑥ 101：4~20mA；

⑦ 110：-20~20mA 。\[5\]：SRT3028 支持通道使能功能

① 0：通道开启（默认）；

② 1：通道关闭。

\[6\]：SRT3028 支持 4 种滤波时间配置（说明：下面①编号的时间为一个通道的采样时间，若八个通道全开，采样更新周期时间则为 1.2×8 = 9.6ms）

| ① | 00： | 1.2ms（默认）； |
|---|---|---|
| ② | 01： | 0.6ms； |
| ③ | 10： | 2.4ms； |
| ④ | 11： | 12ms。 |