### 模块描述

SRT3804 为 4 通道热电阻输入模块，其还具备以下功能：热电阻材料选择，接线方式选择，滤波速率选择，诊断模块配置是否有效、通讯状态是否正常。SRT3804 共占输入 5word 和输出 2word，模块需配合 SRT 系列耦合器使用，IO 模块无法单独使用；本文描述的模块功能均在 SRT3804 模块与耦合器正常通讯的前提下实现（1word=2byte）。

模块参数配置时注意：在 plc 初始化程序中先设置模块参数，再将耦合器的参数配置位使能，参数配置才可生效；二次修改模块参数配置需要模块断电重启一次才可生效。

#### 模块地址表

| 输入输出信号所占 word 大小 | 以 word 为单位划分 |
|---|---|
| 输入（CPU 模块←SRT3804 模块）（9word） | 0 | 1~4 |
| 状态字 | 数据字 |
| 输出（CPU 模块→SRT3804 模块）（2word） | 0~1 |
| 控制字 |

#### 状态字详细说明

|  | Bit15-Bit2 | Bit1 | Bit0 |
|---|---|---|---|
| Word0 | 保留 | 模块参数配置位\[2\] | 模块通讯状态位\[1\] |

\[1\]通讯状态位  
0：通讯状态正常；1：通讯状态故障。  
\[2\]参数配置位  
0：未配置参数；1：配置参数有效。

#### 数据字详细说明

|  | Bit15-Bit0 |
|---|---|
| Word1 | 0 通道数据输入值\[3\] |
| Word2 | 1 通道数据输入值 |
| Word3 | 2 通道数据输入值 |
| Word4 | 3 通道数据输入值 |

#### 温度输入规则

温度范围-200~800 摄氏度，温度显示值被为摄氏度温度值的 10 倍（数据格式为有符号十进制类型）。

控制字详细说明

|  | **Bit15-Bit14** | **Bit13** | **Bit12-Bit11** | **Bit10** | **Bit9-Bit8** | **Bit7-Bit6** | **Bit5** | **Bit4-3** | **Bit2** | **Bit1-Bit0** |
|---|---|---|---|---|---|---|---|---|---|---|
| Word0 | 保留 | CH1 通道使能 | CH1 滤波配置 | CH1 接线方式设置 | CH1 热电阻材料设置 | 保留 | CH0 通道使能\[7\] | CH0 滤波配置\[6\] | CH0 接线方式设置\[5\] | CH0 热电阻材料设置\[4\] |
| Word1 | 保留 | CH3 通道使能 | CH3 滤波配置 | CH3 接线方式设置 | CH3 热电阻材料设置 | 保留 | CH2 通道使能 | CH2 滤波配置 | CH2 接线方式设置 | CH2 热电阻材料设置 |

SRT3804 支持 4 种热电阻材料设置（参数配置值高低位说明：左边为高位，右边为低位，例如  
01：左边的‘0’为最高位 Bit1，右边的‘1’则为最低位 Bit0，\[5\] \[6\] \[7\]同理）  
① 00：PT100（默认）；  
② 01：PT200；  
③ 10：PT500；  
④ 11：PT1000 。

SRT3804 支持 2 种接线方式  
① 0：三线制（默认）；② 1：二线制。  
\[6\]：SRT3804 支持 4 种滤波时间配置  
① 00：200ms（默认）；  
② 01：1000ms；  
③ 10：100ms；  
④ 11：50ms 。  
\[7\]：SRT3804 支持通道使能功能  
① 0：通道开启（默认）；② 1：通道关闭。